/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;

public class DataGroupFilter
extends AbstractChannelsFilter {
    private final FocalPlaneDataGroup dataGroup;
    private String agentName;
    public static final List<String> FIELDS = new ArrayList<String>();

    public DataGroupFilter(String agents, FocalPlaneDataGroup dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = agents == null || agents.isEmpty() ? null : agents;
    }

    public String getName() {
        return "FP:" + (Object)((Object)this.dataGroup);
    }

    public List<String> getAgents() {
        return this.agentName == null ? null : Collections.singletonList(this.agentName);
    }

    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    public List<String> getOriginChannels() {
        return Collections.singletonList("agent." + DataProviderInfo.Attribute.DATA_GROUP.getName() + "=" + this.dataGroup.getName());
    }

    public String getDisplayPath(String originPath) {
        int i = originPath.indexOf("/");
        if (this.agentName == null) {
            this.agentName = originPath.substring(0, i);
        }
        return originPath.substring(i + 1);
    }

    public String getOriginPath(String displayPath) {
        return this.agentName + "/" + displayPath;
    }

    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }
}

