/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.commons.ui.UiConstants;
import org.lsst.ccs.subsystem.commons.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.ui.CompressorControlPanel;

public class CompressorSummaryPanel
extends JPanel {
    private static final int stateWidth;
    private String comp;
    private final CommandSender sender;
    private final CompressorControlPanel control;
    private JDialog dialog = null;
    private final JLabel nameLabel = new JLabel("Comp:  ");
    private final JLabel nameValue = new JLabel("Cryo6");
    private final JLabel stateLabel = new JLabel("State:  ");
    private final JLabel stateValue = new JLabel("X");
    private final JLabel switchLabel = new JLabel("Enable:  ");
    private final ButtonGroup switchBG = new ButtonGroup();
    private final JRadioButton switchOffRB = new JRadioButton("Off");
    private final JRadioButton switchOnRB = new JRadioButton("On");
    private final JButton controlButton = new JButton("Full Control...");
    private static final long serialVersionUID = 1L;

    public CompressorSummaryPanel(int type, CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        this.control = new CompressorControlPanel(type, cons);
        this.disableSystem();
    }

    public void updateControlPanel(CompState rs) {
        this.comp = rs.getName();
        this.nameValue.setText(this.comp);
        CompressorState cState = rs.getCompressorState();
        Color cColor = cState == CompressorState.OFFLINE ? UiConstants.BLUE : (cState == CompressorState.STOPPED ? Color.BLACK : (cState == CompressorState.RUNNING ? UiConstants.GREEN : (cState == CompressorState.WAITING ? UiConstants.YELLOW : UiConstants.RED)));
        this.stateValue.setText(cState.name());
        this.stateValue.setForeground(cColor);
        SwitchState state = rs.getSwitchState(0);
        JRadioButton selButton = state == SwitchState.ON ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.nameValue.setEnabled(true);
        this.stateValue.setEnabled(true);
        this.switchOffRB.setEnabled(true);
        this.switchOnRB.setEnabled(true);
        this.controlButton.setEnabled(true);
        this.control.updateControlPanel(rs);
        this.repaint();
    }

    public final void disableSystem() {
        this.nameValue.setEnabled(false);
        this.stateValue.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.controlButton.setEnabled(false);
        this.control.disableSystem();
        this.repaint();
    }

    private void initComponents() {
        this.nameLabel.setFont(UiConstants.FONT);
        this.nameValue.setFont(UiConstants.FONT);
        this.nameValue.setPreferredSize(this.nameValue.getPreferredSize());
        this.stateLabel.setFont(UiConstants.FONT);
        this.stateValue.setFont(UiConstants.FONT);
        Dimension d = this.stateValue.getPreferredSize();
        d.width = stateWidth;
        this.stateValue.setPreferredSize(d);
        this.switchLabel.setFont(UiConstants.FONT);
        this.switchOffRB.setFont(UiConstants.FONT);
        this.switchOffRB.setFocusable(false);
        this.switchOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompressorSummaryPanel.this.setSwitchOn(false);
            }
        });
        this.switchOnRB.setFont(UiConstants.FONT);
        this.switchOnRB.setFocusable(false);
        this.switchOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompressorSummaryPanel.this.setSwitchOn(true);
            }
        });
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        JButton button = this.controlButton;
        Insets i = button.getMargin();
        i.left -= 3;
        i.right -= 3;
        button.setMargin(i);
        Dimension dr = button.getPreferredSize();
        dr.height -= 5;
        button.setPreferredSize(dr);
        button.setFont(UiConstants.FONT);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompressorSummaryPanel.this.showHideControl();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 17;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.nameLabel, gbm);
        ++gbm.gridx;
        this.add((Component)this.nameValue, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        this.add((Component)this.stateLabel, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.stateValue, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        this.add((Component)this.switchLabel, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.switchOffRB, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.switchOnRB, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        this.add((Component)this.controlButton, gbm);
    }

    private void setSwitchOn(boolean value) {
        this.sender.sendCommand(this.comp, "setSwitchOn", new Object[]{0, value});
    }

    private void showHideControl() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        this.dialog = new JDialog(window, this.comp + " Control", Dialog.ModalityType.MODELESS);
        this.dialog.add((Component)this.control, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(window);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CompressorSummaryPanel.this.dialog.setVisible(false);
                CompressorSummaryPanel.this.dialog.dispose();
                CompressorSummaryPanel.this.dialog = null;
            }
        });
        this.dialog.setVisible(true);
    }

    static {
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (CompressorState state : CompressorState.values()) {
            label.setText(state.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        stateWidth = width;
    }
}

