/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.PageFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.TreeView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class TabbedView
extends AbstractMonitorView1 {
    private Descriptor descriptor = new Descriptor();
    private final JComponent panel = new JPanel(new BorderLayout());
    private JTabbedPane tabbedPane;
    private final LinkedHashMap<String, AbstractMonitorView2> views = new LinkedHashMap();
    private Function<String, AbstractMonitorView2> viewFactory = name -> {
        TreeView view = new TreeView();
        if (this.formatter != null) {
            view.setFormatter(this.formatter);
        }
        return view;
    };

    @Create(category="MonitorView", name="Tabbed View", path="Built-In/Tabbed", description="Monitoring data view that displays its data in a set of tabs.")
    public TabbedView() {
        this.panel.add(new MonitorDisplay.EMPTY());
    }

    public void setTab(String name, AbstractMonitorView1 view) {
    }

    public void setViewFactory(Function<String, AbstractMonitorView2> factory) {
        this.viewFactory = s -> {
            AbstractMonitorView2 view = (AbstractMonitorView2)factory.apply((String)s);
            if (this.formatter != null) {
                view.setFormatter(this.formatter);
            }
            return view;
        };
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    protected void connect(AgentInfo agent) {
        this.views.values().forEach(view -> view.connect(agent));
    }

    @Override
    protected void disconnect(AgentInfo agent) {
        this.views.values().forEach(view -> view.disconnect(agent));
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        LinkedHashMap<String, Map> allTabs = new LinkedHashMap<String, Map>();
        channels.forEach((path, ch) -> {
            String[] ss = this.split((String)path);
            LinkedHashMap<String, AgentChannel> oneTab = (LinkedHashMap<String, AgentChannel>)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new LinkedHashMap<String, AgentChannel>();
                allTabs.put(ss[0], oneTab);
            }
            oneTab.put(ss[1], (AgentChannel)ch);
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView2 view = this.views.get(tab);
            if (view == null) {
                Persistable.Descriptor d;
                TreeMap<String, Persistable.Descriptor> m;
                view = this.viewFactory.apply((String)tab);
                if (this.filter != null) {
                    view.setFilter(new PageFilter(this.filter, (String)tab));
                }
                if ((m = this.getDescriptor().getTabs()) != null && (d = m.get(tab)) != null) {
                    view.restore(d);
                }
                this.views.put((String)tab, view);
                switch (this.views.size()) {
                    case 0: {
                        this.tabbedPane = null;
                        this.panel.removeAll();
                        this.panel.add(new MonitorDisplay.EMPTY());
                        break;
                    }
                    case 1: {
                        this.tabbedPane = null;
                        this.panel.removeAll();
                        this.panel.add(view.getPanel());
                        break;
                    }
                    case 2: {
                        this.panel.removeAll();
                        this.tabbedPane = new JTabbedPane();
                        this.views.forEach((name, v) -> this.tabbedPane.add((String)name, v.getPanel()));
                        this.panel.add(this.tabbedPane);
                        break;
                    }
                    default: {
                        this.tabbedPane.add((String)tab, view.getPanel());
                    }
                }
            }
            view.addChannels(agent, (Map<String, AgentChannel>)cc);
        });
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        TreeMap<String, List> allTabs = new TreeMap<String, List>();
        paths.forEach(path -> {
            String[] ss = this.split((String)path);
            ArrayList<String> oneTab = (ArrayList<String>)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new ArrayList<String>();
                allTabs.put(ss[0], oneTab);
            }
            oneTab.add(ss[1]);
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView2 view = this.views.get(tab);
            if (view != null) {
                view.removeChannels(agent, (List<String>)cc);
                if (view.isEmpty()) {
                    this.views.remove(tab);
                    switch (this.views.size()) {
                        case 0: {
                            this.tabbedPane = null;
                            this.panel.removeAll();
                            this.panel.add(new MonitorDisplay.EMPTY());
                            break;
                        }
                        case 1: {
                            this.tabbedPane = null;
                            this.panel.removeAll();
                            this.panel.add(this.views.values().iterator().next().getPanel());
                            break;
                        }
                        default: {
                            this.tabbedPane.remove(view.getPanel());
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        TreeMap<String, Map> allTabs = new TreeMap<String, Map>();
        channels.forEach((path, e) -> {
            String[] ss = this.split((String)path);
            HashMap<String, Map.Entry> oneTab = (HashMap<String, Map.Entry>)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new HashMap<String, Map.Entry>();
                allTabs.put(ss[0], oneTab);
            }
            oneTab.put(ss[1], (Map.Entry)e);
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView2 view = this.views.get(tab);
            if (view != null) {
                view.updateChannels(agent, (Map<String, Map.Entry<AgentChannel, List<String>>>)cc);
            }
        });
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor();
        if (!this.views.isEmpty()) {
            TreeMap<String, Persistable.Descriptor> dd = new TreeMap<String, Persistable.Descriptor>();
            desc.setTabs(dd);
            for (Map.Entry<String, AbstractMonitorView2> e : this.views.entrySet()) {
                dd.put(e.getKey(), e.getValue().save());
            }
        }
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
            TreeMap<String, Persistable.Descriptor> dd = this.descriptor.getTabs();
            if (dd != null) {
                for (Map.Entry<String, Persistable.Descriptor> e : dd.entrySet()) {
                    AbstractMonitorView2 v = this.views.get(e.getKey());
                    if (v == null) continue;
                    v.restore(e.getValue());
                }
            }
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    String[] split(String displayPath) {
        String[] out = new String[2];
        int i = displayPath.indexOf("//");
        if (i == -1) {
            out[0] = "";
            out[1] = displayPath;
        } else {
            out[0] = displayPath.substring(0, i);
            out[1] = displayPath.substring(i + 2);
        }
        return out;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private TreeMap<String, Persistable.Descriptor> tabs;

        public TreeMap<String, Persistable.Descriptor> getTabs() {
            return this.tabs;
        }

        public void setTabs(TreeMap<String, Persistable.Descriptor> tabs) {
            this.tabs = tabs;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.tabs != null) {
                desc.tabs = new TreeMap<String, Persistable.Descriptor>((SortedMap<String, Persistable.Descriptor>)desc.tabs);
                desc.tabs.entrySet().forEach(e -> e.setValue(((Persistable.Descriptor)e.getValue()).clone()));
            }
            return desc;
        }
    }
}

