/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Component;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.Segment;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.Template;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.TemplateFilter;

public final class ChannelSelectorDialog
extends JDialog {
    private String[] agents;
    private ArrayList<Template> templates;
    private TemplateFilter.Descriptor descriptor;
    private JComboBox<String> subsystemCombo;
    private JComboBox<Segment> granularityComboIn;
    private JComboBox<Segment> granularityComboOut;
    private JList<Template> templatesIn;
    private JList<Template> templatesOut;
    private JButton addButton;
    private JButton removeButton;
    private JTextField titleField;

    private ChannelSelectorDialog(TemplateFilter.Descriptor desc, Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Select channels", Dialog.ModalityType.APPLICATION_MODAL);
        this.descriptor = desc;
        List all = Console.getConsole().getStatusAggregator().getChannels(new String[]{Segment.RAFT.getKey()});
        TreeSet aa = new TreeSet();
        TreeSet tt = new TreeSet();
        all.forEach(channel -> {
            aa.add(channel.getAgentName());
            Template t = Template.valueOf(channel);
            if (t != null) {
                tt.add(t);
            }
        });
        this.agents = aa.toArray(new String[aa.size()]);
        this.templates = new ArrayList(tt);
        Box rootPanel = Box.createVerticalBox();
        this.add((Component)rootPanel, "Center");
        rootPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box channelsPanel = Box.createVerticalBox();
        rootPanel.add(channelsPanel);
        channelsPanel.setBorder(BorderFactory.createTitledBorder("Channel selection"));
        Box box = Box.createHorizontalBox();
        channelsPanel.add(box);
        box.add(new JLabel("Subsystem: "));
        this.subsystemCombo = new JComboBox<String>(this.agents);
        box.add(this.subsystemCombo);
        this.subsystemCombo.addActionListener(e -> this.updateTemplatesIn());
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Granularity: "));
        this.granularityComboIn = new JComboBox<Segment>(Segment.values());
        box.add(this.granularityComboIn);
        this.granularityComboIn.addActionListener(e -> this.updateTemplatesIn());
        box.add(Box.createHorizontalGlue());
        channelsPanel.add(Box.createRigidArea(Const.VDIM));
        this.templatesIn = new JList();
        channelsPanel.add(new JScrollPane(this.templatesIn));
        this.templatesIn.setSelectionMode(0);
        this.templatesIn.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, ((Template)value).code, index, isSelected, cellHasFocus);
            }
        });
        this.templatesIn.addListSelectionListener(e -> this.addButton.setEnabled(this.templatesIn.getSelectedValue() != null));
        box = Box.createHorizontalBox();
        rootPanel.add(box);
        box.add(Box.createHorizontalGlue());
        this.addButton = new JButton("  Add  ");
        box.add(this.addButton);
        this.addButton.addActionListener(e -> {
            Template template = this.templatesIn.getSelectedValue();
            if (template != null) {
                DefaultListModel out = (DefaultListModel)this.templatesOut.getModel();
                out.addElement(template);
                DefaultListModel in = (DefaultListModel)this.templatesIn.getModel();
                in.removeElement(template);
            }
        });
        this.addButton.setEnabled(false);
        box.add(Box.createRigidArea(Const.HDIM));
        this.removeButton = new JButton("Remove");
        box.add(this.removeButton);
        this.removeButton.addActionListener(e -> {
            Template template = this.templatesOut.getSelectedValue();
            if (template != null) {
                DefaultListModel out = (DefaultListModel)this.templatesOut.getModel();
                out.removeElement(template);
                this.updateTemplatesIn();
            }
        });
        this.removeButton.setEnabled(false);
        box.add(Box.createRigidArea(Const.HDIM));
        Box filterPanel = Box.createVerticalBox();
        rootPanel.add(filterPanel);
        filterPanel.setBorder(BorderFactory.createTitledBorder("Focal plane map"));
        box = Box.createHorizontalBox();
        filterPanel.add(box);
        box.add(new JLabel("Title: "));
        this.titleField = new JTextField(20);
        box.add(this.titleField);
        box.add(Box.createHorizontalGlue());
        filterPanel.add(Box.createRigidArea(Const.VDIM));
        this.templatesOut = new JList(new DefaultListModel());
        filterPanel.add(new JScrollPane(this.templatesOut));
        this.templatesOut.setSelectionMode(0);
        this.templatesOut.addListSelectionListener(e -> this.removeButton.setEnabled(this.templatesOut.getSelectedValue() != null));
        this.granularityComboOut = new JComboBox<Segment>(Segment.values());
        box = Box.createHorizontalBox();
        this.add((Component)box, "South");
        box.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        box.add(cancelButton);
        cancelButton.addActionListener(e -> {
            this.descriptor = null;
            this.dispose();
        });
        box.add(Box.createRigidArea(Const.HDIM));
        JButton okButton = new JButton(" OK ");
        box.add(okButton);
        okButton.addActionListener(e -> {
            this.writeDescriptor();
            this.dispose();
        });
        this.readDescriptor();
    }

    public static TemplateFilter.Descriptor show(TemplateFilter.Descriptor descriptor, Component parentComponent) {
        if (parentComponent == null) {
            parentComponent = Console.getConsole().getWindow();
        }
        ChannelSelectorDialog dialog = new ChannelSelectorDialog(descriptor, parentComponent);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog.descriptor;
    }

    private void updateTemplatesIn() {
        String agent = (String)this.subsystemCombo.getSelectedItem();
        Segment segment = (Segment)((Object)this.granularityComboIn.getSelectedItem());
        DefaultListModel<Template> inModel = new DefaultListModel<Template>();
        DefaultListModel outModel = (DefaultListModel)this.templatesOut.getModel();
        for (Template template : this.templates) {
            if (!template.segment.equals((Object)segment) || !template.getAgent().equals(agent) || outModel.contains(template)) continue;
            inModel.addElement(template);
        }
        this.templatesIn.setModel(inModel);
    }

    private void readDescriptor() {
        if (this.descriptor == null) {
            this.granularityComboOut.setSelectedItem((Object)Segment.AMP);
        } else {
            String title = this.descriptor.getName();
            if (title != null) {
                this.titleField.setText(title);
            }
            DefaultListModel out = (DefaultListModel)this.templatesOut.getModel();
            String[] tt = this.descriptor.getTemplates();
            if (tt == null) {
                tt = new String[]{};
            }
            for (String s : tt) {
                try {
                    Template t = Template.valueOf(s);
                    out.addElement(t);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            String gran = this.descriptor.getGranularity();
            try {
                this.granularityComboOut.setSelectedItem((Object)Segment.valueOf(gran));
            }
            catch (IllegalArgumentException | NullPointerException x) {
                this.granularityComboOut.setSelectedItem((Object)Segment.AMP);
            }
        }
        this.updateTemplatesIn();
    }

    private void writeDescriptor() {
        DefaultListModel out;
        int n;
        Segment segment;
        this.descriptor = new TemplateFilter.Descriptor();
        String title = this.titleField.getText().trim();
        if (!title.isEmpty()) {
            this.descriptor.setName(title);
        }
        if ((segment = (Segment)((Object)this.granularityComboOut.getSelectedItem())) != null && !Segment.AMP.equals((Object)segment)) {
            this.descriptor.setGranularity(segment.name());
        }
        if ((n = (out = (DefaultListModel)this.templatesOut.getModel()).getSize()) > 0) {
            String[] tt = new String[n];
            for (int i = 0; i < n; ++i) {
                tt[i] = ((Template)out.get(i)).toString();
            }
            this.descriptor.setTemplates(tt);
        }
    }
}

