/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapRegion;

public final class FocalPlaneMapPage
extends JPanel
implements HasPopupItems {
    private final Descriptor descriptor;
    private final ArrayList<FocalPlaneMapRegion> regions;

    public FocalPlaneMapPage(Descriptor desc) {
        this.descriptor = desc == null ? new Descriptor() : desc;
        this.setLayout(new GridLayout(this.descriptor.getRows(), this.descriptor.getColumns(), 10, 5));
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = this.descriptor.getRegions();
        int n = this.descriptor.getRows() * this.descriptor.getColumns();
        this.regions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            FocalPlaneMapRegion.Descriptor regionDesc;
            FocalPlaneMapRegion.Descriptor descriptor = regionDesc = regionDescriptors == null ? null : regionDescriptors[i];
            if (regionDesc == null) {
                regionDesc = new FocalPlaneMapRegion.Descriptor();
                regionDesc.setAgent(this.descriptor.getAgent());
            }
            FocalPlaneMapRegion region = new FocalPlaneMapRegion(regionDesc);
            this.add(region);
            this.regions.add(region);
        }
    }

    public void opened() {
        this.regions.forEach(region -> region.opened());
    }

    public void closed() {
        this.regions.forEach(region -> region.closed());
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
        Component c = this.getComponentAt(point);
        if (c instanceof FocalPlaneMapRegion) {
            ((FocalPlaneMapRegion)c).modifyPopupMenu(menu);
        }
        return menu;
    }

    public Descriptor save() {
        int n = this.regions.size();
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = new FocalPlaneMapRegion.Descriptor[n];
        for (int i = 0; i < n; ++i) {
            regionDescriptors[i] = this.regions.get(i).save();
        }
        this.descriptor.setRegions(regionDescriptors);
        this.descriptor.setPage(DataPanelDescriptor.get((JComponent)this));
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
        private String name;
        private String agent;
        private int rows;
        private int columns;
        private FocalPlaneMapRegion.Descriptor[] regions;
        private DataPanelDescriptor page;

        public Descriptor() {
            this(null, 1, 1);
        }

        public Descriptor(String agentName, int nRows, int nColumns) {
            this.agent = agentName;
            this.rows = nRows;
            this.columns = nColumns;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public FocalPlaneMapRegion.Descriptor[] getRegions() {
            return this.regions;
        }

        public void setRegions(FocalPlaneMapRegion.Descriptor[] regions) {
            this.regions = regions;
        }

        public DataPanelDescriptor getPage() {
            return this.page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
    }
}

