/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.comcamvacuum.data.ComCamVacuumAgentProperties;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;
import org.lsst.ccs.subsystem.comcamvacuum.ui.ComCamVacControlPanel;
import org.lsst.ccs.subsystem.comcamvacuum.ui.ComCamVacuumPage;
import org.lsst.ccs.subsystem.comcamvacuum.ui.jas.ComCamVacControlFilter;
import org.lsst.ccs.subsystem.comcamvacuum.ui.jas.CommandSender;

@Plugin(name="ComCam Vacuum Control Plugin", description="ComCam Vacuum Control Plugin")
public class ComCamVacControlPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new ComCamVacImageOptionalPage());
        OptionalPage.getService().add((OptionalPage)new ComCamVacControlOptionalPage());
    }

    static class BusListener
    implements StatusMessageListener {
        private final ComCamVacControlPanel controls;
        private final String agentName;

        BusListener(ComCamVacControlPanel controls, String agentName) {
            this.controls = controls;
            this.agentName = agentName;
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("ComCamVacuumState")) {
                    this.controls.updateControlPanel((VacSysState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }
    }

    static class ComCamVacImageOptionalPage
    implements OptionalPage {
        private ComCamVacuumPage vacuumPage;

        ComCamVacImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY) ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.vacuumPage = new ComCamVacuumPage(agent);
            JComponent panel = this.vacuumPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        public void opened(String page) {
            this.vacuumPage.getView().install();
        }

        public void closed(String page) {
            this.vacuumPage.getView().uninstall();
            this.vacuumPage = null;
        }
    }

    static class ComCamVacControlOptionalPage
    implements OptionalPage {
        private final CommandSender cmdSender = new CommandSender();
        private final Map<String, BusListener> busListeners = new ConcurrentHashMap<String, BusListener>();

        ComCamVacControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY) ? this.getPageName(agent) : null;
        }

        public boolean agentDisconnected(AgentInfo agent) {
            BusListener listener = this.busListeners.get(this.getPageName(agent));
            if (listener == null) {
                return true;
            }
            listener.controls.disableSystem();
            return false;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String pageName = this.getPageName(agent);
            String agentName = agent.getName();
            BusListener listener = this.busListeners.get(pageName);
            if (listener != null) {
                this.initControls(agentName, listener.controls);
                return existingComponent;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setName(agentName + " Control");
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            ComCamVacControlFilter monitorFilter = new ComCamVacControlFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            panel.add((Component)view.getPanel(), "Center");
            ComCamVacControlPanel controls = new ComCamVacControlPanel(this.cmdSender);
            controls.setSubsystem(agent.getName());
            panel.add((Component)controls, "South");
            listener = new BusListener(controls, agent.getName());
            AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
            aml.addStatusMessageListener((StatusMessageListener)listener, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            this.busListeners.put(pageName, listener);
            this.initControls(agentName, controls);
            return panel;
        }

        public void closed(String pageName) {
            BusListener listener = this.busListeners.remove(pageName);
            if (listener == null) {
                throw new RuntimeException("No page exists with the name " + pageName);
            }
            Console.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        }

        private String getPageName(AgentInfo agent) {
            return "CCS Subsystems/" + agent.getName() + "/Control";
        }

        private void initControls(String agentName, ComCamVacControlPanel controls) {
            Object response = this.cmdSender.sendCommand(agentName, null, "getVacuumState", new Object[0]);
            if (response instanceof VacSysState) {
                controls.updateControlPanel((VacSysState)response);
            }
        }
    }
}

