/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class CreatorExecutable
implements Creator {
    private final Executable exec;
    private final Object object;

    public CreatorExecutable(Executable exec, Object object) {
        if (!(exec instanceof Method) && !(exec instanceof Constructor) || exec.getAnnotation(Create.class) == null || exec.getAnnotation(Create.class).path().trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.exec = exec;
        this.object = object;
    }

    @Override
    public String getCategory() {
        return this.exec.getAnnotation(Create.class).category();
    }

    @Override
    public String getPath() {
        return this.exec.getAnnotation(Create.class).path();
    }

    @Override
    public String getName() {
        return this.exec.getAnnotation(Create.class).name();
    }

    @Override
    public String getDescription() {
        return this.exec.getAnnotation(Create.class).description();
    }

    @Override
    public Parameter[] getParameters() {
        return this.exec.getParameters();
    }

    @Override
    public String[] getParameterDescriptions() {
        Parameter[] pp = this.getParameters();
        String[] dd = new String[pp.length];
        int i = pp.length;
        while (i-- > 0) {
            Par an = pp[i].getAnnotation(Par.class);
            dd[i] = an == null ? "" : an.desc();
        }
        return dd;
    }

    @Override
    public Persistable make(Object ... parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Persistable out = this.exec instanceof Method ? (Persistable)((Method)this.exec).invoke(this.object, parameters) : (Persistable)((Constructor)this.exec).newInstance(parameters);
        Creator.Descriptor desc = new Creator.Descriptor();
        desc.setCategory(this.getCategory());
        desc.setPath(this.getPath());
        int n = parameters.length;
        if (n > 0) {
            Parameter[] pars = this.getParameters();
            String[] sp = new String[n];
            for (int i = 0; i < n; ++i) {
                sp[i] = Creator.encode(parameters[i], pars[i].getParameterizedType());
            }
            desc.setParameters(sp);
        }
        out.getDescriptor().setCreator(desc);
        return out;
    }

    @Override
    public Persistable make(String ... parametersAsStrings) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Parameter[] pars = this.getParameters();
        int n = pars.length;
        Object[] values = new Object[n];
        for (int i = 0; i < n; ++i) {
            values[i] = Creator.decode(parametersAsStrings[i], pars[i].getParameterizedType());
        }
        return this.make(values);
    }
}

