/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.CryoCompState;
import org.lsst.ccs.subsystem.refrig.ui.UiConstants;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class CompressorControlPanel
extends JPanel {
    static final String[] switchNames = new String[7];
    static final String[] latchNames;
    static final String[] conditionNames;
    static final String[] swCondNames;
    private static final int compStateWidth;
    private static final int switchStateWidth;
    private static final int latchStateWidth;
    private static final int conditionStateWidth;
    private static final int swCondStateWidth;
    private String comp;
    private final CommandSender sender;
    private final Collection<Integer> validSwitches;
    private final Collection<Integer> validLatches;
    private final Collection<Integer> validConditions;
    private final Collection<Integer> validSwConds;
    private final JPanel headPanel = new JPanel();
    private final JLabel compLabel = new JLabel("Compressor:  ");
    private final JLabel compName = new JLabel("MM99");
    private final JLabel stateLabel = new JLabel("State:  ");
    private final JLabel compState = new JLabel("STOPPED");
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[7];
    private final JLabel[] switchStatus = new JLabel[7];
    private final ButtonGroup[] switchBG = new ButtonGroup[7];
    private final JRadioButton[] switchOffRB = new JRadioButton[7];
    private final JRadioButton[] switchOnRB = new JRadioButton[7];
    private final JPanel latchPanel = new JPanel();
    private final JLabel[] latchLabel = new JLabel[10];
    private final JLabel[] latchStatus = new JLabel[10];
    private final JButton resetButton = new JButton("Reset");
    private final JPanel conditionPanel = new JPanel();
    private final JLabel[] conditionLabel = new JLabel[16];
    private final JLabel[] conditionStatus = new JLabel[16];
    private final JPanel swCondPanel = new JPanel();
    private final JLabel[] swCondLabel = new JLabel[8];
    private final JLabel[] swCondStatus = new JLabel[8];
    private static final long serialVersionUID = 1L;

    public CompressorControlPanel(int type, CommandSender cons) {
        this.sender = cons;
        this.validSwitches = type == 0 ? ColdCompState.SWITCHES : CryoCompState.SWITCHES;
        this.validLatches = type == 0 ? ColdCompState.LATCHES : CryoCompState.LATCHES;
        this.validConditions = type == 0 ? ColdCompState.CONDITIONS : CryoCompState.CONDITIONS;
        this.validSwConds = type == 0 ? ColdCompState.SW_CONDITIONS : CryoCompState.SW_CONDITIONS;
        this.initComponents();
        this.disableSystem();
    }

    public void updateControlPanel(CompState rs) {
        Color color;
        Enum state;
        this.comp = rs.getName();
        this.compName.setText(this.comp);
        this.compName.setEnabled(true);
        CompressorState cState = rs.getCompressorState();
        Color cColor = cState == CompressorState.OFFLINE ? UiConstants.BLUE : (cState == CompressorState.STOPPED ? Color.BLACK : (cState == CompressorState.RUNNING ? UiConstants.GREEN : (cState == CompressorState.WAITING ? UiConstants.YELLOW : UiConstants.RED)));
        this.compState.setText(cState.name());
        this.compState.setForeground(cColor);
        this.compState.setEnabled(true);
        for (int sw : rs.getValidSwitches()) {
            state = rs.getSwitchState(sw);
            String text = state.name();
            Color color2 = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
            this.switchStatus[sw].setText(text);
            this.switchStatus[sw].setForeground(color2);
            this.switchStatus[sw].setEnabled(true);
            JRadioButton selButton = state == SwitchState.ON ? this.switchOnRB[sw] : this.switchOffRB[sw];
            selButton.setSelected(true);
            this.switchOffRB[sw].setEnabled(true);
            this.switchOnRB[sw].setEnabled(true);
        }
        for (int cond : rs.getValidLatches()) {
            state = rs.getLatchState(cond);
            color = state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.WARNING ? UiConstants.YELLOW : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
            this.latchStatus[cond].setText(state.name());
            this.latchStatus[cond].setForeground(color);
            this.latchStatus[cond].setEnabled(true);
        }
        this.resetButton.setEnabled(true);
        for (int cond : rs.getValidConditions()) {
            state = rs.getConditionState(cond);
            color = state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN);
            this.conditionStatus[cond].setText(state.name());
            this.conditionStatus[cond].setForeground(color);
            this.conditionStatus[cond].setEnabled(true);
        }
        for (int cond : rs.getValidSwConditions()) {
            state = rs.getSwConditionState(cond);
            Color color3 = state == SwCondState.OFFLINE ? UiConstants.BLUE : (state == SwCondState.CLEAR ? UiConstants.GREEN : (color = state == SwCondState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE));
            if (this.swCondStatus[cond] == null) {
                System.out.println("Can't handle sw condition " + cond + " for compressor " + rs.getName());
                continue;
            }
            this.swCondStatus[cond].setText(state.name());
            this.swCondStatus[cond].setForeground(color);
            this.swCondStatus[cond].setEnabled(true);
        }
        this.repaint();
    }

    public final void disableSystem() {
        this.compName.setEnabled(false);
        this.compState.setEnabled(false);
        for (int sw : this.validSwitches) {
            this.switchStatus[sw].setEnabled(false);
            this.switchOffRB[sw].setEnabled(false);
            this.switchOnRB[sw].setEnabled(false);
        }
        for (int cond : this.validLatches) {
            this.latchStatus[cond].setEnabled(false);
        }
        this.resetButton.setEnabled(false);
        for (int cond : this.validConditions) {
            this.conditionStatus[cond].setEnabled(false);
        }
        for (int cond : this.validSwConds) {
            this.swCondStatus[cond].setEnabled(false);
        }
        this.repaint();
    }

    private void initComponents() {
        Dimension d;
        JLabel label;
        Iterator<Integer> d2;
        JLabel label2;
        this.compLabel.setFont(UiConstants.FONT);
        this.compName.setFont(UiConstants.FONT);
        this.stateLabel.setFont(UiConstants.FONT);
        this.compState.setFont(UiConstants.FONT);
        Dimension di = this.compState.getPreferredSize();
        di.width = compStateWidth;
        this.compState.setPreferredSize(di);
        for (int sw : this.validSwitches) {
            label2 = this.switchLabel[sw] = new JLabel(switchNames[sw] + ":");
            label2.setFont(UiConstants.FONT);
            label2 = this.switchStatus[sw] = new JLabel("XXX");
            label2.setFont(UiConstants.FONT);
            d2 = label2.getPreferredSize();
            ((Dimension)((Object)d2)).width = switchStateWidth;
            label2.setPreferredSize((Dimension)((Object)d2));
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton("Off");
            buttonOff.setFont(UiConstants.FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    CompressorControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = this.switchOnRB[sw] = new JRadioButton("On");
            buttonOn.setFont(UiConstants.FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    CompressorControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }
        for (int cond : this.validLatches) {
            label2 = this.latchLabel[cond] = new JLabel(latchNames[cond] + ":");
            label2.setFont(UiConstants.FONT);
            label2 = this.latchStatus[cond] = new JLabel("XXX");
            label2.setFont(UiConstants.FONT);
            d2 = label2.getPreferredSize();
            ((Dimension)((Object)d2)).width = latchStateWidth;
            label2.setPreferredSize((Dimension)((Object)d2));
        }
        JButton button = this.resetButton;
        Insets i = button.getMargin();
        i.left -= 3;
        i.right -= 3;
        button.setMargin(i);
        Dimension dr = button.getPreferredSize();
        dr.height -= 9;
        button.setPreferredSize(dr);
        button.setFont(UiConstants.FONT);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = ((JButton)evt.getSource()).getName();
                CompressorControlPanel.this.resetLatches();
            }
        });
        d2 = this.validConditions.iterator();
        while (d2.hasNext()) {
            int cond = (Integer)d2.next();
            label = this.conditionLabel[cond] = new JLabel(conditionNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.conditionStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = conditionStateWidth;
            label.setPreferredSize(d);
        }
        for (int cond : this.validSwConds) {
            label = this.swCondLabel[cond] = new JLabel(swCondNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.swCondStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = swCondStateWidth;
            label.setPreferredSize(d);
        }
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.anchor = 18;
        gbh.gridx = 0;
        gbh.gridy = 0;
        this.headPanel.add((Component)this.compLabel, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.compName, gbh);
        ++gbh.gridx;
        gbh.insets.left = 30;
        this.headPanel.add((Component)this.stateLabel, gbh);
        ++gbh.gridx;
        gbh.insets.left = 0;
        this.headPanel.add((Component)this.compState, gbh);
        TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), "Switches");
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        border.setTitleColor(UiConstants.BLUE);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        int ncols = 2;
        int colm = 0;
        for (int sw : this.validSwitches) {
            if (colm == 0) {
                gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 6;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.top -= 4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 0;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            gbs.insets.top += 4;
            ++gbs.gridx;
            colm = (colm + 1) % ncols;
        }
        border = new TitledBorder(new LineBorder(Color.BLACK), "PLC Error Conditions");
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        border.setTitleColor(UiConstants.BLUE);
        this.latchPanel.setBorder(border);
        this.latchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 18;
        gbl.gridy = 0;
        gbl.insets.bottom = 4;
        gbl.insets.right = 4;
        ncols = 1;
        colm = 0;
        for (int cond : this.validLatches) {
            if (colm == 0) {
                gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.left = colm == 0 ? 4 : 30;
            this.latchPanel.add((Component)this.latchLabel[cond], gbl);
            gbl.insets.left = 6;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbl);
            ++gbl.gridx;
            colm = (colm + 1) % ncols;
        }
        gbl.anchor = 11;
        gbl.gridwidth = 2 * ncols;
        gbl.gridx = 0;
        ++gbl.gridy;
        gbl.insets.top = 4;
        this.latchPanel.add((Component)this.resetButton, gbl);
        border = new TitledBorder(new LineBorder(Color.BLACK), "PLC Running Conditions");
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        border.setTitleColor(UiConstants.BLUE);
        this.conditionPanel.setBorder(border);
        this.conditionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.insets.bottom = 4;
        gbc.insets.right = 4;
        ncols = 2;
        colm = 0;
        for (int cond : this.validConditions) {
            if (colm == 0) {
                gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.left = colm == 0 ? 4 : 30;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            gbc.insets.left = 6;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % ncols;
        }
        border = new TitledBorder(new LineBorder(Color.BLACK), "CCS Error Conditions");
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        border.setTitleColor(UiConstants.BLUE);
        this.swCondPanel.setBorder(border);
        this.swCondPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbw = new GridBagConstraints();
        gbw.anchor = 18;
        gbw.gridy = 0;
        gbw.insets.bottom = 4;
        gbw.insets.right = 4;
        ncols = 2;
        colm = 0;
        for (int cond : this.validSwConds) {
            if (colm == 0) {
                gbw.insets.top = gbw.gridy == 0 ? 4 : 0;
                gbw.gridx = 0;
                ++gbw.gridy;
            }
            gbw.insets.left = colm == 0 ? 4 : 30;
            this.swCondPanel.add((Component)this.swCondLabel[cond], gbw);
            gbw.insets.left = 6;
            ++gbw.gridx;
            this.swCondPanel.add((Component)this.swCondStatus[cond], gbw);
            ++gbw.gridx;
            colm = (colm + 1) % ncols;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 6, 6, 6);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.gridwidth = 2;
        this.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        gbm.gridwidth = 1;
        gbm.gridheight = 2;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridx;
        gbm.gridheight = 1;
        this.add((Component)this.conditionPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.swCondPanel, gbm);
    }

    private void setSwitchOn(int sw, boolean value) {
        this.sender.sendCommand(this.comp, "setSwitchOn", sw, value);
    }

    private void resetLatches() {
        this.sender.sendCommand(this.comp, "resetLatches", new Object[0]);
    }

    static {
        CompressorControlPanel.switchNames[0] = "Enable";
        CompressorControlPanel.switchNames[2] = "Lights";
        CompressorControlPanel.switchNames[1] = "Heater";
        CompressorControlPanel.switchNames[3] = "Orifice Valve";
        CompressorControlPanel.switchNames[4] = "Coolant Valve";
        CompressorControlPanel.switchNames[5] = "Bypass Valve";
        CompressorControlPanel.switchNames[6] = "Surge Heater";
        latchNames = new String[10];
        CompressorControlPanel.latchNames[3] = "Discharge Press";
        CompressorControlPanel.latchNames[0] = "Discharge Temp";
        CompressorControlPanel.latchNames[5] = "External Permit";
        CompressorControlPanel.latchNames[2] = "Liquid Temp";
        CompressorControlPanel.latchNames[4] = "Compressr Power";
        CompressorControlPanel.latchNames[7] = "Sensor Readings";
        CompressorControlPanel.latchNames[6] = "Smoke Detector";
        CompressorControlPanel.latchNames[1] = "Suction Temp";
        CompressorControlPanel.latchNames[8] = "After Cooler";
        CompressorControlPanel.latchNames[9] = "Oil Level";
        conditionNames = new String[16];
        CompressorControlPanel.conditionNames[1] = "Compr enabled";
        CompressorControlPanel.conditionNames[2] = "Compr waiting";
        CompressorControlPanel.conditionNames[3] = "Compr powered";
        CompressorControlPanel.conditionNames[9] = "Current valid";
        CompressorControlPanel.conditionNames[7] = "Disch press valid";
        CompressorControlPanel.conditionNames[4] = "Disch temp valid";
        CompressorControlPanel.conditionNames[0] = "Keyswitch on";
        CompressorControlPanel.conditionNames[11] = "Latches clear";
        CompressorControlPanel.conditionNames[6] = "Liquid temp valid";
        CompressorControlPanel.conditionNames[12] = "Power LED On";
        CompressorControlPanel.conditionNames[8] = "Suctn press valid";
        CompressorControlPanel.conditionNames[5] = "Suctn temp valid";
        CompressorControlPanel.conditionNames[10] = "Voltage valid";
        CompressorControlPanel.conditionNames[13] = "Current sens err";
        CompressorControlPanel.conditionNames[14] = "Compr on 6 hrs";
        CompressorControlPanel.conditionNames[15] = "Oil level valid";
        swCondNames = new String[8];
        CompressorControlPanel.swCondNames[3] = "Compr power";
        CompressorControlPanel.swCondNames[0] = "Disch press";
        CompressorControlPanel.swCondNames[1] = "Disch temp";
        CompressorControlPanel.swCondNames[7] = "Liquid temp";
        CompressorControlPanel.swCondNames[6] = "Oil Level";
        CompressorControlPanel.swCondNames[4] = "Phase sep temp";
        CompressorControlPanel.swCondNames[2] = "Suction temp";
        CompressorControlPanel.swCondNames[5] = "Plate temp";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (CompressorState compressorState : CompressorState.values()) {
            label.setText(compressorState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        compStateWidth = width;
        width = 0;
        for (Enum enum_ : SwitchState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStateWidth = width;
        width = 0;
        for (Enum enum_ : LatchState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        latchStateWidth = width;
        width = 0;
        for (Enum enum_ : ConditionState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        conditionStateWidth = width;
        width = 0;
        for (Enum enum_ : SwCondState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        swCondStateWidth = width;
    }
}

