/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IFitData;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.function.AbstractIFunction;

public class NonParametricFunction
extends AbstractIFunction {
    private boolean mirrorLeft = false;
    private boolean mirrorRight = false;
    private double rho = 1.0;
    private int nPoints = 1000;
    private double[] lookupTable;
    private int nEvents;
    private double binWidth;
    private double[] dataPts;
    private double[] weights;
    double upperLimit = Double.NaN;
    double lowerLimit = Double.NaN;
    private static final double sqrt2pi = Math.sqrt(Math.PI * 2);

    public NonParametricFunction(String title, IFitData data) {
        super(title, data.dimension(), 1);
        if (data.dimension() != 1) {
            throw new IllegalArgumentException("Only one dimensional non-parametric functions are supported!");
        }
        IDevFitDataIterator dataIter = ((IDevFitData)data).dataIterator();
        this.lookupTable = new double[this.nPoints + 1];
        this.nEvents = dataIter.entries();
        if (this.mirrorLeft) {
            this.nEvents += dataIter.entries();
        }
        if (this.mirrorRight) {
            this.nEvents += dataIter.entries();
        }
        dataIter.start();
        while (dataIter.next()) {
            double x = dataIter.vars()[0];
            if (Double.isNaN(this.upperLimit) || x > this.upperLimit) {
                this.upperLimit = x;
            }
            if (!Double.isNaN(this.lowerLimit) && !(x < this.lowerLimit)) continue;
            this.lowerLimit = x;
        }
        this.binWidth = (this.upperLimit - this.lowerLimit) / (double)(this.nPoints - 1);
        this.dataPts = new double[this.nEvents];
        this.weights = new double[this.nEvents];
        double entries = 0.0;
        double m = 0.0;
        double r = 0.0;
        int dataCount = 0;
        dataIter.start();
        while (dataIter.next()) {
            double x;
            this.dataPts[dataCount] = x = dataIter.vars()[0];
            entries += 1.0;
            m += x;
            r += x * x;
            ++dataCount;
            if (this.mirrorLeft) {
                this.dataPts[dataCount] = 2.0 * this.lowerLimit - x;
                ++dataCount;
            }
            if (!this.mirrorRight) continue;
            this.dataPts[dataCount] = 2.0 * this.upperLimit - x;
            ++dataCount;
        }
        double mean = m / entries;
        double sigma = Math.sqrt(r / entries - mean * mean);
        double h = Math.pow(1.3333333333333333, 0.2) * Math.pow(this.nEvents, -0.2) * this.rho;
        double hmin = h * sigma * Math.sqrt(2.0) / 10.0;
        double norm = h * Math.sqrt(sigma) / (2.0 * Math.sqrt(3.0));
        for (int j = 0; j < this.nEvents; ++j) {
            this.weights[j] = norm / Math.sqrt(this.gauss(this.dataPts[j], h * sigma));
            if (!(this.weights[j] < hmin)) continue;
            this.weights[j] = hmin;
        }
        for (int i = 0; i < this.nPoints + 1; ++i) {
            this.lookupTable[i] = this.evaluateFull(this.lowerLimit + (double)i * this.binWidth);
        }
    }

    @Override
    public String normalizationParameter() {
        return null;
    }

    private double gauss(double x, double sigma) {
        double c = 1.0 / (2.0 * sigma * sigma);
        double y = 0.0;
        for (int i = 0; i < this.nEvents; ++i) {
            double r = x - this.dataPts[i];
            y += Math.exp(-c * r * r);
        }
        return y / (sigma * sqrt2pi * (double)this.nEvents);
    }

    @Override
    public double value(double[] v) {
        double x = v[0];
        int i = (int)Math.floor((x - this.lowerLimit) / this.binWidth);
        if (i < 0) {
            i = 0;
        }
        if (i > this.nPoints - 1) {
            i = this.nPoints - 1;
        }
        double dx = (x - (this.lowerLimit + (double)i * this.binWidth)) / this.binWidth;
        double val = this.lookupTable[i] + dx * (this.lookupTable[i + 1] - this.lookupTable[i]);
        return val;
    }

    private double evaluateFull(double x) {
        double y = 0.0;
        for (int i = 0; i < this.nEvents; ++i) {
            double chi = (x - this.dataPts[i]) / this.weights[i];
            y += Math.exp(-0.5 * chi * chi) / this.weights[i];
        }
        return y / (sqrt2pi * (double)this.nEvents);
    }
}

