/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmLatches;
import org.lsst.ccs.subsystem.utility.constants.MpmSwitches;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;

public class MpmControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String[] plcNames = new String[3];
    private static final String[] switchNames;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int plcStateWidth;
    private static final int switchStateWidth;
    private static final int latchStateWidth;
    private static final int conditionStateWidth;
    private SystemStatusPanel systemPanel;
    private JPanel plcPanel;
    private final JLabel[] plcStatus = new JLabel[3];
    private JPanel switchPanel;
    private final JLabel[] switchStatus = new JLabel[7];
    private final ButtonGroup[] switchBG = new ButtonGroup[7];
    private final JRadioButton[] switchOffRB = new JRadioButton[7];
    private final JRadioButton[] switchOnRB = new JRadioButton[7];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[11];
    private final JLabel[] latchStatus = new JLabel[11];
    private final JButton[] latchResetBtn = new JButton[11];
    private JPanel conditionPanel;
    private final JLabel[] conditionStatus = new JLabel[7];
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private boolean gotTempLimits = false;
    private static final long serialVersionUID = 1L;

    public MpmControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((MpmSysState)reply);
    }

    public void updatePanel(MpmSysState rs) {
        SwingUtilities.invokeLater(new UpdateMpmStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int cond;
        this.systemPanel = new SystemStatusPanel(this.sender);
        for (int plc = 0; plc < 3; ++plc) {
            this.plcStatus[plc] = UiUtilities.newLabel((String)"XXX", (int)plcStateWidth);
        }
        for (int sw = 0; sw < 7; ++sw) {
            this.switchStatus[sw] = UiUtilities.newLabel((String)"XXX", (int)switchStateWidth);
            this.switchOffRB[sw] = this.uiUtils.newRadioButton("Off", "F" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton("On", "T" + sw);
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(this.switchOffRB[sw]);
            bg.add(this.switchOnRB[sw]);
        }
        for (cond = 0; cond < 11; ++cond) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchNames[cond] + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)latchStateWidth);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", String.valueOf(cond), true);
        }
        for (cond = 0; cond < 7; ++cond) {
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)conditionStateWidth);
        }
        this.plcPanel = UiUtilities.newBorderedPanel((String)"PLC States");
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.anchor = 17;
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.insets = new Insets(4, 4, 4, 4);
        for (int plc = 0; plc < 3; ++plc) {
            this.plcPanel.add((Component)UiUtilities.newLabel((String)(plcNames[plc] + ":"), (int)0), gbp);
            ++gbp.gridx;
            gbp.insets.left = 4;
            this.plcPanel.add((Component)this.plcStatus[plc], gbp);
            ++gbp.gridx;
            gbp.insets.left = 35;
        }
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = -1;
        int numColm = 2;
        int colm = 0;
        for (int sw = 0; sw < 7; ++sw) {
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)UiUtilities.newLabel((String)(switchNames[sw] + ":"), (int)0), gbs);
            gbs.insets.left = 4;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, 4, 4);
        gbl.insets.bottom = 4;
        gbl.gridy = -1;
        numColm = 2;
        colm = 0;
        for (int cond2 = 0; cond2 < 11; ++cond2) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
            gbl.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond2], gbl);
            gbl.insets.left = 4;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond2], gbl);
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond2], gbl);
            ++gbl.gridx;
            colm = (colm + 1) % numColm;
        }
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        numColm = 2;
        colm = 0;
        for (int cond3 = 0; cond3 < 7; ++cond3) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 35;
            this.conditionPanel.add((Component)UiUtilities.newLabel((String)(conditionNames[cond3] + ":"), (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond3], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % numColm;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 11;
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.systemPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.plcPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.conditionPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        String swName = MpmSwitches.ID_MAP.get(Integer.valueOf(name.substring(1)));
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{swName, action == 'T'});
    }

    public void handleButton(String name) {
        String lName = MpmLatches.ID_MAP.get(Integer.valueOf(name));
        this.sender.sendCommand(null, "clearLatch", new Object[]{lName});
    }

    static {
        MpmControlPanel.plcNames[0] = "Trunk";
        MpmControlPanel.plcNames[1] = "Cold";
        MpmControlPanel.plcNames[2] = "Cryo";
        switchNames = new String[7];
        MpmControlPanel.switchNames[4] = "Block Cold Heater";
        MpmControlPanel.switchNames[3] = "Block Cold Refrig";
        MpmControlPanel.switchNames[6] = "Block Cryo Heater";
        MpmControlPanel.switchNames[5] = "Block Cryo Refrig";
        MpmControlPanel.switchNames[2] = "Block UT Coolant";
        MpmControlPanel.switchNames[1] = "Block REB Power";
        MpmControlPanel.switchNames[0] = "Block UT Power";
        latchNames = new String[11];
        MpmControlPanel.latchNames[5] = "Cold Temp > 99C";
        MpmControlPanel.latchNames[6] = "Cold Temp < -99C";
        MpmControlPanel.latchNames[7] = "Cryo Temp > 99C";
        MpmControlPanel.latchNames[8] = "Cryo Temp < -999C";
        MpmControlPanel.latchNames[9] = "Cryo Vacuum Bad";
        MpmControlPanel.latchNames[10] = "Hex Vacuum Bad";
        MpmControlPanel.latchNames[1] = "UT Leak";
        MpmControlPanel.latchNames[2] = "UT Leak Fault";
        MpmControlPanel.latchNames[3] = "UT Smoke";
        MpmControlPanel.latchNames[4] = "UT Smoke Fault";
        MpmControlPanel.latchNames[0] = "UT Temp High";
        conditionNames = new String[7];
        MpmControlPanel.conditionNames[0] = "UT Power Permit";
        MpmControlPanel.conditionNames[1] = "REB Power Permit";
        MpmControlPanel.conditionNames[2] = "UT Coolant Permit";
        MpmControlPanel.conditionNames[3] = "Cold Refrig Permit";
        MpmControlPanel.conditionNames[4] = "Cold Heater Permit";
        MpmControlPanel.conditionNames[5] = "Cryo Refrig Permit";
        MpmControlPanel.conditionNames[6] = "Cryo Heater Permit";
        plcStateWidth = UiUtilities.maxEnumLabelWidth(PLCState.class);
        switchStateWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
        latchStateWidth = UiUtilities.maxEnumLabelWidth(LatchState.class);
        conditionStateWidth = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            MpmControlPanel.this.systemPanel.disablePanel();
            for (int plc = 0; plc < 3; ++plc) {
                MpmControlPanel.this.plcStatus[plc].setEnabled(false);
            }
            for (int sw = 0; sw < 7; ++sw) {
                MpmControlPanel.this.switchStatus[sw].setEnabled(false);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(false);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 11; ++cond) {
                MpmControlPanel.this.latchStatus[cond].setEnabled(false);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 7; ++cond) {
                MpmControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
            MpmControlPanel.this.repaint();
        }
    }

    class UpdateMpmStatus
    implements Runnable {
        private final MpmSysState ps;

        UpdateMpmStatus(MpmSysState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            int cond;
            Enum state;
            MpmControlPanel.this.systemPanel.updatePanel(this.ps.getTickMillis());
            for (int plc = 0; plc < 3; ++plc) {
                state = this.ps.getPlcState(plc);
                MpmControlPanel.this.plcStatus[plc].setText(state.name());
                MpmControlPanel.this.plcStatus[plc].setForeground(state == PLCState.OFFLINE ? UiConstants.BLUE : (state == PLCState.DEAD ? UiConstants.RED : UiConstants.GREEN));
                MpmControlPanel.this.plcStatus[plc].setEnabled(true);
            }
            for (int sw = 0; sw < 7; ++sw) {
                state = this.ps.getSwitchState(sw);
                String text = state.name();
                Color color = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                MpmControlPanel.this.switchStatus[sw].setText(text);
                MpmControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? MpmControlPanel.this.switchOnRB[sw] : MpmControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                MpmControlPanel.this.switchStatus[sw].setEnabled(true);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(true);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            for (cond = 0; cond < 11; ++cond) {
                state = this.ps.getLatch(cond);
                MpmControlPanel.this.latchStatus[cond].setText(state.name());
                MpmControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                MpmControlPanel.this.latchStatus[cond].setEnabled(true);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            for (cond = 0; cond < 7; ++cond) {
                state = this.ps.getCondition(cond);
                MpmControlPanel.this.conditionStatus[cond].setText(state.name());
                MpmControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                MpmControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (!MpmControlPanel.this.gotTempLimits && this.ps.getLimit(0) != Integer.MAX_VALUE) {
                MpmControlPanel.this.latchLabel[5].setText("Cold Temp > " + this.ps.getLimit(1) + "C:");
                MpmControlPanel.this.latchLabel[6].setText("Cold Temp < " + this.ps.getLimit(0) + "C:");
                MpmControlPanel.this.latchLabel[7].setText("Cryo Temp > " + this.ps.getLimit(3) + "C:");
                MpmControlPanel.this.latchLabel[8].setText("Cryo Temp < " + this.ps.getLimit(2) + "C:");
                MpmControlPanel.this.gotTempLimits = true;
            }
            MpmControlPanel.this.repaint();
        }
    }
}

