/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;
import org.lsst.ccs.subsystem.refrig.ui.TestRefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldXX;

public class TestCompressorControlPanel
extends TestRefrigControlPanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldXX periodTFX;
    private String subsys;
    private boolean enabled;
    private JLabel compPowerLabel;
    private JRadioButton compPowerOffRB;
    private JRadioButton compPowerOnRB;
    private JLabel compPowerStatus;
    private JLabel heaterPowerLabel;
    private JRadioButton heaterPowerOffRB;
    private JRadioButton heaterPowerOnRB;
    private JLabel heaterPowerStatus;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private ButtonGroup loadPowerBG;
    private ButtonGroup mainPowerBG;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JButton resetBtn;
    private JLabel stateLabel;
    private JLabel stateStatus;

    public TestCompressorControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.periodTFX = new TextFieldXX(this.periodTextField, 2);
        new DisableSystem().run();
    }

    private void initComponents() {
        this.mainPowerBG = new ButtonGroup();
        this.loadPowerBG = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.heaterPowerLabel = new JLabel();
        this.compPowerOffRB = new JRadioButton();
        this.compPowerOnRB = new JRadioButton();
        this.heaterPowerOnRB = new JRadioButton();
        this.heaterPowerOffRB = new JRadioButton();
        this.compPowerStatus = new JLabel();
        this.heaterPowerStatus = new JLabel();
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.compPowerLabel = new JLabel();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.resetBtn = new JButton();
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setForeground(Color.blue);
        this.jPanel2.setFocusable(false);
        this.heaterPowerLabel.setText("Heater Power:");
        this.mainPowerBG.add(this.compPowerOffRB);
        this.compPowerOffRB.setText("Off");
        this.compPowerOffRB.setFocusable(false);
        this.compPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.compPowerOffRBActionPerformed(evt);
            }
        });
        this.mainPowerBG.add(this.compPowerOnRB);
        this.compPowerOnRB.setText("On");
        this.compPowerOnRB.setFocusable(false);
        this.compPowerOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.compPowerOnRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.heaterPowerOnRB);
        this.heaterPowerOnRB.setText("On");
        this.heaterPowerOnRB.setFocusable(false);
        this.heaterPowerOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.heaterPowerOnRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.heaterPowerOffRB);
        this.heaterPowerOffRB.setText("Off");
        this.heaterPowerOffRB.setFocusable(false);
        this.heaterPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.heaterPowerOffRBActionPerformed(evt);
            }
        });
        this.compPowerStatus.setText("???");
        this.heaterPowerStatus.setText("???");
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("???");
        this.compPowerLabel.setText("Compressor Power:");
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("???");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TestCompressorControlPanel.this.periodTextFieldFocusLost(evt);
            }
        });
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TestCompressorControlPanel.this.periodTextFieldKeyTyped(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.jPanel3.setBackground(Color.white);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.jPanel3.setForeground(Color.blue);
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setText("Test");
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setText("Compressor");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addContainerGap()));
        this.resetBtn.setText("Reset");
        this.resetBtn.setFocusable(false);
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCompressorControlPanel.this.resetBtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(27, 27, 27).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.periodLabel).addComponent(this.heaterPowerLabel).addComponent(this.compPowerLabel).addComponent(this.stateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compPowerStatus, -2, 84, -2).addComponent(this.heaterPowerStatus, -2, 84, -2)).addGap(1, 1, 1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.heaterPowerOffRB).addGap(18, 18, 18).addComponent(this.heaterPowerOnRB)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.compPowerOffRB).addGap(18, 18, 18).addComponent(this.compPowerOnRB)))).addComponent(this.stateStatus, -2, 84, -2)).addContainerGap(24, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.periodTextField, -1, -1, -2).addGap(3, 3, 3).addComponent(this.periodUnitsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.resetBtn).addGap(29, 29, 29)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateLabel).addComponent(this.stateStatus, -2, 17, -2)).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compPowerStatus).addComponent(this.compPowerOffRB).addComponent(this.compPowerOnRB).addComponent(this.compPowerLabel)).addGap(3, 3, 3).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heaterPowerLabel).addComponent(this.heaterPowerStatus).addComponent(this.heaterPowerOffRB).addComponent(this.heaterPowerOnRB)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel).addComponent(this.resetBtn))).addGroup(jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jPanel3, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.periodTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, new Object[]{"setTickMillis", (int)(1000.0 * value)});
        }
    }

    private void compPowerOffRBActionPerformed(ActionEvent evt) {
        this.setCompPowerState(0);
    }

    private void compPowerOnRBActionPerformed(ActionEvent evt) {
        this.setCompPowerState(1);
    }

    private void heaterPowerOnRBActionPerformed(ActionEvent evt) {
        this.setHeaterPowerState(1);
    }

    private void heaterPowerOffRBActionPerformed(ActionEvent evt) {
        this.setHeaterPowerState(0);
    }

    private void periodTextFieldKeyTyped(KeyEvent evt) {
        this.periodTFX.keyTyped(evt.getKeyChar());
    }

    private void periodTextFieldFocusLost(FocusEvent evt) {
        this.periodTFX.focusLost();
    }

    private void resetBtnActionPerformed(ActionEvent evt) {
        this.reset();
    }

    @Override
    public void setSubsystem(String name) {
        this.subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState1 rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setCompPowerState(int value) {
        this.compPowerOffRB.setEnabled(false);
        this.compPowerOnRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, new Object[]{"setCompPowerEnable", value});
    }

    private void setHeaterPowerState(int value) {
        this.heaterPowerOffRB.setEnabled(false);
        this.heaterPowerOnRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, new Object[]{"setHeaterPowerEnable", value});
    }

    private void reset() {
        this.gui.sendCommand(this.subsys, null, new Object[]{"reset"});
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            TestCompressorControlPanel.this.stateStatus.setText("STOPPED");
            TestCompressorControlPanel.this.stateStatus.setForeground(RED);
            TestCompressorControlPanel.this.compPowerStatus.setEnabled(false);
            TestCompressorControlPanel.this.compPowerOffRB.setEnabled(false);
            TestCompressorControlPanel.this.compPowerOnRB.setEnabled(false);
            TestCompressorControlPanel.this.heaterPowerStatus.setEnabled(false);
            TestCompressorControlPanel.this.heaterPowerOffRB.setEnabled(false);
            TestCompressorControlPanel.this.heaterPowerOnRB.setEnabled(false);
            TestCompressorControlPanel.this.periodTFX.disable();
            TestCompressorControlPanel.this.resetBtn.setEnabled(false);
            TestCompressorControlPanel.this.enabled = false;
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState1 rs;

        UpdateRefrigStatus(RefrigState1 rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            if (!TestCompressorControlPanel.this.enabled) {
                TestCompressorControlPanel.this.stateStatus.setText("RUNNING");
                TestCompressorControlPanel.this.stateStatus.setForeground(GREEN);
                TestCompressorControlPanel.this.compPowerStatus.setEnabled(true);
                TestCompressorControlPanel.this.heaterPowerStatus.setEnabled(true);
                TestCompressorControlPanel.this.resetBtn.setEnabled(true);
                TestCompressorControlPanel.this.enabled = true;
            }
            boolean on = this.rs.getCmprPowerState(0) == 1;
            boolean tr = this.rs.getCmprPowerState(0) == 2;
            TestCompressorControlPanel.this.compPowerStatus.setText(on ? "ON" : (tr ? "TRIPPED" : "OFF"));
            TestCompressorControlPanel.this.compPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            JRadioButton selButton = on ? TestCompressorControlPanel.this.compPowerOnRB : TestCompressorControlPanel.this.compPowerOffRB;
            selButton.setSelected(true);
            TestCompressorControlPanel.this.compPowerOffRB.setEnabled(selButton != TestCompressorControlPanel.this.compPowerOffRB);
            TestCompressorControlPanel.this.compPowerOnRB.setEnabled(selButton != TestCompressorControlPanel.this.compPowerOnRB && !tr);
            on = this.rs.getHeaterPowerState() == 1;
            TestCompressorControlPanel.this.heaterPowerStatus.setText(on ? "ON" : "OFF");
            TestCompressorControlPanel.this.heaterPowerStatus.setForeground(on ? GREEN : Color.black);
            selButton = on ? TestCompressorControlPanel.this.heaterPowerOnRB : TestCompressorControlPanel.this.heaterPowerOffRB;
            selButton.setSelected(true);
            TestCompressorControlPanel.this.heaterPowerOffRB.setEnabled(selButton != TestCompressorControlPanel.this.heaterPowerOffRB);
            TestCompressorControlPanel.this.heaterPowerOnRB.setEnabled(selButton != TestCompressorControlPanel.this.heaterPowerOnRB);
            TestCompressorControlPanel.this.periodTFX.update((double)this.rs.getTickMillis() / 1000.0, true);
        }
    }
}

