/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.gui.AxisButtonsPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.AxisFaultPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.AxisFlagPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AxisPanel
extends JPanel
implements TargetStatusListener {
    private MotorCommandListener sender;
    private String axisName;
    private String axisUnits;
    private AxisButtonsPanel axisButtonsPanel1;
    private AxisFaultPanel axisFaultPanel1;
    private AxisFlagPanel axisFlagPanel1;
    private JLabel axisLabel;
    private JLabel axisPos;

    public AxisPanel() {
        this.initComponents();
        this.sender = null;
        this.axisName = "";
        this.axisUnits = "";
    }

    public void init(MotorCommandListener sender) {
        this.sender = sender;
        this.axisButtonsPanel1.init(sender);
    }

    public void configure(int axisNum, PlatformConfig config) {
        if (axisNum >= config.getAxisNames().size()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.axisName = config.getAxisNames().get(axisNum);
            this.axisLabel.setText(this.axisName + " axis");
            this.axisPos.setText("Position: ?");
            this.axisUnits = config.getAxisUnits().get(axisNum);
            this.axisFaultPanel1.clear();
            this.axisButtonsPanel1.configure(axisNum, config);
        }
    }

    public void update(AxisStatus status) {
        if (this.axisName.equals(status.getAxisName())) {
            this.axisPos.setText(String.format("Position: %9.3f %s", status.getPosition(), this.axisUnits));
            this.axisFaultPanel1.update(status.getFaults());
            this.axisFlagPanel1.update(status);
            this.axisButtonsPanel1.update(status);
        }
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        if (evt.disableCommands()) {
            this.axisButtonsPanel1.disableCommands();
        } else {
            this.axisButtonsPanel1.enableCommands();
        }
    }

    private void initComponents() {
        this.axisLabel = new JLabel();
        this.axisFlagPanel1 = new AxisFlagPanel();
        this.axisPos = new JLabel();
        this.axisFaultPanel1 = new AxisFaultPanel();
        this.axisButtonsPanel1 = new AxisButtonsPanel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.axisLabel.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.axisLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.axisLabel, (String)NbBundle.getMessage(AxisPanel.class, (String)"AxisPanel.axisLabel.text"));
        this.axisPos.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.axisPos, (String)NbBundle.getMessage(AxisPanel.class, (String)"AxisPanel.axisPos.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.axisFlagPanel1, -2, -1, -2).addComponent(this.axisFaultPanel1, -2, -1, -2).addComponent(this.axisPos).addComponent(this.axisButtonsPanel1, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.axisLabel, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.axisLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.axisFlagPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.axisFaultPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.axisPos).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.axisButtonsPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

