/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;

public enum Segment {
    RAFT(3, 3, DataProviderInfo.Attribute.RAFT_ID.getName(), "R"),
    REB(3, 1, DataProviderInfo.Attribute.REB_ID.getName(), "Reb"),
    CCD(1, 3, DataProviderInfo.Attribute.SENSOR_ID.getName(), "S"),
    AMP(2, 8, DataProviderInfo.Attribute.AMPLIFIER_ID.getName(), "Amp");

    private final int nX;
    private final int nY;
    private final String key;
    private final String path;
    public static final int[] N;

    private Segment(int nX, int nY, String key, String path) {
        this.nX = nX;
        this.nY = nY;
        this.key = key;
        this.path = path;
    }

    public int getNX() {
        return this.nX;
    }

    public int getNY() {
        return this.nY;
    }

    public String getKey() {
        return this.key;
    }

    public String getPathPrefix() {
        return this.path;
    }

    public static int[] getIndices(AgentChannel channel) {
        int[] indices = new int[]{-1, -1, -1, -1, -1, -1};
        try {
            String ID = (String)channel.get((Object)DataProviderInfo.Attribute.RAFT_ID.getName());
            int raftX = Integer.parseInt(ID.substring(1, 2));
            int raftY = Integer.parseInt(ID.substring(2, 3));
            if (raftX < 0 || raftX > 2 || raftY < 0 || raftY > 2) {
                return null;
            }
            indices[0] = raftX;
            indices[1] = raftY;
            ID = (String)channel.get((Object)DataProviderInfo.Attribute.REB_ID.getName());
            int reb = -1;
            if (ID != null) {
                reb = Integer.parseInt(ID.substring(3, 4));
                if (reb < 0 || reb > 2) {
                    return null;
                }
                indices[2] = reb;
            }
            if ((ID = (String)channel.get((Object)DataProviderInfo.Attribute.SENSOR_ID.getName())) != null) {
                int ccdX = Integer.parseInt(ID.substring(1, 2));
                int ccdY = Integer.parseInt(ID.substring(2, 3));
                if (ccdX < 0 || ccdX > 2 || ccdY < 0 || ccdY > 2 || reb != -1 && reb != ccdX) {
                    return null;
                }
                indices[2] = ccdX;
                indices[3] = ccdY;
                ID = (String)channel.get((Object)DataProviderInfo.Attribute.AMPLIFIER_ID.getName());
                if (ID != null) {
                    int ampX = Integer.parseInt(ID.substring(0, 1));
                    int ampY = Integer.parseInt(ID.substring(1, 2));
                    if (ampX < 0 || ampX > 1 || ampY < 0 || ampY > 8) {
                        return null;
                    }
                    indices[4] = ampX;
                    indices[5] = ampY;
                }
            }
            return indices;
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException x) {
            return null;
        }
    }

    static {
        N = new int[]{5, 5, 3, 3, 2, 8};
    }
}

