/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystem.ccob.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.ccob.ui.jas.Control;
import org.lsst.ccs.subsystem.ccob.ui.jas.MonitorFilter;

public class CCOBOptionalPage
implements OptionalPage {
    private final CommandSender cmdSender = new CommandSender();
    private final Map<String, Control> controls = new ConcurrentHashMap<String, Control>();
    private final String agentProperty;
    private final Class controlClass;

    public CCOBOptionalPage(String agentProperty, Class controlClass) {
        this.agentProperty = agentProperty;
        this.controlClass = controlClass;
    }

    public boolean isAutoOpen() {
        return false;
    }

    public String getPage(AgentInfo agent) {
        return agent != null && agent.hasAgentProperty(this.agentProperty) ? this.getPageName(agent) : null;
    }

    public boolean agentDisconnected(AgentInfo agent) {
        Control control = this.controls.get(this.getPageName(agent));
        if (control == null) {
            return true;
        }
        control.disableSystem();
        return false;
    }

    public JComponent open(AgentInfo agent, JComponent existingComponent) {
        String pageName = this.getPageName(agent);
        String agentName = agent.getName();
        Control control = this.controls.get(pageName);
        if (control != null) {
            this.initControls(agentName, control);
            return existingComponent;
        }
        try {
            control = (Control)this.controlClass.newInstance();
            this.controls.put(pageName, control);
        }
        catch (Exception e) {
            return null;
        }
        TabbedView view = new TabbedView();
        view.setViewFactory(name -> new SectionedTableView());
        MonitorFilter monitorFilter = new MonitorFilter(agent.getName());
        view.setFilter((AgentChannelsFilter)monitorFilter);
        view.install();
        JPanel cPanel = control.getControlPanel(this.cmdSender);
        control.setSubsystems(agent.getName());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)view.getPanel(), "Center");
        panel.add((Component)cPanel, "South");
        AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
        aml.addStatusMessageListener(control.getListener(), msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
        this.initControls(agentName, control);
        return panel;
    }

    public void closed(String pageName) {
        Control control = this.controls.remove(pageName);
        if (control == null) {
            throw new RuntimeException("No page exists with the name " + pageName);
        }
        Console.getConsole().getMessagingAccess().removeStatusMessageListener(control.getListener());
    }

    private String getPageName(AgentInfo agent) {
        return "CCS Subsystems/" + agent.getName();
    }

    private void initControls(String agentName, Control control) {
        control.updateControlPanel(this.cmdSender.sendCommand(agentName, null, "getFullState", new Object[0]));
    }
}

