/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.AuxHeaterPanel;
import org.lsst.ccs.subsystem.refrig.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.refrig.ui.TrimHeaterPanel;
import org.lsst.ccs.subsystem.refrig.ui.UiConstants;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class ThermalControlPanel
extends JPanel {
    private static final String[] sectionNames = new String[2];
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private final TrimHeaterPanel[] trimHeaterPanels = new TrimHeaterPanel[2];
    private final AuxHeaterPanel[] auxHeaterPanels = new AuxHeaterPanel[3];
    private final JPanel coldPanel = new JPanel();
    private final JCheckBox[] coldCbx = new JCheckBox[2];
    private final JPanel trimPanel = new JPanel();
    private final JPanel auxPanel = new JPanel();
    private final JPanel mainPanel = new JPanel();
    private static final long serialVersionUID = 1L;

    public ThermalControlPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new DisableSystem().run();
    }

    public void updateControlPanel(ThermalState rs) {
        SwingUtilities.invokeLater(new UpdateThermalStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        for (int sect = 0; sect < 2; ++sect) {
            JCheckBox[] cbx = new JCheckBox("Enable " + sectionNames[sect] + " Cold Htrs");
            cbx.setFont(UiConstants.FONT);
            cbx.setFocusable(false);
            cbx.setName(String.valueOf(sect));
            cbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int sect = Integer.valueOf(((JCheckBox)e.getSource()).getName());
                    ThermalControlPanel.this.sender.sendCommand(null, "enableColdSection", sect, ThermalControlPanel.this.coldCbx[sect].isSelected());
                }
            });
            this.coldCbx[sect] = cbx;
        }
        this.coldPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (JCheckBox cbx : this.coldCbx) {
            this.coldPanel.add((Component)cbx, gbc);
            ++gbc.gridx;
            gbc.insets.left = 20;
        }
        for (int htr = 0; htr < 2; ++htr) {
            this.trimHeaterPanels[htr] = new TrimHeaterPanel(htr, this.sender);
        }
        TitledBorder tBorder = new TitledBorder(new LineBorder(Color.BLACK), "Trim heater control");
        tBorder.setTitleFont(UiConstants.FONT);
        tBorder.setTitleColor(UiConstants.BLUE);
        tBorder.setTitleJustification(2);
        this.trimPanel.setBorder(tBorder);
        this.trimPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.insets = new Insets(5, 0, 5, 0);
        gbt.gridx = 0;
        gbt.gridy = 0;
        gbt.anchor = 11;
        this.trimPanel.add((Component)this.coldPanel, gbt);
        ++gbt.gridy;
        gbt.insets.top = 0;
        gbt.insets.bottom = 0;
        for (TrimHeaterPanel pnl : this.trimHeaterPanels) {
            this.trimPanel.add((Component)pnl, gbt);
            ++gbt.gridy;
            gbt.insets.bottom = 5;
        }
        for (int htr = 0; htr < 3; ++htr) {
            this.auxHeaterPanels[htr] = new AuxHeaterPanel(htr, this.sender);
        }
        TitledBorder aBorder = new TitledBorder(new LineBorder(Color.BLACK), "Auxiliary heater control");
        aBorder.setTitleFont(UiConstants.FONT);
        aBorder.setTitleColor(UiConstants.BLUE);
        aBorder.setTitleJustification(2);
        this.auxPanel.setBorder(aBorder);
        this.auxPanel.setLayout(new GridBagLayout());
        GridBagConstraints gba = new GridBagConstraints();
        gba.insets = new Insets(5, 0, 5, 0);
        gba.gridx = 0;
        gba.gridy = 0;
        gba.anchor = 11;
        for (AuxHeaterPanel pnl : this.auxHeaterPanels) {
            this.auxPanel.add((Component)pnl, gba);
            ++gba.gridy;
            gba.insets.top = 0;
        }
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 0, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 5;
        this.mainPanel.add((Component)this.trimPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.auxPanel, gbm);
        this.add(this.mainPanel);
    }

    static {
        ThermalControlPanel.sectionNames[0] = "-Y";
        ThermalControlPanel.sectionNames[1] = "+Y";
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.disableSystem();
            for (JCheckBox jCheckBox : ThermalControlPanel.this.coldCbx) {
                jCheckBox.setEnabled(false);
            }
            for (JComponent jComponent : ThermalControlPanel.this.trimHeaterPanels) {
                ((TrimHeaterPanel)jComponent).disablePanel();
            }
            for (JComponent jComponent : ThermalControlPanel.this.auxHeaterPanels) {
                ((AuxHeaterPanel)jComponent).disablePanel();
            }
            ThermalControlPanel.this.repaint();
        }
    }

    class UpdateThermalStatus
    implements Runnable {
        private final ThermalState rs;

        UpdateThermalStatus(ThermalState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.updateStatus(this.rs.getTickMillis());
            for (int sect = 0; sect < 2; ++sect) {
                ThermalControlPanel.this.coldCbx[sect].setEnabled(true);
                ThermalControlPanel.this.coldCbx[sect].setSelected(this.rs.isColdSectionEnabled(sect));
            }
            for (TrimHeaterPanel trimHeaterPanel : ThermalControlPanel.this.trimHeaterPanels) {
                trimHeaterPanel.updatePanel(this.rs);
            }
            for (JPanel jPanel : ThermalControlPanel.this.auxHeaterPanels) {
                ((AuxHeaterPanel)jPanel).updatePanel(this.rs);
            }
            ThermalControlPanel.this.repaint();
        }
    }
}

