/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;
import org.lsst.ccs.subsystem.refrig.ui.TestRefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class TestHXTestControlPanel
extends TestRefrigControlPanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldX periodTFX;
    private final TextFieldX powerTFX;
    private final TextFieldX tempTFX;
    private String subsys;
    private boolean enabled;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton loadPowerAutoRB;
    private ButtonGroup loadPowerBG;
    private JLabel loadPowerLabel;
    private JRadioButton loadPowerManualRB;
    private JRadioButton loadPowerOffRB;
    private JLabel loadPowerStatus;
    private ButtonGroup loadTripBG;
    private JRadioButton loadTripDisableRB;
    private JRadioButton loadTripEnableRB;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private ButtonGroup mainPowerBG;
    private JRadioButton mainPowerFullRB;
    private JRadioButton mainPowerHeaterRB;
    private JLabel mainPowerLabel;
    private JRadioButton mainPowerOffRB;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JTextField powerTextField;
    private JLabel powerUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;
    private JTextField tempTextField;
    private JLabel tempUnitsLabel;

    public TestHXTestControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.periodTFX = new TextFieldX(this.periodTextField, 2);
        this.powerTFX = new TextFieldX(this.powerTextField, 2);
        this.tempTFX = new TextFieldX(this.tempTextField, 2);
        new UpdateRefrigStatus(new RefrigState0(0, 0, 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.mainPowerBG = new ButtonGroup();
        this.loadTripBG = new ButtonGroup();
        this.loadPowerBG = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.loadPowerLabel = new JLabel();
        this.powerUnitsLabel = new JLabel();
        this.mainPowerOffRB = new JRadioButton();
        this.mainPowerFullRB = new JRadioButton();
        this.loadTripLabel = new JLabel();
        this.loadTripDisableRB = new JRadioButton();
        this.loadTripEnableRB = new JRadioButton();
        this.loadPowerManualRB = new JRadioButton();
        this.loadPowerOffRB = new JRadioButton();
        this.loadPowerAutoRB = new JRadioButton();
        this.tempTextField = new JTextField();
        this.tempUnitsLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.loadTripStatus = new JLabel();
        this.stateLabel = new JLabel();
        this.mainPowerHeaterRB = new JRadioButton();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.powerTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setForeground(Color.blue);
        this.jPanel2.setFocusable(false);
        this.loadPowerLabel.setText("Heater Power:");
        this.powerUnitsLabel.setText("watts");
        this.mainPowerBG.add(this.mainPowerOffRB);
        this.mainPowerOffRB.setText("Off");
        this.mainPowerOffRB.setFocusable(false);
        this.mainPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.mainPowerOffRBActionPerformed(evt);
            }
        });
        this.mainPowerBG.add(this.mainPowerFullRB);
        this.mainPowerFullRB.setText("Full");
        this.mainPowerFullRB.setFocusable(false);
        this.mainPowerFullRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.mainPowerFullRBActionPerformed(evt);
            }
        });
        this.loadTripLabel.setText("Heat Load Trip:");
        this.loadTripBG.add(this.loadTripDisableRB);
        this.loadTripDisableRB.setText("Disable");
        this.loadTripDisableRB.setFocusable(false);
        this.loadTripDisableRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.loadTripDisableRBActionPerformed(evt);
            }
        });
        this.loadTripBG.add(this.loadTripEnableRB);
        this.loadTripEnableRB.setText("Enable");
        this.loadTripEnableRB.setFocusable(false);
        this.loadTripEnableRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.loadTripEnableRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerManualRB);
        this.loadPowerManualRB.setText("Manual");
        this.loadPowerManualRB.setFocusable(false);
        this.loadPowerManualRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.loadPowerManualRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerOffRB);
        this.loadPowerOffRB.setText("Off");
        this.loadPowerOffRB.setFocusable(false);
        this.loadPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.loadPowerOffRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerAutoRB);
        this.loadPowerAutoRB.setText("Auto");
        this.loadPowerAutoRB.setFocusable(false);
        this.loadPowerAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.loadPowerAutoRBActionPerformed(evt);
            }
        });
        this.tempTextField.setText("...");
        this.tempTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TestHXTestControlPanel.this.tempTextFieldFocusLost(evt);
            }
        });
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.tempTextFieldActionPerformed(evt);
            }
        });
        this.tempTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TestHXTestControlPanel.this.tempTextFieldKeyTyped(evt);
            }
        });
        this.tempUnitsLabel.setText("\u00b0C");
        this.mainPowerStatus.setText("...");
        this.loadPowerStatus.setText("...");
        this.loadTripStatus.setText("...");
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.mainPowerBG.add(this.mainPowerHeaterRB);
        this.mainPowerHeaterRB.setText("Heater");
        this.mainPowerHeaterRB.setFocusable(false);
        this.mainPowerHeaterRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.mainPowerHeaterRBActionPerformed(evt);
            }
        });
        this.stateStatus.setText("....");
        this.mainPowerLabel.setText("Main Power:");
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TestHXTestControlPanel.this.periodTextFieldFocusLost(evt);
            }
        });
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TestHXTestControlPanel.this.periodTextFieldKeyTyped(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TestHXTestControlPanel.this.powerTextFieldFocusLost(evt);
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestHXTestControlPanel.this.powerTextFieldActionPerformed(evt);
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TestHXTestControlPanel.this.powerTextFieldKeyTyped(evt);
            }
        });
        this.jPanel3.setBackground(Color.white);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.jPanel3.setForeground(Color.blue);
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setText("Heat");
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setText("Exchanger");
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setText("Test");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadPowerLabel, GroupLayout.Alignment.TRAILING).addComponent(this.loadTripLabel, GroupLayout.Alignment.TRAILING).addComponent(this.mainPowerLabel, GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.stateStatus, -2, 84, -2).addGap(70, 70, 70).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodTextField, -1, -1, -2).addGap(6, 6, 6).addComponent(this.periodUnitsLabel)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.loadTripStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.loadTripDisableRB).addGap(18, 18, 18).addComponent(this.loadTripEnableRB)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.loadPowerStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.loadPowerOffRB).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.powerTextField, -2, 50, -2).addGap(4, 4, 4).addComponent(this.powerUnitsLabel)).addComponent(this.loadPowerManualRB)).addGap(27, 27, 27).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.tempTextField, -2, 50, -2).addGap(3, 3, 3).addComponent(this.tempUnitsLabel)).addComponent(this.loadPowerAutoRB))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.mainPowerStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.mainPowerOffRB).addGap(18, 18, 18).addComponent(this.mainPowerFullRB).addGap(18, 18, 18).addComponent(this.mainPowerHeaterRB))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateLabel).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel).addComponent(this.stateStatus, -2, 17, -2)).addGap(2, 2, 2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerStatus).addComponent(this.mainPowerOffRB).addComponent(this.mainPowerFullRB).addComponent(this.mainPowerLabel).addComponent(this.mainPowerHeaterRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripLabel).addComponent(this.loadTripStatus).addComponent(this.loadTripDisableRB).addComponent(this.loadTripEnableRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus).addComponent(this.loadPowerOffRB).addComponent(this.loadPowerManualRB).addComponent(this.loadPowerAutoRB))).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addGap(6, 6, 6))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.powerTextField, -2, -1, -2).addComponent(this.powerUnitsLabel).addComponent(this.tempTextField, -2, -1, -2).addComponent(this.tempUnitsLabel)).addGap(8, 8, 8)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel2, -1, -1, -2).addGap(5, 5, 5)));
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.periodTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setTickMillis", (int)(1000.0 * value));
        }
    }

    private void powerTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.powerTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setLoadPower", value);
        }
    }

    private void mainPowerOffRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(0);
    }

    private void loadTripDisableRBActionPerformed(ActionEvent evt) {
        this.setLoadTripState(0);
    }

    private void mainPowerFullRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(1);
    }

    private void loadTripEnableRBActionPerformed(ActionEvent evt) {
        this.setLoadTripState(1);
    }

    private void loadPowerManualRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(1);
    }

    private void loadPowerOffRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(0);
    }

    private void loadPowerAutoRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(-1);
    }

    private void tempTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.tempTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setLoadTemp", value);
        }
    }

    private void mainPowerHeaterRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(-1);
    }

    private void periodTextFieldFocusLost(FocusEvent evt) {
        this.periodTFX.focusLost();
    }

    private void periodTextFieldKeyTyped(KeyEvent evt) {
        this.periodTFX.keyTyped(evt.getKeyChar());
    }

    private void powerTextFieldFocusLost(FocusEvent evt) {
        this.powerTFX.focusLost();
    }

    private void powerTextFieldKeyTyped(KeyEvent evt) {
        this.powerTFX.keyTyped(evt.getKeyChar());
    }

    private void tempTextFieldFocusLost(FocusEvent evt) {
        this.tempTFX.focusLost();
    }

    private void tempTextFieldKeyTyped(KeyEvent evt) {
        this.tempTFX.keyTyped(evt.getKeyChar());
    }

    @Override
    public void setSubsystem(String name) {
        this.subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState1 rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setMainPowerState(int value) {
        this.mainPowerOffRB.setEnabled(false);
        this.mainPowerFullRB.setEnabled(false);
        this.mainPowerHeaterRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setMainPowerEnable", value);
    }

    private void setLoadTripState(int value) {
        this.loadTripDisableRB.setEnabled(false);
        this.loadTripEnableRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setLoadTripEnable", value);
    }

    private void setLoadPowerState(int value) {
        this.loadPowerOffRB.setEnabled(false);
        this.loadPowerManualRB.setEnabled(false);
        this.loadPowerAutoRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setLoadPowerEnable", value);
    }

    private void setLoadPower(double value) {
        this.gui.sendCommand(this.subsys, null, "setLoadPower", value);
    }

    private void setLoadTemp(double value) {
        this.gui.sendCommand(this.subsys, null, "setLoadTemp", value);
    }

    private void setTickMillis(int value) {
        this.gui.sendCommand(this.subsys, null, "setTickMillis", value);
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            TestHXTestControlPanel.this.stateStatus.setText("STOPPED");
            TestHXTestControlPanel.this.stateStatus.setForeground(RED);
            TestHXTestControlPanel.this.mainPowerStatus.setEnabled(false);
            TestHXTestControlPanel.this.mainPowerOffRB.setEnabled(false);
            TestHXTestControlPanel.this.mainPowerFullRB.setEnabled(false);
            TestHXTestControlPanel.this.mainPowerHeaterRB.setEnabled(false);
            TestHXTestControlPanel.this.loadTripStatus.setEnabled(false);
            TestHXTestControlPanel.this.loadTripDisableRB.setEnabled(false);
            TestHXTestControlPanel.this.loadTripEnableRB.setEnabled(false);
            TestHXTestControlPanel.this.loadPowerStatus.setEnabled(false);
            TestHXTestControlPanel.this.loadPowerOffRB.setEnabled(false);
            TestHXTestControlPanel.this.loadPowerManualRB.setEnabled(false);
            TestHXTestControlPanel.this.loadPowerAutoRB.setEnabled(false);
            TestHXTestControlPanel.this.powerTextField.setEnabled(false);
            TestHXTestControlPanel.this.tempTextField.setEnabled(false);
            TestHXTestControlPanel.this.periodTextField.setEnabled(false);
            TestHXTestControlPanel.this.enabled = false;
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState0 rs;

        UpdateRefrigStatus(RefrigState1 rs) {
            this.rs = (RefrigState0)rs;
        }

        @Override
        public void run() {
            boolean auto;
            int st;
            if (!TestHXTestControlPanel.this.enabled) {
                TestHXTestControlPanel.this.stateStatus.setText("RUNNING");
                TestHXTestControlPanel.this.stateStatus.setForeground(GREEN);
                TestHXTestControlPanel.this.mainPowerStatus.setEnabled(true);
                TestHXTestControlPanel.this.loadTripStatus.setEnabled(true);
                TestHXTestControlPanel.this.loadPowerStatus.setEnabled(true);
                TestHXTestControlPanel.this.enabled = true;
            }
            boolean on = ((st = this.rs.getSystemState()) & 1) != 0;
            boolean tr = (st & 2) != 0;
            boolean heat = (st & 0x20) != 0;
            TestHXTestControlPanel.this.mainPowerStatus.setText(on ? (heat ? "HEATER" : "FULL") : (tr ? "TRIPPED" : "OFF"));
            TestHXTestControlPanel.this.mainPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            JRadioButton selButton = on ? (heat ? TestHXTestControlPanel.this.mainPowerHeaterRB : TestHXTestControlPanel.this.mainPowerFullRB) : TestHXTestControlPanel.this.mainPowerOffRB;
            selButton.setSelected(true);
            TestHXTestControlPanel.this.mainPowerOffRB.setEnabled(selButton != TestHXTestControlPanel.this.mainPowerOffRB);
            TestHXTestControlPanel.this.mainPowerFullRB.setEnabled(selButton != TestHXTestControlPanel.this.mainPowerFullRB && !tr);
            TestHXTestControlPanel.this.mainPowerHeaterRB.setEnabled(selButton != TestHXTestControlPanel.this.mainPowerHeaterRB && !tr);
            on = (st & 8) != 0;
            TestHXTestControlPanel.this.loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            TestHXTestControlPanel.this.loadTripStatus.setForeground(on ? GREEN : Color.black);
            selButton = on ? TestHXTestControlPanel.this.loadTripEnableRB : TestHXTestControlPanel.this.loadTripDisableRB;
            selButton.setSelected(true);
            TestHXTestControlPanel.this.loadTripDisableRB.setEnabled(selButton != TestHXTestControlPanel.this.loadTripDisableRB);
            TestHXTestControlPanel.this.loadTripEnableRB.setEnabled(selButton != TestHXTestControlPanel.this.loadTripEnableRB);
            on = (st & 4) != 0;
            boolean bl = auto = (st & 0x10) != 0;
            JRadioButton jRadioButton = !on ? (auto ? null : TestHXTestControlPanel.this.loadPowerOffRB) : (selButton = auto ? TestHXTestControlPanel.this.loadPowerAutoRB : TestHXTestControlPanel.this.loadPowerManualRB);
            if (selButton != null) {
                selButton.setSelected(true);
                TestHXTestControlPanel.this.loadPowerOffRB.setEnabled(selButton != TestHXTestControlPanel.this.loadPowerOffRB);
                TestHXTestControlPanel.this.loadPowerManualRB.setEnabled(selButton != TestHXTestControlPanel.this.loadPowerManualRB);
                TestHXTestControlPanel.this.loadPowerAutoRB.setEnabled(selButton != TestHXTestControlPanel.this.loadPowerAutoRB);
            } else {
                TestHXTestControlPanel.this.loadPowerBG.clearSelection();
                TestHXTestControlPanel.this.loadPowerOffRB.setEnabled(false);
                TestHXTestControlPanel.this.loadPowerManualRB.setEnabled(false);
                TestHXTestControlPanel.this.loadPowerAutoRB.setEnabled(false);
                auto = (st & 1) != 0;
            }
            TestHXTestControlPanel.this.loadPowerStatus.setText(!on ? (auto ? "ON" : "OFF") : (auto ? "AUTO" : "MANUAL"));
            TestHXTestControlPanel.this.loadPowerStatus.setForeground(!on ? (auto ? GREEN : Color.black) : (auto ? RED : GREEN));
            TestHXTestControlPanel.this.periodTFX.update((double)this.rs.getTickMillis() / 1000.0, true);
            TestHXTestControlPanel.this.powerTFX.update(this.rs.getLoadPower(), selButton != null);
            TestHXTestControlPanel.this.tempTFX.update(this.rs.getLoadTemp(), selButton != null);
        }
    }
}

