/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.metrology.ui.PointSetConfigurableSubsystemMainPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class PointSetConfigurableSubsystemGUI
implements AgentPresenceListener,
StatusMessageListener {
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.subsystem.metrology.gui");
    private static String DEST = "metrology";
    private final PointSetConfigurableSubsystemMainPanel mainPanel;
    private final AgentMessagingLayer aml;
    private final ConcurrentMessagingUtils cmu;
    boolean online = false;
    Predicate<BusMessage<? extends Serializable, ?>> filterConfig;

    public PointSetConfigurableSubsystemGUI(AgentMessagingLayer aml) {
        this.aml = aml;
        this.cmu = new ConcurrentMessagingUtils(aml);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.mainPanel = new PointSetConfigurableSubsystemMainPanel(aml, DEST);
    }

    public void onStatusMessage(StatusMessage msg) {
        if (msg == null || !msg.getOriginAgentInfo().getName().equals(DEST)) {
            return;
        }
        ConfigurationInfo configInfo = null;
        if (!(msg.getObject() instanceof ConfigurationInfo)) {
            if (!this.online) {
                Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
                try {
                    configInfo = (ConfigurationInfo)future.get();
                    LOGGER.info((Object)"Updating config info");
                    this.mainPanel.updateWithConfigInfo(configInfo);
                    LOGGER.info((Object)"Setting description name");
                    this.mainPanel.setDescriptionName(configInfo.getDescriptionName());
                    LOGGER.info((Object)"Updating config info");
                    this.mainPanel.updateWithConfigInfo(configInfo);
                    this.online = true;
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)"unable to retrieve configuration information", (Throwable)ex);
                }
            }
            return;
        }
        configInfo = (ConfigurationInfo)msg.getObject();
        List listChanges = configInfo.getLatestChanges();
        LOGGER.info((Object)"Updating config info");
        this.mainPanel.updateWithConfigInfo(configInfo);
    }

    public Component getGuiLayout() {
        return new JScrollPane(this.mainPanel);
    }

    public void initGui() {
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.filterConfig = BusMessageFilterFactory.messageOrigin((String)DEST).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));
    }

    public void connecting(AgentInfo agent) {
        LOGGER.info((Object)"Metrology GUI connecting to the bus");
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        LOGGER.info((Object)("DEST = " + DEST));
        if (!agent.getName().equals(DEST)) {
            return;
        }
        try {
            LOGGER.info((Object)"Adding status message listner");
            this.aml.addStatusMessageListener((StatusMessageListener)this, this.filterConfig);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"unable to register as a listner", (Throwable)ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
    }
}

