/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.HeaterPanel;
import org.lsst.ccs.subsystem.refrig.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class ThermalControlPanel
extends JPanel {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private final HeaterPanel[] heaterPanels = new HeaterPanel[2];
    private final JPanel mainPanel = new JPanel();
    private static final long serialVersionUID = 1L;

    public ThermalControlPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new UpdateThermalStatus(new ThermalState()).run();
        new DisableSystem().run();
    }

    public void updateControlPanel(ThermalState rs) {
        SwingUtilities.invokeLater(new UpdateThermalStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        for (int htr = 0; htr < 2; ++htr) {
            this.heaterPanels[htr] = new HeaterPanel(htr, this.sender);
        }
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 0, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 5;
        for (HeaterPanel pnl : this.heaterPanels) {
            this.mainPanel.add((Component)pnl, gbm);
            ++gbm.gridy;
        }
        this.add(this.mainPanel);
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.disableSystem();
            for (HeaterPanel pnl : ThermalControlPanel.this.heaterPanels) {
                pnl.disablePanel();
            }
        }
    }

    class UpdateThermalStatus
    implements Runnable {
        private final ThermalState rs;

        UpdateThermalStatus(ThermalState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.updateStatus(this.rs.getTickMillis());
            for (HeaterPanel htr : ThermalControlPanel.this.heaterPanels) {
                htr.updatePanel(this.rs);
            }
        }
    }
}

