/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.AbstractFocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.CCDType;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlane;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelFactory;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapValue;

public class FakeModel3
extends AbstractFocalPlaneMapModel
implements FocalPlaneMapModelFactory {
    private String name;
    private static Random random = new Random();

    public FakeModel3(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        return this;
    }

    @Override
    public FocalPlaneMapValue getValue() {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        v.bgColor = Color.BLACK;
        v.toolTip = "Default";
        return v;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY) {
        CCDType type = FocalPlane.getType(raftX, raftY);
        if (type == CCDType.SCIENCE) {
            switch (raftX) {
                case 0: {
                    FocalPlaneMapValue v = new FocalPlaneMapValue();
                    v.bgColor = Color.GREEN;
                    return v;
                }
                case 1: {
                    return FocalPlaneMapValue.NONE;
                }
                case 2: {
                    return null;
                }
            }
            FocalPlaneMapValue v = new FocalPlaneMapValue();
            v.bgColor = Color.MAGENTA;
            v.setSplit(true);
            return v;
        }
        return FocalPlaneMapValue.EMPTY;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb) {
        switch (reb) {
            case 0: {
                FocalPlaneMapValue v = new FocalPlaneMapValue();
                v.bgColor = Color.RED;
                return v;
            }
            case 1: {
                FocalPlaneMapValue v = new FocalPlaneMapValue();
                v.bgColor = Color.blue;
                v.setSplit(true);
                return v;
            }
        }
        return raftX == 3 ? null : FocalPlaneMapValue.NONE;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY) {
        switch (ccdY) {
            case 0: {
                FocalPlaneMapValue v = new FocalPlaneMapValue();
                v.bgColor = Color.YELLOW;
                return v;
            }
            case 1: {
                FocalPlaneMapValue v = new FocalPlaneMapValue();
                v.bgColor = Color.PINK;
                v.setSplit(true);
                return v;
            }
        }
        return FocalPlaneMapValue.NONE;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY, int ampX, int ampY) {
        if (ampX % 2 == 0) {
            return null;
        }
        if (ampY % 2 == 0) {
            FocalPlaneMapValue v = new FocalPlaneMapValue();
            v.bgColor = Color.ORANGE;
            return v;
        }
        return null;
    }
}

