/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer.filters;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

public class LegacyFormatter
implements MessageFilter {
    private final SimpleDateFormat dtFormat = new SimpleDateFormat("HH:mm:ss");

    @Override
    public String getDescription() {
        return "<html>Accepts all messages.<p>Formats output as<br>[Date Time] [Origin]: [Message]<br>The message depends on the type of the bus message.";
    }

    @Override
    public String getPath() {
        return "BuiltIn/Formatters/Legacy";
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        if (filteredMessage.getMessage() != null) {
            return filteredMessage;
        }
        BusMessage bm = filteredMessage.getBusMessage();
        Date date = new Date(bm.getTimeStamp());
        StringBuilder sb = new StringBuilder(this.dtFormat.format(date));
        sb.append(" ").append(bm.getOriginAgentInfo().getName()).append(": ");
        if (bm instanceof LogMessage) {
            LogMessage lm = (LogMessage)bm;
            sb.append(lm.getFormattedDetails().trim());
        } else if (bm instanceof StatusMessage) {
            StatusMessage sm = (StatusMessage)bm;
            if (sm instanceof StatusHeartBeat) {
                sb.append("Heart Beat.");
            } else if (sm instanceof StatusStateChangeNotification) {
                sb.append("State change: ").append(sm.getState());
            } else if (sm instanceof StatusRuntimeInfo) {
                RuntimeInfo rt = ((StatusRuntimeInfo)sm).getRuntimeInfo();
                sb.append("JVM info: ").append(rt.getNThreads()).append(" threads, ");
                sb.append(rt.getFreeMemory() / 1000000L).append(" MB free, ");
                sb.append(rt.getSystemCpuLoad()).append(" % System CPU load.");
            } else {
                try {
                    sb.append(sm.getEncodedData());
                }
                catch (Exception x) {
                    sb.append(sm);
                }
                if (sb.length() > 200) {
                    sb.delete(200, Integer.MAX_VALUE).append("...");
                }
            }
        } else if (bm instanceof CommandRequest) {
            CommandRequest cr = (CommandRequest)bm;
            sb.append("Command ").append(cr.getBasicCommand().getCommand()).append(" to ").append(cr.getDestination()).append(".");
        } else if (bm instanceof CommandNack) {
            CommandNack cn = (CommandNack)bm;
            sb.append("Command not accepted. Reason: ").append(cn.getReason());
        } else if (bm instanceof CommandAck) {
            sb.append("Command accepted.");
        } else if (bm instanceof CommandResult) {
            CommandResult cr = (CommandResult)bm;
            if (cr.wasSuccessful()) {
                sb.append("Command executed");
                Object out = cr.getResult();
                if (out == null) {
                    sb.append(".");
                } else {
                    sb.append(": ").append(out);
                }
            } else {
                sb.append("Command failed: ").append(cr.getResult());
            }
        } else {
            sb.append(bm);
        }
        filteredMessage.setMessage(sb.toString());
        return filteredMessage;
    }
}

