/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.WebBrowser;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.jas3.ConsoleApplication;
import org.lsst.ccs.gconsole.jas3.JasPanelManager;
import org.lsst.ccs.gconsole.jas3.PreferencePage;
import org.lsst.ccs.gconsole.jas3.PropertyHandler;
import org.openide.util.Lookup;

public class Jas3Console
extends Console {
    private final PropertyHandler prop;
    private final HashMap<String, PreferencePage> prefs = new HashMap();
    private final PanelManager panMan;
    private final AtomicBoolean agentShutdown = new AtomicBoolean(false);

    public Jas3Console() {
        ConsoleApplication app = this.getApplication();
        this.prop = new PropertyHandler(app.getUserProperties(), app.getAppProperties());
        this.panMan = new JasPanelManager((Studio)app);
    }

    @Override
    public void preStart() {
        super.preStart();
        AbstractAction act = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jas3Console.this.save();
            }
        };
        this.addMenu(act, "", "File:-2:1", "Session:1");
        act = new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jas3Console.this.saveAs();
            }
        };
        this.addMenu(act, "", "File:-2:1", "Session:2");
        act = new AbstractAction("Restore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jas3Console.this.restore();
            }
        };
        this.addMenu(act, "", "File:-2:1", "Session:3");
        act = new AbstractAction("Restore From..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jas3Console.this.restoreFrom();
            }
        };
        this.addMenu(act, "", "File:-2:1", "Session:4");
        act = new AbstractAction("CCS Console Developer's Guide"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jas3Console.this.showInBrowser("https://confluence.slac.stanford.edu/display/LSSTCAM/Graphical+Console+Plugin+Developer%27s+Guide");
            }
        };
        this.addMenu(act, "", "Help", "Documentation:300");
    }

    public Object shutdownAgent() throws Exception {
        if (this.agentShutdown.getAndSet(true)) {
            return "The console is already shutting down";
        }
        if (this.jvmShutdown.get()) {
            this.superShutdownAgent();
        } else {
            SwingUtilities.invokeLater(() -> this.getApplication().exit());
        }
        return "OK";
    }

    public void superShutdownAgent() {
        try {
            super.shutdownAgent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FreeHEPLookup getConsoleLookup() {
        return this.getApplication().getLookup();
    }

    @Override
    public Window getWindow() {
        return SwingUtilities.getWindowAncestor((Component)Application.getApplication());
    }

    public final ConsoleApplication getApplication() {
        return (ConsoleApplication)Application.getApplication();
    }

    @Override
    public Path getHomeDirectory() {
        Path path = Paths.get(this.getApplication().getUserProperties().getProperty("org.lsst.ccs.gui.home"), new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path;
    }

    @Override
    public PanelManager getPanelManager() {
        return this.panMan;
    }

    @Override
    public void error(String message) {
        this.getApplication().error(message);
    }

    @Override
    public void error(String message, Exception x) {
        this.getApplication().error(message, x);
    }

    @Override
    public void showInBrowser(String url) {
        try {
            WebBrowser webBrowser = (WebBrowser)this.getConsoleLookup().lookup(WebBrowser.class);
            webBrowser.showURL(new URL(url), true);
        }
        catch (RuntimeException | MalformedURLException x) {
            this.getLogger().warn((Object)("Unable to display " + url + " in a browser."), (Throwable)x);
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.getApplication().setStatusMessage(message);
    }

    @Override
    public Object addProperty(String key, Object defaultValue) {
        return this.prop.addProperty(key, defaultValue);
    }

    @Override
    public Object removeProperty(String key) {
        return this.prop.removeProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreference(String[] path, String group, String format) {
        HashMap<String, PreferencePage> hashMap = this.prefs;
        synchronized (hashMap) {
            PreferencePage page = this.prefs.get(Arrays.toString(path));
            if (page == null) {
                page = new PreferencePage(this, path);
                this.prefs.put(Arrays.toString(path), page);
                this.getConsoleLookup().add((Object)page);
            }
            page.add(group, format);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.prop.getProperty(key);
    }

    @Override
    public Object setProperty(String key, Object value) {
        return this.prop.setProperty(key, value);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.prop.setProperties(properties);
    }

    @Override
    public void addPropertyListener(Console.PropertyListener listener, String filter) {
        this.prop.addPropertyListener(listener, filter);
    }

    @Override
    public boolean removePropertyListener(Console.PropertyListener listener) {
        return this.prop.removePropertyListener(listener);
    }

    @Override
    public void addMenu(Action action, String owner, String ... locations) {
        this.getApplication().addMenu(action, owner, this.adjustMenuLocation(locations));
    }

    @Override
    public boolean removeMenu(String ... locations) {
        return this.getApplication().removeMenu(this.adjustMenuLocation(locations));
    }

    private String[] adjustMenuLocation(String[] locations) {
        String[] newLocations = null;
        if (locations != null) {
            newLocations = new String[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                Matcher m;
                String s = locations[i];
                if (i == 0) {
                    m = Pattern.compile("^(?:[\\s\\-\\d]*\\:)?CCS Subsystems\\s*((?:\\:[\\s\\-\\d\\:]*)?)$").matcher(s);
                    if (m.matches()) {
                        newLocations[i] = "402:CCS Subsystems " + m.group(1);
                        continue;
                    }
                    newLocations[i] = s;
                    continue;
                }
                newLocations[i] = s;
                if (!s.matches("^\\s*obsolete\\s*(?:\\:[\\s\\-\\d\\:]*)?$")) continue;
                s = newLocations[i - 1];
                m = Pattern.compile("^((?:[\\s\\-\\d]*\\:)?(?:[^\\:]+))(?:\\:[\\s\\-\\d\\:]*)?$").matcher(s);
                if (!m.matches()) continue;
                newLocations[i - 1] = m.group(1) + ":1001";
            }
        }
        return newLocations;
    }

    private Path getDefaultPath() {
        return this.getHomeDirectory().resolve("config").resolve("default.conf");
    }

    public void restore() {
        this.restore(this.getDefaultPath());
    }

    public void restoreFrom() {
        JFileChooser chooser = new JFileChooser(this.getHomeDirectory().resolve("config").toFile());
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Graphical Console Configuration", "conf");
        chooser.setFileFilter(filter);
        int out = chooser.showOpenDialog(this.getWindow());
        if (out == 0) {
            this.restore(chooser.getSelectedFile().toPath());
        }
    }

    public void save() {
        this.save(this.getDefaultPath());
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser(this.getHomeDirectory().resolve("config").toFile());
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Graphical Console Configuration", "conf");
        chooser.setFileFilter(filter);
        int out = chooser.showSaveDialog(this.getWindow());
        if (out == 0) {
            Path path = chooser.getSelectedFile().toPath();
            String s = path.toString();
            if (!s.endsWith(".conf")) {
                s = s + ".conf";
                path = Paths.get(s, new String[0]);
            }
            this.save(path);
        }
    }

    private void restore(Path path) {
        Map<String, ComponentDescriptor> descriptors = this.readDescriptors(path);
        if (descriptors.isEmpty()) {
            return;
        }
        ComponentDescriptor consoleDescriptor = descriptors.get("");
        if (consoleDescriptor == null) {
            this.getLogger().info((Object)"Restoring the graphical console configuration.");
        } else {
            this.getLogger().info((Object)("Restoring configuration saved by the graphical console version " + consoleDescriptor.getVersion()));
        }
        HashMap<String, ConsolePlugin> allPlugins = new HashMap<String, ConsolePlugin>();
        Lookup.Result result = this.getConsoleLookup().lookup(new Lookup.Template(ConsolePlugin.class));
        for (Object o : result.allInstances()) {
            ConsolePlugin plugin = (ConsolePlugin)o;
            allPlugins.put(plugin.getServices().getDescriptor().getName(), plugin);
        }
        LinkedHashMap plugins = new LinkedHashMap();
        descriptors.forEach((name, descriptor) -> {
            ConsolePlugin plugin = (ConsolePlugin)allPlugins.get(name);
            if (plugin != null) {
                plugins.put(descriptor, plugin);
            }
        });
        int maxRound = 100;
        boolean lastRound = plugins.isEmpty();
        int round = 0;
        while (!lastRound) {
            lastRound = round == maxRound || plugins.size() == 1;
            Iterator it = plugins.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                try {
                    if (((ConsolePlugin)e.getValue()).restore((ComponentDescriptor)e.getKey(), lastRound)) {
                        it.remove();
                        continue;
                    }
                    if (!lastRound) continue;
                    this.getLogger().warn((Object)("Unable to finish restoring " + ((ComponentDescriptor)e.getKey()).getName() + " configuration."));
                }
                catch (RuntimeException x) {
                    this.getLogger().warn((Object)("Failed to restore configuration for " + ((ComponentDescriptor)e.getKey()).getName()), (Throwable)x);
                    it.remove();
                }
            }
            ++round;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Path path) {
        try (XMLEncoder encoder = null;){
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            encoder = new XMLEncoder(out);
            ComponentDescriptor cd = new ComponentDescriptor();
            cd.setName("");
            cd.setVersion(this.getApplication().getVersion());
            encoder.writeObject(cd);
            Lookup.Result result = this.getConsoleLookup().lookup(new Lookup.Template(ConsolePlugin.class));
            for (Object o : result.allInstances()) {
                ConsolePlugin plugin = (ConsolePlugin)o;
                try {
                    ComponentDescriptor data = plugin.save();
                    if (data == null) continue;
                    data.setName(plugin.getServices().getDescriptor().getName());
                    encoder.writeObject(data);
                }
                catch (Throwable x) {
                    this.getLogger().warn((Object)("Failed to save configuration of " + plugin.getServices().getDescriptor().getName() + " plugin."), x);
                }
            }
        }
    }

    public Map<String, ComponentDescriptor> readDescriptors(Path path) {
        if (path == null) {
            path = this.getDefaultPath();
        }
        HashMap<String, ComponentDescriptor> out = new HashMap<String, ComponentDescriptor>();
        try {
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), null, e -> {});
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        ComponentDescriptor cd = (ComponentDescriptor)decoder.readObject();
                        out.put(cd.getName(), cd);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (decoder != null) {
                        if (throwable != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            decoder.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (decoder != null) {
                        if (throwable != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            decoder.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException | ClassCastException exception) {
            // empty catch block
        }
        return out;
    }
}

