/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.srp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.conv.Convert;

public class Srp {
    private static final int MAX_REGS = 64;
    private static final int MAX_REGS_3 = 1024;
    private static final int READ_TIMEOUT = 1000;
    private static final int SRP_PKT_LENG = 20;
    private static final int SRP_OFF_HEADER = 4;
    private static final int SRP_OFF_OC = 8;
    private static final int SRP_OFF_ADDR = 8;
    private static final int SRP_OFF_DATA = 12;
    private static final int SRP_OFF_FOOTER = 16;
    private static final int SRP_STS_TIMEOUT = 2;
    private static final int SRP_STS_ERROR = 1;
    private static final int SRP3_PKT_LENG = 20;
    private static final int SRP3_OFF_HEADER = 0;
    private static final int SRP3_OFF_VERSION = 0;
    private static final int SRP3_OFF_OPCODE = 1;
    private static final int SRP3_OFF_TIMEOUT = 3;
    private static final int SRP3_OFF_TID = 4;
    private static final int SRP3_OFF_ADDR_LO = 8;
    private static final int SRP3_OFF_ADDR_HI = 12;
    private static final int SRP3_OFF_SIZE = 16;
    private static final int SRP3_OFF_DATA = 20;
    private static final int SRP3_OFF_FOOTER = 20;
    private static final int SRP3_OPC_NP_READ = 0;
    private static final int SRP3_OPC_NP_WRITE = 1;
    private static final int SRP3_OPC_P_WRITE = 2;
    private static final int SRP3_STS_MEMORY = 255;
    private static final int SRP3_STS_TIMEOUT = 256;
    private static final int SRP3_STS_EOFE = 512;
    private static final int SRP3_STS_FRAMING = 1024;
    private static final int SRP3_STS_VERSION = 2048;
    private static final int SRP3_STS_REQUEST = 4096;
    private static final byte SRP_OC_READ = 0;
    private static final byte SRP_OC_WRITE = 64;
    private DatagramSocket sock;
    private int seqno;
    private int nSeqErr;
    private int nTimeout;
    private int srpVersion = 3;
    private int maxRegs = 1024;
    private byte[] inBuff = new byte[20 + 4 * (this.maxRegs - 1)];
    private byte[] outBuff = new byte[20 + 4 * (this.maxRegs - 1)];
    private DatagramPacket inPkt = new DatagramPacket(this.inBuff, this.inBuff.length);
    private DatagramPacket outPkt = new DatagramPacket(this.outBuff, this.outBuff.length);
    private byte[] ipAddr = new byte[]{0, 0, 0, 0};
    private boolean simulated;
    private boolean debug;
    private final Map<Integer, Integer> simRegMap = new HashMap<Integer, Integer>();

    public synchronized void open(String host, int port) throws DriverException {
        if (this.sock != null) {
            throw new DriverException("Connection is already open");
        }
        this.nSeqErr = 0;
        this.nTimeout = 0;
        try {
            DatagramSocket newSock = new DatagramSocket();
            if (host == null || host.isEmpty()) {
                this.simulated = true;
                this.simInitialize();
            } else {
                this.simulated = false;
                InetAddress inetAddr = InetAddress.getByName(host);
                newSock.connect(inetAddr, port);
                newSock.setSoTimeout(1000);
                this.outPkt.setAddress(inetAddr);
                this.outPkt.setPort(port);
                this.ipAddr = inetAddr.getAddress();
            }
            this.sock = newSock;
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public void close() throws DriverException {
        this.checkOpen();
        this.sock.close();
        this.sock = null;
    }

    public void setSrpVersion(int version) {
        if (version == this.srpVersion) {
            return;
        }
        this.srpVersion = version;
        this.maxRegs = this.srpVersion == 3 ? 1024 : 64;
        int pktLeng = this.srpVersion == 3 ? 20 : 20;
        this.inBuff = new byte[pktLeng + 4 * (this.maxRegs - 1)];
        this.outBuff = new byte[pktLeng + 4 * (this.maxRegs - 1)];
        this.inPkt = new DatagramPacket(this.inBuff, this.inBuff.length);
        this.outPkt = new DatagramPacket(this.outBuff, this.outBuff.length);
    }

    public void setDebug(Boolean on) {
        this.debug = on;
    }

    public byte[] getIpAddress() {
        return this.ipAddr;
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public void writeReg(int addr, int value) throws DriverException {
        this.writeRegs(addr, new int[]{value});
    }

    public synchronized void writeRegs(int addr, int[] value) throws DriverException {
        this.checkOpen();
        int count = Math.min(value.length, this.maxRegs);
        if (this.simulated) {
            this.simWriteRegs(addr, value, count);
        } else if (this.srpVersion == 3) {
            this.writeRegs3(addr, value, count);
        } else {
            this.writeRegs0(addr, value, count);
        }
    }

    private void writeRegs3(int addr, int[] value, int count) throws DriverException {
        int j;
        Convert.intToBytes((int)(4 * addr), (byte[])this.outBuff, (int)8);
        Convert.intToBytes((int)0, (byte[])this.outBuff, (int)12);
        Convert.intToBytes((int)(4 * count - 1), (byte[])this.outBuff, (int)16);
        for (j = 0; j < count; ++j) {
            Convert.intToBytes((int)value[j], (byte[])this.outBuff, (int)(20 + 4 * j));
        }
        this.outBuff[0] = 3;
        this.outBuff[1] = 1;
        this.outBuff[3] = 10;
        for (j = 0; j < 2; ++j) {
            try {
                this.send(20 + 4 * count);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
    }

    private void writeRegs0(int addr, int[] value, int count) throws DriverException {
        int j;
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        for (j = 0; j < count; ++j) {
            Convert.intToBytesBE((int)value[j], (byte[])this.outBuff, (int)(12 + 4 * j));
        }
        this.outBuff[8] = 64;
        for (j = 0; j < 2; ++j) {
            try {
                this.send(20 + 4 * (count - 1));
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
    }

    public int readReg(int addr) throws DriverException {
        return this.readRegs(addr, 1)[0];
    }

    public synchronized int[] readRegs(int addr, int count) throws DriverException {
        this.checkOpen();
        if (count <= 0) {
            return new int[0];
        }
        count = Math.min(count, this.maxRegs);
        if (this.simulated) {
            return this.simReadRegs(addr, count);
        }
        if (this.srpVersion == 3) {
            return this.readRegs3(addr, count);
        }
        return this.readRegs0(addr, count);
    }

    private int[] readRegs3(int addr, int count) throws DriverException {
        this.outBuff[0] = 3;
        this.outBuff[1] = 0;
        this.outBuff[3] = 10;
        Convert.intToBytes((int)(4 * addr), (byte[])this.outBuff, (int)8);
        Convert.intToBytes((int)0, (byte[])this.outBuff, (int)12);
        Convert.intToBytes((int)(4 * count - 1), (byte[])this.outBuff, (int)16);
        for (int j = 0; j < 2; ++j) {
            try {
                this.send(20);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
        int nRead = (this.inPkt.getLength() - 20) / 4 - 1;
        int[] data = new int[nRead];
        for (int j = 0; j < nRead; ++j) {
            data[j] = Convert.bytesToInt((byte[])this.inBuff, (int)(20 + 4 * j));
        }
        return data;
    }

    private int[] readRegs0(int addr, int count) throws DriverException {
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        Convert.intToBytesBE((int)(count - 1), (byte[])this.outBuff, (int)12);
        this.outBuff[8] = 0;
        for (int j = 0; j < 2; ++j) {
            try {
                this.send(20);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
        int nRead = (this.inPkt.getLength() - 20) / 4 + 1;
        int[] data = new int[nRead];
        for (int j = 0; j < nRead; ++j) {
            data[j] = Convert.bytesToIntBE((byte[])this.inBuff, (int)(12 + 4 * j));
        }
        return data;
    }

    public synchronized int updateReg(int addr, int mask, int value) throws DriverException {
        int prevValue = this.readReg(addr);
        this.writeReg(addr, prevValue & ~mask | value & mask);
        return prevValue;
    }

    private void checkOpen() throws DriverException {
        if (this.sock == null) {
            throw new DriverException("Connection is not open");
        }
    }

    private void send(int leng) throws DriverException {
        this.seqno += 4;
        Convert.intToBytes((int)this.seqno, (byte[])this.outBuff, (int)(this.srpVersion == 3 ? 4 : 4));
        if (this.srpVersion != 3) {
            Convert.intToBytes((int)0, (byte[])this.outBuff, (int)(leng - 20 + 16));
        }
        this.showData("Sent:", leng, this.outBuff);
        this.outPkt.setLength(leng);
        try {
            this.sock.send(this.outPkt);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void receive() throws DriverException {
        while (true) {
            this.inPkt.setLength(this.inBuff.length);
            try {
                this.sock.receive(this.inPkt);
                int rSeqno = Convert.bytesToInt((byte[])this.inBuff, (int)(this.srpVersion == 3 ? 4 : 4));
                if (this.seqno == rSeqno) break;
                ++this.nSeqErr;
            }
            catch (SocketTimeoutException e) {
                ++this.nTimeout;
                throw new DriverTimeoutException();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        }
        int leng = this.inPkt.getLength();
        this.showData("Rcvd:", leng, this.inBuff);
        String message = null;
        if (this.srpVersion == 3) {
            int status = Convert.bytesToInt((byte[])this.inBuff, (int)(leng - 4));
            if ((status & 0xFF) != 0) {
                message = "Invalid register address";
            }
            if ((status & 0x100) != 0) {
                message = "Register access timeout";
            }
            if ((status & 0x200) != 0) {
                message = "End of frame with error";
            }
            if ((status & 0x400) != 0) {
                message = "Framing error";
            }
            if ((status & 0x800) != 0) {
                message = "Version mismatch";
            }
            if ((status & 0x1000) != 0) {
                message = "Invalid request";
            }
        } else {
            int status = Convert.bytesToIntBE((byte[])this.inBuff, (int)(leng + 16 - 20));
            if ((status & 2) != 0) {
                message = "Register access timeout";
            }
            if ((status & 1) != 0) {
                message = "Register access error";
            }
        }
        if (message != null) {
            throw new DriverException(message);
        }
    }

    private void showData(String title, int leng, byte[] data) {
        if (!this.debug) {
            return;
        }
        String blanks = null;
        for (int j = 0; j < leng; ++j) {
            if (j % 32 == 0) {
                if (j == 0) {
                    System.out.print(title);
                } else {
                    if (blanks == null) {
                        blanks = "\n                    ".substring(0, title.length() + 1);
                    }
                    System.out.print(blanks);
                }
            }
            if (j % 4 == 0) {
                System.out.print(" ");
            }
            System.out.format("%02x", data[j] & 0xFF);
        }
        System.out.println();
    }

    public int getNumSeqErr() {
        return this.nSeqErr;
    }

    public int getNumTimeout() {
        return this.nTimeout;
    }

    protected void simInitialize() {
        this.clearSimRegMap();
    }

    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            this.putSimRegMap(addr, value[j]);
            ++j;
            ++addr;
        }
    }

    protected int[] simReadRegs(int addr, int count) {
        int[] data = new int[count];
        for (int j = 0; j < count; ++j) {
            data[j] = this.getSimRegMap(addr + j);
        }
        return data;
    }

    protected final void clearSimRegMap() {
        this.simRegMap.clear();
    }

    protected final void putSimRegMap(int addr, int value) {
        this.simRegMap.put(addr, value);
    }

    protected final int getSimRegMap(int addr) {
        Integer value = this.simRegMap.get(addr);
        return value == null ? 0 : value;
    }
}

