/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freehep.application.mdi.PageContext;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeTransferable;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.JasPanelManager;
import org.lsst.ccs.gconsole.plugins.trending.ChannelDropHandler;
import org.lsst.ccs.gconsole.plugins.trending.CompoundTrendingSource;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingFilter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSource;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

class TrendingSourcesManager
extends DefaultFTreeNodeAdapter
implements TrendingSource.Listener {
    private final LsstTrendingPlugin plugin;
    private final ChannelDropHandler dropHandler;
    private volatile TrendingChannel selectedChannel;
    private final Action actShow;
    private final Action actPlot;
    private final Action actOverlay;
    private final Action actNewPlot;
    private final Action actNewPage;
    private final Action actRefresh;
    private final CompoundTrendingSource rawSource = new CompoundTrendingSource();
    private final CompoundTrendingSource filteredSource = new CompoundTrendingSource();
    private final Object sourceLock = new Object();
    private volatile Lookup.Result sourcesLookupResult;
    private volatile Lookup.Result filtersLookupResult;
    private volatile LookupListener sourcesLookupListener;
    private volatile LookupListener filtersLookupListener;
    private FTree tree;

    TrendingSourcesManager(final LsstTrendingPlugin plugin) {
        super(100);
        this.plugin = plugin;
        this.dropHandler = new ChannelDropHandler(plugin);
        this.actShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.plot(TrendingSourcesManager.this.selectedChannel, null, TrendPlotter.Option.EXIST, TrendPlotter.Option.NEWPAGE);
            }
        };
        this.actShow.putValue("SHORT_DESCRIPTION", "Plot in the region previously used for this channel, if any, or on a new page.");
        this.actPlot = new AbstractAction("Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.plot(TrendingSourcesManager.this.selectedChannel, null, new TrendPlotter.Option[0]);
            }
        };
        this.actPlot.putValue("SHORT_DESCRIPTION", "Plot in the currently selected region.");
        this.actOverlay = new AbstractAction("Overlay"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.plot(TrendingSourcesManager.this.selectedChannel, null, TrendPlotter.Option.OVERLAY);
            }
        };
        this.actOverlay.putValue("SHORT_DESCRIPTION", "Overlay on the currently selected plot.");
        this.actNewPlot = new AbstractAction("New Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.plot(TrendingSourcesManager.this.selectedChannel, null, TrendPlotter.Option.NEWPLOT);
            }
        };
        this.actNewPlot.putValue("SHORT_DESCRIPTION", "Plot in a new region.");
        this.actNewPage = new AbstractAction("New Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.plot(TrendingSourcesManager.this.selectedChannel, null, TrendPlotter.Option.NEWPAGE);
            }
        };
        this.actNewPage.putValue("SHORT_DESCRIPTION", "Plot on a new page.");
        this.actRefresh = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.refresh(TrendingSourcesManager.this.selectedChannel);
            }
        };
        this.actRefresh.putValue("SHORT_DESCRIPTION", "Refresh plots for this channel.");
    }

    void start() {
        Lookup.Template template;
        FreeHEPLookup lookup;
        if (this.tree == null) {
            FTreeProvider treeProvider = (FTreeProvider)this.plugin.getConsole().getConsoleLookup().lookup(FTreeProvider.class);
            this.tree = treeProvider.tree("Trending");
            JasPanelManager panMan = (JasPanelManager)this.plugin.getConsole().getPanelManager();
            PageContext context = panMan.findPage(PanelType.CONTROL, "Trending");
            if (context != null) {
                EnumMap<Panel, Object> prop = new EnumMap<Panel, Object>(Panel.class);
                prop.put(Panel.TYPE, PanelType.CONTROL);
                prop.put(Panel.GROUP, this.plugin.PANEL_GROUP);
                panMan.open(context.getPage(), prop);
            }
            treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)this, TrendingChannel.class);
        }
        this.filteredSource.add(this.rawSource);
        this.filteredSource.addListener(this);
        if (this.sourcesLookupResult == null) {
            lookup = this.plugin.getConsole().getConsoleLookup();
            template = new Lookup.Template(TrendingSource.class);
            this.sourcesLookupResult = lookup.lookup(template);
        }
        this.sourcesLookupListener = e -> this.updateSources(this.sourcesLookupResult.allInstances());
        this.sourcesLookupResult.addLookupListener(this.sourcesLookupListener);
        this.updateSources(this.sourcesLookupResult.allInstances());
        if (this.filtersLookupResult == null) {
            lookup = this.plugin.getConsole().getConsoleLookup();
            template = new Lookup.Template(TrendingFilter.class);
            this.filtersLookupResult = lookup.lookup(template);
        }
        this.filtersLookupListener = e -> this.applyFilters(this.filtersLookupResult.allInstances());
        this.filtersLookupResult.addLookupListener(this.filtersLookupListener);
        this.applyFilters(this.filtersLookupResult.allInstances());
    }

    void stop() {
        this.sourcesLookupResult.removeLookupListener(this.sourcesLookupListener);
        this.sourcesLookupListener = null;
        this.filtersLookupResult.removeLookupListener(this.filtersLookupListener);
        this.filtersLookupListener = null;
        this.filteredSource.clear();
        this.filteredSource.removeListener(this);
        this.rawSource.clear();
        this.selectedChannel = null;
    }

    public TrendData fetchData(Trend trend, EnumSet<Trend.Meta> metadata) {
        return this.fetchData(Collections.singletonList(trend), metadata).get(0);
    }

    public List<TrendData> fetchData(List<Trend> trends, EnumSet<Trend.Meta> metadata) {
        long now = System.currentTimeMillis();
        ArrayList<TrendData> out = new ArrayList<TrendData>(trends.size());
        trends.forEach(trend -> {
            trend.setLoading(true);
            out.add(this.filteredSource.get(trend.getChannel(), trend.getTimeWindow().getLowerEdge(now), trend.getTimeWindow().getUpperEdge(now), metadata, trend.getData()));
        });
        return out;
    }

    public ArrayList<TrendingChannel> getChannels() {
        return new ArrayList<TrendingChannel>(this.filteredSource.getChannels());
    }

    @Override
    public void processEvent(TrendingSource.Event event) {
        if (SwingUtilities.isEventDispatchThread()) {
            ComponentDescriptor desc;
            event.getRemovedChannels().forEach(channel -> {
                FTreePath path = new FTreePath(channel.getPath());
                while (path != null) {
                    FTreeNode node;
                    try {
                        this.tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this, path));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if ((path = path.getParentPath()) == null || (node = this.tree.findNode(path)) != null && node.parent() != null && node.childNodes().isEmpty()) continue;
                    path = null;
                }
            });
            event.getAddedChannels().forEach(channel -> this.tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this, channel.getPath(), channel)));
            if (this.plugin.getPreferences().isAutoSave() && !this.tree.root().childNodes().isEmpty() && (desc = this.plugin.getServices().getDescriptor().getConfiguration()) != null) {
                this.plugin.getServices().getDescriptor().setConfiguration(null);
                this.plugin.restore(desc, true);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.processEvent(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSources(Collection<TrendingSource> sources) {
        ArrayList<TrendingSource> ss = new ArrayList<TrendingSource>(sources);
        Object object = this.sourceLock;
        synchronized (object) {
            this.rawSource.set(ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilters(Collection<TrendingFilter> filters) {
        Object object = this.sourceLock;
        synchronized (object) {
            if (filters.isEmpty()) {
                this.filteredSource.set(this.rawSource);
            } else {
                ArrayList<TrendingSource> sources = new ArrayList<TrendingSource>(filters.size());
                filters.forEach(filter -> sources.add(filter.filter(this.rawSource)));
                this.filteredSource.set(sources);
            }
        }
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.selectedChannel = (TrendingChannel)nodes[0].objectForClass(TrendingChannel.class);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        menu.add(this.actShow);
        menu.add(this.actPlot);
        menu.add(this.actOverlay);
        menu.add(this.actNewPlot);
        menu.add(this.actNewPage);
        menu.add(this.actRefresh);
        menu.addSeparator();
        return menu;
    }

    public boolean doubleClick(FTreeNode node) {
        this.selectedChannel = (TrendingChannel)node.objectForClass(TrendingChannel.class);
        switch (this.plugin.getPreferences().getDoubleClick()) {
            case -1: {
                this.actShow.actionPerformed(null);
                break;
            }
            case -2: {
                this.actPlot.actionPerformed(null);
                break;
            }
            case -3: {
                this.actNewPlot.actionPerformed(null);
                break;
            }
            case -4: {
                this.actNewPage.actionPerformed(null);
                break;
            }
            default: {
                this.actShow.actionPerformed(null);
            }
        }
        return true;
    }

    public FTreeNodeTransferable modifyTransferable(FTreeNode[] nodes, FTreeNodeTransferable transferable) {
        transferable.addDataForClass(PlotRegionDropHandler.class, (Object)this.dropHandler);
        transferable.addDataForClass(Plotter.class, (Object)DummyPlotter.INSTANCE);
        return transferable;
    }

    static class DummyPlotter
    implements Plotter {
        static final DummyPlotter INSTANCE = new DummyPlotter();

        DummyPlotter() {
        }

        public void plot(Object data, int mode) {
        }

        public void plot(Object data, int mode, Object style, String options) {
        }

        public void remove(Object data) {
        }

        public void clear() {
        }

        public Component viewable() {
            return null;
        }

        public List getData() {
            return null;
        }
    }
}

