/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.ccob.data.CCOBAgentProperties;
import org.lsst.ccs.subsystem.ccob.ui.CCOBMonitorGui;

@Plugin(name="CCS CCOB Console Plugin", description="CCS CCOB Console Plugin")
public class CCOBConsolePlugin
extends ConsolePlugin {
    private final OptionalPage monPage = new CCOBMonitoringOptionalPage();

    public void initialize() {
        Console.getConsole().addOptionalPage(this.monPage);
    }

    static class CCOBMonitoringOptionalPage
    implements OptionalPage {
        CCOBMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/CCOB/Monitoring";
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(CCOBAgentProperties.CCOB_TYPE_AGENT_PROPERTY)) {
                return agent.getName();
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            CCOBMonitorGui gui = new CCOBMonitorGui(agentName);
            gui.initGui();
            return gui.getGuiLayout();
        }
    }
}

