/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.jas.RaftsMonitorFilter;

@Plugin(name="Rafts Monitoring new plugin", description="Displays monitor tables for rafts")
public class RaftsMonitorPlugin
extends ConsolePlugin {
    private final OptionalPage raftsMonitoringOptionalPage = new RaftsMonitoringOptionalPage();

    public void initialize() {
        Console.getConsole().addOptionalPage(this.raftsMonitoringOptionalPage);
    }

    static class RaftsMonitoringOptionalPage
    implements OptionalPage {
        RaftsMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/Rafts/Monitoring";
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY)) {
                return agent.getName();
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            RaftsMonitorFilter monitorFilter = new RaftsMonitorFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            return view.getPanel();
        }
    }
}

