/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AlertHandler;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AgentAlertStateAlertListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;

@Deprecated
public class AlertService
implements HasLifecycle {
    private final Agent agent;
    private final List<ClearAlertHandler> clearAlertHandlers = new ArrayList<ClearAlertHandler>();
    private final Object alertLock = new Object();
    private final int alertAccumulationPeriod = 2000;
    private final Map<String, AlertRunnable> alertRunnables = new HashMap<String, AlertRunnable>();
    private final Map<String, ScheduledFuture> alertTasks = new HashMap<String, ScheduledFuture>();
    private final CopyOnWriteArrayList<AlertListener> listeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, RaisedAlertSummary> source2summary = new ConcurrentHashMap();
    private ConcurrentMessagingUtils messagingUtils;
    private final AgentPresenceListener alertManagementAgentPresenceManager = new AlertManagementAgentPresenceListener();
    private final AgentPresenceListener alertListeningAgentPresenceManager = new AlertListeningAgentPresenceListener();
    private final StatusMessageListener alertListeningStatusMessageListener = new AgentListeningStatusMessageListener();
    private Predicate<AgentInfo> statusListeningAgentSelection = null;
    private boolean alreadyStarted = false;

    public AlertService(Agent a) {
        this.agent = a;
        ComponentLookup lookup = a.getComponentLookup();
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode(), new ComponentNode(null, "alertService", (Object)this));
        this.addListener(new AgentAlertStateAlertListener(this.agent));
    }

    @Override
    public void postInit() {
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, AlertHandler.class, ah -> {
            if (ah instanceof ClearAlertHandler) {
                this.addClearAlertHandler((ClearAlertHandler)ah);
            }
        }, null);
        if (this.agent.getAgentInfo().getType() == AgentInfo.AgentType.CONSOLE || this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) > 0) {
            this.startStatusAlertListening(info -> info.isAgentWorkerOrService());
        }
    }

    @Override
    public void start() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.alertManagementAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.alertListeningAgentPresenceManager);
        }
        this.alreadyStarted = true;
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().addStatusMessageListener(this.alertListeningStatusMessageListener);
        }
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.alertManagementAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.alertListeningAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().removeStatusMessageListener(this.alertListeningStatusMessageListener);
        }
    }

    @Override
    public void postShutdown() {
        this.clearAlertHandlers.clear();
    }

    private void startStatusAlertListening(Predicate<AgentInfo> agentSelection) {
        if (this.alreadyStarted) {
            throw new RuntimeException("This method must be invoked before the HasLifecycle::postStart phase");
        }
        if (agentSelection == null) {
            throw new IllegalArgumentException("Cannot provide a null predicate.");
        }
        this.statusListeningAgentSelection = agentSelection;
    }

    public void addClearAlertHandler(ClearAlertHandler handler) {
        if (this.clearAlertHandlers.contains(handler)) {
            System.out.println("WARNING: The clear alert handler has already been added. Please remove any calls to \"addClearAlertHandler\" as the framework is picking them up from the lookup tree.");
        }
        this.clearAlertHandlers.add(handler);
    }

    public void raiseAlert(String source, Alert alert, AlertState severity, String cause) {
        RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
        this.internalRaiseAlert(source, keeper, alert, severity, cause);
    }

    public void raiseAlert(Alert alert, AlertState severity, String cause) {
        this.raiseAlert(this.agent.getName(), alert, severity, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void internalRaiseAlert(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, String cause) {
        long ts = System.currentTimeMillis();
        Object object = this.alertLock;
        synchronized (object) {
            String alertId = alert.getAlertId();
            ScheduledFuture task = this.alertTasks.get(alertId);
            if (task == null || task.isDone()) {
                this.raiseAlertAndAccumulate(source, keeper, alert, severity, ts, cause);
            } else {
                AlertRunnable ar = this.alertRunnables.get(alertId);
                if (ar.severity != severity) {
                    if (task.cancel(false)) {
                        ar.updateBookkeeperAndSendStatusAlert();
                    }
                    this.raiseAlertAndAccumulate(source, keeper, alert, severity, ts, cause);
                } else {
                    ar.accumulate(cause);
                }
            }
        }
    }

    private void raiseAlertAndAccumulate(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, long ts, String cause) {
        AlertRunnable immediateAlert = new AlertRunnable(source, keeper, alert, severity, ts, cause);
        immediateAlert.accumulate(cause);
        immediateAlert.updateBookkeeperAndSendStatusAlert();
        AlertRunnable r = new AlertRunnable(source, keeper, alert, severity, ts, cause);
        ScheduledFuture task = this.agent.getScheduler().schedule((Runnable)r, 2000L, TimeUnit.MILLISECONDS);
        this.alertRunnables.put(alert.getAlertId(), r);
        this.alertTasks.put(alert.getAlertId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] clearAlertsForSource(String source, String ... alertId) {
        Object object = this.alertLock;
        synchronized (object) {
            String summary;
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
            ArrayList<String> clearedAlerts = new ArrayList<String>();
            for (String id : alertId) {
                ScheduledFuture alertTask = this.alertTasks.get(id);
                if (alertTask != null) {
                    alertTask.cancel(true);
                    this.alertTasks.remove(id);
                }
                boolean clearAlert = true;
                RaisedAlertHistory raisedAlert = keeper.getRaisedAlert(id);
                if (raisedAlert != null) {
                    for (ClearAlertHandler handler : this.clearAlertHandlers) {
                        ClearAlertHandler.ClearAlertCode code = handler.canClearAlert(raisedAlert.getLatestAlert());
                        if (code == ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) {
                            clearAlert = true;
                            continue;
                        }
                        if (code != ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT) continue;
                        clearAlert = false;
                        break;
                    }
                }
                if (!clearAlert) continue;
                keeper.clearAlert(id);
                clearedAlerts.add(id);
            }
            String[] clearedIds = new String[clearedAlerts.size()];
            if (!clearedAlerts.isEmpty()) {
                clearedIds = clearedAlerts.toArray(clearedIds);
                this.fireAlertEvent(new AlertEvent(source, clearedIds, (RaisedAlertSummary)keeper, AlertEvent.AlertEventType.ALERT_CLEARED));
            }
            if (clearedIds.length > 0) {
                summary = "Cleared Alert Id" + (clearedIds.length > 1 ? "s" : "") + " (";
                for (int i = 0; i < clearedIds.length; ++i) {
                    summary = summary + clearedIds[i];
                    if (i >= clearedIds.length - 1) continue;
                    summary = summary + ", ";
                }
                summary = summary + ")";
            } else {
                summary = "Attempt to clear alerts, but no Alerts were cleared";
            }
            this.agent.getLogger().info((Object)(summary + " the resulting Alert State is " + keeper.getAlertState().name()));
            return clearedIds;
        }
    }

    @Command(description="Clear alerts", type=Command.CommandType.ACTION)
    public String[] clearAlerts(String ... alertId) {
        return this.clearAlertsForSource(this.agent.getName(), alertId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] clearAllAlertsForSource(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
            Set alerts = keeper.getAllRaisedAlertHistories();
            String[] alertId = new String[alerts.size()];
            int count = 0;
            for (RaisedAlertHistory alert : alerts) {
                alertId[count++] = alert.getLatestAlert().getAlertId();
            }
            return this.clearAlerts(alertId);
        }
    }

    @Command(description="Clear all alerts", type=Command.CommandType.ACTION)
    public String[] clearAllAlerts() {
        return this.clearAllAlertsForSource(this.agent.getName());
    }

    private Level getLogLevelForAlertState(AlertState state) {
        if (state == AlertState.ALARM) {
            return Level.SEVERE;
        }
        if (state == AlertState.WARNING) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Command(description="Get the Raised Alert Summary", type=Command.CommandType.QUERY)
    public RaisedAlertSummary getRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(this.agent.getName());
            return keeper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Publish the Raised Alert Summary", type=Command.CommandType.QUERY)
    public void publishRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(this.agent.getName());
            this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusRaisedAlertSummary((RaisedAlertSummary)keeper, this.agent.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(AlertListener listener) {
        Object object = this.alertLock;
        synchronized (object) {
            boolean ok = this.listeners.addIfAbsent(listener);
            if (!ok) {
                throw new IllegalArgumentException("The listener is already registered");
            }
            for (String source : this.source2summary.keySet()) {
                listener.onAlert(new AlertEvent(source, new String[0], this.source2summary.get(source), AlertEvent.AlertEventType.AGENT_CONNECTION));
            }
        }
    }

    public final void removeListener(AlertListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAlertEvent(AlertEvent event) {
        Object object = this.alertLock;
        synchronized (object) {
            this.listeners.forEach(listener -> listener.onAlert(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaisedAlertBookkeeper getBookkeeperForSource(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertSummary summary = this.source2summary.get(source);
            if (summary == null) {
                summary = new RaisedAlertBookkeeper();
                this.source2summary.put(source, summary);
            }
            return (RaisedAlertBookkeeper)summary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaisedAlertSummary getSummary(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            return this.source2summary.get(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RaisedAlertSummary> getAllSummaries() {
        Object object = this.alertLock;
        synchronized (object) {
            return new HashMap<String, RaisedAlertSummary>(this.source2summary);
        }
    }

    private ConcurrentMessagingUtils getConcurrentMessagingUtils() {
        if (this.messagingUtils == null) {
            this.messagingUtils = new ConcurrentMessagingUtils(this.agent.getMessagingAccess());
        }
        return this.messagingUtils;
    }

    class AgentListeningStatusMessageListener
    implements StatusMessageListener {
        AgentListeningStatusMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusAlert && AlertService.this.statusListeningAgentSelection.test(((StatusAlert)msg).getOriginAgentInfo())) {
                String source = msg.getOriginAgentInfo().getName();
                StatusAlert message = (StatusAlert)msg;
                AgentListeningStatusMessageListener agentListeningStatusMessageListener = this;
                synchronized (agentListeningStatusMessageListener) {
                    RaisedAlertSummary summary = message.getRaisedAlertSummary();
                    AlertService.this.source2summary.put(source, summary);
                    if (message instanceof StatusRaisedAlert) {
                        Alert alert = ((StatusRaisedAlert)message).getRaisedAlert();
                        AlertService.this.fireAlertEvent(new AlertEvent(source, alert, summary, AlertEvent.AlertEventType.ALERT_RAISED));
                    } else if (message instanceof StatusClearedAlert) {
                        String[] ids = ((StatusClearedAlert)message).getClearAlertIds();
                        AlertService.this.fireAlertEvent(new AlertEvent(source, ids, summary, AlertEvent.AlertEventType.ALERT_CLEARED));
                    } else if (message instanceof StatusRaisedAlertSummary) {
                        AlertService.this.fireAlertEvent(new AlertEvent(source, new String[0], summary, AlertEvent.AlertEventType.AGENT_CONNECTION));
                    }
                }
            }
        }
    }

    class AlertListeningAgentPresenceListener
    implements AgentPresenceListener {
        AlertListeningAgentPresenceListener() {
        }

        public void connecting(AgentInfo a) {
            if (a.isAgentWorkerOrService()) {
                AlertService.this.agent.getScheduler().schedule(() -> {
                    if (!AlertService.this.source2summary.containsKey(a.getName())) {
                        AlertService.this.agent.getLogger().warn((Object)("requested raised alert summary for " + a.getName()));
                        CommandRequest cmd = new CommandRequest(a.getName(), "publishRaisedAlertSummary");
                        AlertService.this.getConcurrentMessagingUtils().sendAsynchronousCommand(cmd);
                    }
                }, 5L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnecting(AgentInfo agent) {
            String source = agent.getName();
            AlertListeningAgentPresenceListener alertListeningAgentPresenceListener = this;
            synchronized (alertListeningAgentPresenceListener) {
                RaisedAlertSummary current = (RaisedAlertSummary)AlertService.this.source2summary.remove(source);
                if (current != null) {
                    AlertService.this.fireAlertEvent(new AlertEvent(source, new String[0], null, AlertEvent.AlertEventType.AGENT_DISCONNECTION));
                }
            }
        }
    }

    class AlertManagementAgentPresenceListener
    implements AgentPresenceListener {
        AlertManagementAgentPresenceListener() {
        }

        public void connecting(AgentInfo a) {
            if (a.getType() != AgentInfo.AgentType.WORKER) {
                this.delayedPublishSummary(a.getName());
            }
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (info.getType() == AgentInfo.AgentType.WORKER) continue;
                this.delayedPublishSummary(info.getName());
                break;
            }
        }

        private void delayedPublishSummary(String a) {
            AlertService.this.agent.getScheduler().schedule(() -> AlertService.this.publishRaisedAlertSummary(), 2L, TimeUnit.SECONDS);
        }

        public void disconnecting(AgentInfo agent) {
        }
    }

    private final class AlertRunnable
    implements Runnable {
        private final Alert alert;
        private final AlertState severity;
        private String cause;
        private final long ts;
        private int count = 0;
        private final RaisedAlertBookkeeper keeper;
        private final String source;

        private AlertRunnable(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, long timestamp, String cause) {
            this.alert = alert;
            this.severity = severity;
            this.ts = timestamp;
            this.cause = cause;
            this.keeper = keeper;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accumulate(String cause) {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                this.cause = cause;
                ++this.count;
            }
        }

        @Override
        public void run() {
            this.updateBookkeeperAndSendStatusAlert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBookkeeperAndSendStatusAlert() {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                if (this.count <= 0) {
                    return;
                }
                RaisedAlertHistory raisedAlert = this.keeper.raiseAlert(this.alert, this.severity, this.ts, this.cause, this.count);
                AlertService.this.fireAlertEvent(new AlertEvent(this.source, this.alert, (RaisedAlertSummary)this.keeper, AlertEvent.AlertEventType.ALERT_RAISED));
                AlertService.this.agent.getLogger().log(AlertService.this.getLogLevelForAlertState(raisedAlert.getLatestAlertState()), "Raised Alert " + this.alert.getAlertId() + "(" + this.alert.getDescription() + ") " + this.count + " time" + (this.count > 1 ? "s" : "") + ". Last cause : \"" + this.cause + "\". Overall AlertState=" + this.keeper.getAlertState().name(), (Object)"");
            }
        }
    }
}

