/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorCommandSender;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorPlatformGUI;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorReplyReceiver;

@Plugin(name="MotorPlatformGUI", description="Generic motor control for motorized platforms.")
public class MotorPlatformPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(MotorPlatformPlugin.class.getName());
    private final MotorPlatformGUI gui = new MotorPlatformGUI();

    public void initialize() {
        PanelManager pm = this.getConsole().getPanelManager();
        if (SwingUtilities.isEventDispatchThread()) {
            pm.open((Component)this.gui, "Motorized Platform Control Panel");
            this.initTask();
        } else {
            SwingUtilities.invokeLater(() -> {
                pm.open((Component)this.gui, "Motorized Platform Control Panel");
                this.initTask();
            });
        }
    }

    private void initTask() {
        MotorReplyReceiver replyHandler = new MotorReplyReceiver(this.getConsole().getMessagingAccess(), this.gui);
        MotorCommandSender sender = new MotorCommandSender(this.getConsole().getMessagingAccess(), replyHandler);
        this.gui.init(sender, replyHandler);
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connecting(AgentInfo agent) {
        this.gui.addSubsystem(agent.getName());
    }

    public void disconnecting(AgentInfo agent) {
        this.gui.removeSubsystem(agent.getName());
    }
}

