/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBrushStyle;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.ColorStyleParameter;
import hep.aida.ref.plotter.DoubleStyleParameter;
import hep.aida.ref.plotter.RevolvingColorStyleParameter;
import hep.aida.ref.plotter.StringStyleParameter;
import hep.aida.ref.plotter.Style;
import java.util.Iterator;
import java.util.List;

abstract class BrushStyle
extends BaseStyle
implements IBrushStyle {
    BrushStyle() {
    }

    @Override
    protected void initializeBaseStyle() {
        this.addParameter(new ColorStyleParameter("color"));
        this.addParameter(new RevolvingColorStyleParameter("colorRotate"));
        this.addParameter(new StringStyleParameter("colorRotateMethod", Style.ROTATE_METHOD[0], Style.ROTATE_METHOD));
        this.addParameter(new DoubleStyleParameter("opacity", 1.0, 0.0, 1.0));
        String defaultRotation = "fuchsia, green, orange, cyan, blue, red";
        this.setParameterDefault("colorRotate", defaultRotation);
    }

    public String[] availableColors() {
        return this.availableParameterOptions("color");
    }

    public String color() {
        return ((ColorStyleParameter)this.deepestSetParameter("color")).stringValue();
    }

    public String color(int gi, int oi) {
        if (this.isParameterSet("color", false)) {
            return this.parameter("color").parValue();
        }
        if (this.isParameterSet("colorRotate", false)) {
            if (this.parameterValue("colorRotateMethod").trim().equalsIgnoreCase(Style.ROTATE_METHOD[0])) {
                return ((RevolvingColorStyleParameter)this.parameter("colorRotate")).stringValue(gi);
            }
            return ((RevolvingColorStyleParameter)this.parameter("colorRotate")).stringValue(oi);
        }
        List parents = this.parentList();
        if (parents != null) {
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                String tmp;
                BrushStyle pbs = null;
                Object obj = it.next();
                if (!(obj instanceof BrushStyle) || (tmp = (pbs = (BrushStyle)obj).color(gi, oi)) == null) continue;
                return tmp;
            }
        }
        return null;
    }

    public double opacity() {
        return ((DoubleStyleParameter)this.deepestSetParameter("opacity")).value();
    }

    public boolean setColor(String color) {
        return this.setParameter("color", color);
    }

    public boolean setOpacity(double opacity) {
        return ((DoubleStyleParameter)this.parameter("opacity")).setValue(opacity);
    }
}

