/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.DataProviderDictionaryImpl;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.utilities.logging.Logger;

public final class DataProviderDictionaryService
implements ServiceLifecycle,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private final ComponentLookup lookupService;
    private final ComponentNode dataProviderDictionaryServiceNode;
    private final Agent agent;
    private final DataProviderDictionaryImpl dataProviderDictionary = new DataProviderDictionaryImpl();
    private final DataProviderDictionaryCommands dictionaryCommands = new DataProviderDictionaryCommands();
    private final AgentPresenceListener dictionaryServiceAgentPresenceManager = new DictionaryServiceAgentPresenceListener();

    public DataProviderDictionaryService(Agent a) {
        this.lookupService = a.getComponentLookup();
        this.dataProviderDictionaryServiceNode = new ComponentNode(this.lookupService.getTopComponentNode(), "dataProviderDictionaryService", (Object)this);
        this.lookupService.addComponentNodeToLookup(this.lookupService.getTopComponentNode(), this.dataProviderDictionaryServiceNode);
        this.agent = a;
    }

    @Override
    public void init() {
        this.agent.addCommandsFromObject(this.dictionaryCommands, "");
    }

    @Override
    public void postInit() {
        TreeWalkerUtils.proceduralWalk(this.lookupService, null, HasDataProviderInfos.class, hasDataProviderInfos -> {
            for (DataProviderInfo dataProviderInfo : hasDataProviderInfos.getDataProviderInfos()) {
                ComponentNode node = this.lookupService.getNodeByPath(dataProviderInfo.getPath());
                if (node == null) {
                    log.warn((Object)("No component is linked to path " + dataProviderInfo.getPath()));
                }
                while (node != null) {
                    this.dataProviderDictionary.addDataProviderDescriptionToGroup(dataProviderInfo, node.getPath());
                    node = node.getParent();
                }
            }
        }, null);
    }

    @Override
    public void start() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    public DataProviderDictionary getDataProviderDictionary() {
        return this.dataProviderDictionary;
    }

    public void addMetadataForDataGroup(KeyValueDataList data, String metadataName, String metadataValue, String dataGroupName) {
        data.addData(dataGroupName + "/" + metadataName, (Serializable)((Object)String.valueOf(metadataValue)), KeyValueData.KeyValueDataType.KeyValueMetaData);
    }

    public void addMetadataForObject(KeyValueDataList data, String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.lookupService.getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        this.addMetadataForDataGroup(data, metadataName, metadataValue, n.getPath());
    }

    public void publishMetadataForDataGroup(String metadataName, String metadataValue, String dataGroupName) {
        if (dataGroupName == null) {
            dataGroupName = "";
        }
        if (!this.dataProviderDictionary.getGroups().contains(dataGroupName)) {
            throw new IllegalArgumentException("Group: " + dataGroupName + " does not exist");
        }
        KeyValueDataList data = new KeyValueDataList();
        this.addMetadataForDataGroup(data, metadataName, String.valueOf(metadataValue), dataGroupName);
        this.agent.publishSubsystemDataOnStatusBus((KeyValueData)data);
    }

    public void publishMetadataForObject(String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.lookupService.getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        this.publishMetadataForDataGroup(metadataName, metadataValue, n.getPath());
    }

    class DictionaryServiceAgentPresenceListener
    implements AgentPresenceListener {
        DictionaryServiceAgentPresenceListener() {
        }

        public void connecting(AgentInfo a) {
            if (a.getType() != AgentInfo.AgentType.WORKER) {
                this.delayedPublishDictionary(a.getName());
            }
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (info.getType() == AgentInfo.AgentType.WORKER) continue;
                this.delayedPublishDictionary(info.getName());
                break;
            }
        }

        private void delayedPublishDictionary(String a) {
            DataProviderDictionaryService.this.agent.getScheduler().schedule(() -> DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderDictionary(), 2L, TimeUnit.SECONDS);
        }

        public void disconnecting(AgentInfo agent) {
        }
    }

    public class DataProviderDictionaryCommands {
        @Command(description="Publish on the status bus the Agent's dictionary of data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderDictionary() {
            DataProviderDictionaryService.this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusDataProviderDictionary((DataProviderDictionary)DataProviderDictionaryService.this.dataProviderDictionary, DataProviderDictionaryService.this.agent.getState()));
            TreeWalkerUtils.proceduralWalk(DataProviderDictionaryService.this.lookupService, null, HasDataProviderInfos.class, hasDataProviderInfos -> hasDataProviderInfos.publishDataProviderCurrentData(), null);
        }

        @Command(description="Publish Metadata for a data group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishMetadataForDataGroup(@Argument(name="metadataName") String metadataName, @Argument(name="metadataValue") String metadataValue, @Argument(name="dataGroupName", defaultValue="") String dataGroupName) {
            DataProviderDictionaryService.this.publishMetadataForDataGroup(metadataName, metadataValue, dataGroupName);
        }

        @Command(description="Get the available data groups", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public Set<String> getAvailableDataGroups() {
            return DataProviderDictionaryService.this.dataProviderDictionary.getGroups();
        }

        @Command(description="Show the trending data in a group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public List<DataProviderInfo> getDataInGroup(@Argument(name="dataGroupName", defaultValue="") String dataGroupName) {
            if (dataGroupName == null || dataGroupName.isEmpty()) {
                dataGroupName = "";
            }
            if (!DataProviderDictionaryService.this.dataProviderDictionary.getGroups().contains(dataGroupName)) {
                throw new IllegalArgumentException("Group: " + dataGroupName + " does not exist");
            }
            return DataProviderDictionaryService.this.dataProviderDictionary.getDataProviderDescriptionsForGroup(dataGroupName);
        }
    }
}

