/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.rafts.config.CABAC;

class CABACConfigPanel
extends JPanel {
    private static final Insets INSETS_STD = new Insets(4, 4, 4, 4);
    private static final int TF_WIDTH_S = 36;
    final int iCabac;
    final CABAC cabac;
    private final JFormattedTextField[] fields;
    private static final List<LabelDesc> labelDescs1 = new ArrayList<LabelDesc>();
    private static final List<FieldDesc> fieldDescs1 = new ArrayList<FieldDesc>();
    private static final List<LabelDesc> labelDescs2;
    private static final List<FieldDesc> fieldDescs2;
    private static final long serialVersionUID = 1L;

    CABACConfigPanel(int vrsn, int ic, CABAC c) {
        this.iCabac = ic;
        this.cabac = c;
        NumberFormatter fmt3 = new NumberFormatter(new DecimalFormat("##0"));
        fmt3.setValueClass(Integer.class);
        this.fields = new JFormattedTextField[23];
        Dimension d = null;
        for (int j = 0; j < this.fields.length; ++j) {
            JFormattedTextField field = new JFormattedTextField(fmt3);
            if (j == 0) {
                d = field.getPreferredSize();
                d.width = 36;
            }
            field.setPreferredSize(d);
            field.setMinimumSize(d);
            this.fields[j] = field;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS_STD;
        gbc.anchor = 18;
        String title = "CABAC " + this.iCabac + (this.iCabac % 2 == 0 ? " (upper)" : " (lower)");
        this.setBorder(BorderFactory.createTitledBorder(title));
        for (LabelDesc ld : vrsn == 0 ? labelDescs1 : labelDescs2) {
            gbc.gridx = ld.x;
            gbc.gridy = ld.y;
            this.add((Component)new JLabel(ld.text), gbc);
        }
        for (FieldDesc fd : vrsn == 0 ? fieldDescs1 : fieldDescs2) {
            gbc.gridx = fd.x;
            gbc.gridy = fd.y;
            this.add((Component)this.fields[fd.index], gbc);
        }
    }

    void save() {
        int[] values = this.cabac.getValues();
        for (int j = 0; j < 23; ++j) {
            values[j] = (Integer)this.fields[j].getValue();
        }
    }

    void read() {
        int[] values = this.cabac.getValues();
        for (int j = 0; j < 23; ++j) {
            this.fields[j].setValue(values[j]);
        }
    }

    static {
        labelDescs1.add(new LabelDesc("RD:", 0, 0));
        labelDescs1.add(new LabelDesc("OG:", 0, 1));
        labelDescs1.add(new LabelDesc("GD:", 0, 2));
        labelDescs1.add(new LabelDesc("RG:", 0, 3));
        labelDescs1.add(new LabelDesc("SCLKs:", 0, 4));
        labelDescs1.add(new LabelDesc("PCLKs:", 0, 5));
        labelDescs1.add(new LabelDesc("Rdout OD:", 0, 6));
        labelDescs1.add(new LabelDesc("Expos OD:", 0, 7));
        fieldDescs1.add(new FieldDesc(0, 1, 0));
        fieldDescs1.add(new FieldDesc(1, 1, 1));
        fieldDescs1.add(new FieldDesc(2, 1, 2));
        fieldDescs1.add(new FieldDesc(7, 1, 3));
        fieldDescs1.add(new FieldDesc(9, 1, 4));
        fieldDescs1.add(new FieldDesc(11, 2, 4));
        fieldDescs1.add(new FieldDesc(13, 3, 4));
        fieldDescs1.add(new FieldDesc(15, 1, 5));
        fieldDescs1.add(new FieldDesc(17, 2, 5));
        fieldDescs1.add(new FieldDesc(19, 3, 5));
        fieldDescs1.add(new FieldDesc(21, 4, 5));
        fieldDescs1.add(new FieldDesc(3, 1, 6));
        fieldDescs1.add(new FieldDesc(4, 2, 6));
        fieldDescs1.add(new FieldDesc(5, 1, 7));
        fieldDescs1.add(new FieldDesc(6, 2, 7));
        labelDescs2 = new ArrayList<LabelDesc>();
        fieldDescs2 = new ArrayList<FieldDesc>();
        labelDescs2.add(new LabelDesc("RD:", 0, 0));
        labelDescs2.add(new LabelDesc("OG:", 0, 1));
        labelDescs2.add(new LabelDesc("GD:", 0, 2));
        labelDescs2.add(new LabelDesc("RG rise:", 0, 3));
        labelDescs2.add(new LabelDesc("RG fall:", 0, 4));
        labelDescs2.add(new LabelDesc("SCLKs rise:", 0, 5));
        labelDescs2.add(new LabelDesc("SCLKs fall:", 0, 6));
        labelDescs2.add(new LabelDesc("PCLKs rise:", 0, 7));
        labelDescs2.add(new LabelDesc("PCLKs fall:", 0, 8));
        labelDescs2.add(new LabelDesc("Rdout OD:", 0, 9));
        labelDescs2.add(new LabelDesc("Expos OD:", 0, 10));
        fieldDescs2.add(new FieldDesc(0, 1, 0));
        fieldDescs2.add(new FieldDesc(1, 1, 1));
        fieldDescs2.add(new FieldDesc(2, 1, 2));
        fieldDescs2.add(new FieldDesc(7, 1, 3));
        fieldDescs2.add(new FieldDesc(8, 1, 4));
        fieldDescs2.add(new FieldDesc(9, 1, 5));
        fieldDescs2.add(new FieldDesc(11, 2, 5));
        fieldDescs2.add(new FieldDesc(13, 3, 5));
        fieldDescs2.add(new FieldDesc(10, 1, 6));
        fieldDescs2.add(new FieldDesc(12, 2, 6));
        fieldDescs2.add(new FieldDesc(14, 3, 6));
        fieldDescs2.add(new FieldDesc(15, 1, 7));
        fieldDescs2.add(new FieldDesc(17, 2, 7));
        fieldDescs2.add(new FieldDesc(19, 3, 7));
        fieldDescs2.add(new FieldDesc(21, 4, 7));
        fieldDescs2.add(new FieldDesc(16, 1, 8));
        fieldDescs2.add(new FieldDesc(18, 2, 8));
        fieldDescs2.add(new FieldDesc(20, 3, 8));
        fieldDescs2.add(new FieldDesc(22, 4, 8));
        fieldDescs2.add(new FieldDesc(3, 1, 9));
        fieldDescs2.add(new FieldDesc(4, 2, 9));
        fieldDescs2.add(new FieldDesc(5, 1, 10));
        fieldDescs2.add(new FieldDesc(6, 2, 10));
    }

    static class FieldDesc {
        int index;
        int x;
        int y;

        FieldDesc(int index, int x, int y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }
    }

    static class LabelDesc {
        String text;
        int x;
        int y;

        LabelDesc(String text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }
    }
}

