/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

public class CCSBusesConfigurationDAO
implements ConfigurationDAO {
    private final AgentPresenceManager apm;
    private final ConcurrentMessagingUtils cmu;
    private static final String DB_NAME = "localdb/configuration-server";

    public CCSBusesConfigurationDAO(AgentMessagingLayer aml) {
        this.cmu = new ConcurrentMessagingUtils(aml);
        this.apm = aml.getAgentPresenceManager();
    }

    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return this.registerConfiguration(agentName, configInfo);
    }

    @Override
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDesc) throws ConfigurationServiceException {
        try {
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadConfiguration", new Object[]{agentName, configDesc}));
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }

    @Override
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        try {
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadGlobalConfiguration", new Object[]{agentName, name, version}));
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.apm.agentExists("localdb");
    }

    @Override
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            return (ConfigurationDescription)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "registerConfiguration", new Object[]{agentName, configInfo}));
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }
}

