/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.CABAC;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.ui.ASPICConfigPanel;
import org.lsst.ccs.subsystem.rafts.ui.BiasesConfigPanel;
import org.lsst.ccs.subsystem.rafts.ui.CABACConfigPanel;

public class REBConfigPanel
extends JPanel {
    private static final int TF_WIDTH = 50;
    private static final int TF_WIDTH_L = 80;
    private static final int TF_WIDTH_S = 30;
    private static final int NO_DAC = -1;
    private static final Map<String, JDialog> active = new HashMap<String, JDialog>();
    private final REB reb;
    private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    private final NumberFormatter fmtf5 = new NumberFormatter(new DecimalFormat("##0.0#"));
    private final NumberFormatter fmt3 = new NumberFormatter(new DecimalFormat("##0"));
    private final Insets insets_std = new Insets(4, 4, 4, 4);
    private final Insets insets_big = new Insets(14, 4, 6, 4);
    private final List<Integer> dacs;
    private final List<Integer> ccds = new ArrayList<Integer>();
    private final String name;
    private final Parent parent;
    private final boolean showCsgate;
    JLabel lbId = new JLabel("REB id:");
    JFormattedTextField tfId;
    JLabel lbIfcName = new JLabel("REB iface:");
    JTextField tfIfcName;
    JLabel lbCcdMask = new JLabel("CCD mask:");
    JComboBox cbCcdMask;
    JLabel[] lbDacVoltage = new JLabel[21];
    JFormattedTextField[] tfDacVoltage = new JFormattedTextField[21];
    JLabel[] lbDacCurrent = new JLabel[3];
    JFormattedTextField[] tfDacCurrent = new JFormattedTextField[3];
    JButton btCopyRight = new JButton("copy >");
    JButton btCopyDown = new JButton("copy v");
    ASPICConfigPanel[] aspicPanels = new ASPICConfigPanel[6];
    BiasesConfigPanel[] biasPanels = new BiasesConfigPanel[3];
    CABACConfigPanel[] cabacPanels = new CABACConfigPanel[6];
    JPanel[] ccdPanels = new JPanel[3];
    JTabbedPane ccdTabs = new JTabbedPane();
    JPanel ccdContainer = new JPanel();
    boolean dacRaw;
    private static final Map<Integer, String> dacNames = new HashMap<Integer, String>();
    private static final List<Integer> dacList1;
    private static final List<Integer> dacList2;
    private static final List<Integer> dacList3;
    private static final long serialVersionUID = 1L;

    public REBConfigPanel(REB reb, String name, Parent parent) {
        this.reb = reb;
        this.name = name;
        this.parent = parent;
        this.dacRaw = reb.isDacRaw();
        int version = reb.getDacVersion();
        this.dacs = !this.dacRaw || version == 0 ? dacList1 : (version == 1 || version == 3 ? dacList2 : dacList3);
        this.showCsgate = version == 0;
        boolean groupByThree = this.dacRaw && version == 2;
        boolean gotCabacs = false;
        for (CABAC cabac : reb.getCabacs()) {
            if (cabac == null) continue;
            gotCabacs = true;
        }
        version = reb.getCabacVersion();
        boolean showCabacPower = gotCabacs && version == 1;
        boolean showCabacs = gotCabacs && version != -1;
        this.fmt3.setValueClass(Integer.class);
        this.fmt5.setValueClass(Integer.class);
        this.fmtf5.setValueClass(Double.class);
        int ccdMask = reb.getMaxCcdMask();
        for (int j = 0; j < 3; ++j) {
            if ((1 << j & ccdMask) == 0) continue;
            this.ccds.add(j);
        }
        this.tfId = new JFormattedTextField(this.fmt3);
        Dimension d3 = this.tfId.getPreferredSize();
        d3.width = 30;
        this.tfId.setPreferredSize(d3);
        this.tfId.setMinimumSize(d3);
        this.tfIfcName = new JTextField();
        Dimension d8 = this.tfIfcName.getPreferredSize();
        d8.width = 80;
        this.tfIfcName.setPreferredSize(d8);
        this.tfIfcName.setMinimumSize(d8);
        this.cbCcdMask = new JComboBox();
        int mask = reb.getMaxCcdMask();
        for (int j = 1; j < 8; ++j) {
            if ((j & mask) != j) continue;
            this.cbCcdMask.addItem(j);
        }
        Dimension d5 = (Dimension)d3.clone();
        d5.width = 50;
        for (int dac : this.dacs) {
            this.lbDacVoltage[dac] = new JLabel(dacNames.get(dac) + ":");
            this.tfDacVoltage[dac] = new JFormattedTextField(this.dacRaw ? this.fmt5 : this.fmtf5);
            this.tfDacVoltage[dac].setPreferredSize(d5);
            this.tfDacVoltage[dac].setMinimumSize(d5);
        }
        if (this.showCsgate) {
            for (int ccd = 0; ccd < 3; ++ccd) {
                this.lbDacCurrent[ccd] = new JLabel("CS Gate " + ccd + ":");
                this.tfDacCurrent[ccd] = new JFormattedTextField(this.fmt5);
                this.tfDacCurrent[ccd].setPreferredSize(d5);
                this.tfDacCurrent[ccd].setMinimumSize(d5);
            }
        }
        this.btCopyRight.setFocusable(false);
        this.btCopyRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.copyRight();
            }
        });
        this.btCopyDown.setFocusable(false);
        this.btCopyDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.copyDown();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.lbId, gbc);
        ++gbc.gridx;
        this.add((Component)this.tfId, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.lbIfcName, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        this.add((Component)this.tfIfcName, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.lbCcdMask, gbc);
        ++gbc.gridx;
        this.add((Component)this.cbCcdMask, gbc);
        this.cbCcdMask.setFocusable(false);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.insets_big;
        this.add((Component)new JLabel("DAC voltages"), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = this.insets_std;
        int fld = 0;
        for (int dac : this.dacs) {
            gbc.gridx = 2 * (fld & 1);
            gbc.gridy += 1 - (fld & 1);
            this.add((Component)this.lbDacVoltage[dac], gbc);
            ++gbc.gridx;
            this.add((Component)this.tfDacVoltage[dac], gbc);
            if (!groupByThree || (++fld & 3) != 3) continue;
            ++fld;
        }
        if (this.showCsgate) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.insets = this.insets_big;
            this.add((Component)new JLabel("DAC currents"), gbc);
            ++gbc.gridx;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.anchor = 10;
            this.add((Component)new JSeparator(), gbc);
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 18;
            gbc.insets = this.insets_std;
            for (int ccd : this.ccds) {
                gbc.gridx = 0;
                ++gbc.gridy;
                this.add((Component)this.lbDacCurrent[ccd], gbc);
                ++gbc.gridx;
                this.add((Component)this.tfDacCurrent[ccd], gbc);
            }
        }
        if (showCabacPower) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 4;
            this.add((Component)new CABACPowerPanel(), gbc);
        }
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.gridheight = 0;
        gbc.gridwidth = 1;
        this.add((Component)new JSeparator(1), gbc);
        gbc.fill = 0;
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        this.add((Component)this.ccdContainer, gbc);
        this.ccdContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = this.insets_std;
        gbc1.gridwidth = 2;
        gbc1.gridheight = 1;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 18;
        this.ccdContainer.add((Component)this.ccdTabs, gbc1);
        if (showCabacs) {
            gbc1.gridwidth = 1;
            gbc1.gridy = 1;
            gbc1.anchor = 12;
            this.ccdContainer.add((Component)this.btCopyRight, gbc1);
            gbc1.gridx = 1;
            gbc1.anchor = 11;
            this.ccdContainer.add((Component)this.btCopyDown, gbc1);
        }
        for (int ccd : this.ccds) {
            JPanel ccdPanel = new JPanel();
            ccdPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.insets = this.insets_std;
            gbc2.gridwidth = 1;
            gbc2.gridheight = 1;
            gbc2.anchor = 18;
            gbc2.gridx = 0;
            gbc2.gridy = 0;
            for (int side = 0; side < 2; ++side) {
                int jc = 2 * ccd + side;
                ASPIC aspic = reb.getAspics()[jc];
                if (aspic != null) {
                    this.aspicPanels[jc] = new ASPICConfigPanel(jc, aspic);
                    ccdPanel.add((Component)this.aspicPanels[jc], gbc2);
                }
                ++gbc2.gridy;
                if (!showCabacs) continue;
                CABAC cabac = reb.getCabacs()[jc];
                if (cabac != null) {
                    this.cabacPanels[jc] = new CABACConfigPanel(reb.getCabacVersion(), jc, cabac);
                    ccdPanel.add((Component)this.cabacPanels[jc], gbc2);
                }
                ++gbc2.gridx;
                --gbc2.gridy;
            }
            BiasDACS bias = reb.getBiases()[ccd];
            if (bias != null) {
                this.biasPanels[ccd] = new BiasesConfigPanel(ccd, bias, reb.isBiasRaw());
                ccdPanel.add((Component)this.biasPanels[ccd], gbc2);
            }
            this.ccdPanels[ccd] = ccdPanel;
            this.ccdTabs.addTab("CCD " + ccd, this.ccdPanels[ccd]);
        }
        this.read();
    }

    private void copyRight() {
        for (int ccd : this.ccds) {
            CABACConfigPanel panel1 = this.cabacPanels[2 * ccd];
            CABACConfigPanel panel2 = this.cabacPanels[2 * ccd + 1];
            if (panel1 == null || panel2 == null) continue;
            panel1.save();
            panel2.cabac.copyFrom(panel1.cabac);
            panel2.read();
        }
    }

    private void copyDown() {
        CABACConfigPanel panel10 = null;
        CABACConfigPanel panel20 = null;
        for (int ccd : this.ccds) {
            CABACConfigPanel panel1 = this.cabacPanels[2 * ccd];
            CABACConfigPanel panel2 = this.cabacPanels[2 * ccd + 1];
            if (panel1 != null) {
                if (panel10 == null) {
                    panel10 = panel1;
                    panel10.save();
                } else {
                    panel1.cabac.copyFrom(panel10.cabac);
                    panel1.read();
                }
            }
            if (panel2 == null) continue;
            if (panel20 == null) {
                panel20 = panel2;
                panel20.save();
                continue;
            }
            panel2.cabac.copyFrom(panel20.cabac);
            panel2.read();
        }
    }

    private void save() {
        Object[] values;
        this.reb.setId((Integer)this.tfId.getValue());
        this.reb.setIfcName(this.tfIfcName.getText());
        this.reb.setCcdMask((Integer)this.cbCcdMask.getSelectedItem());
        if (this.dacRaw) {
            values = this.reb.getDacs().getValues();
            for (int dac : this.dacs) {
                values[dac] = (Integer)this.tfDacVoltage[dac].getValue();
            }
            if (this.showCsgate) {
                for (int ccd : this.ccds) {
                    int n = ccd == 0 ? 12 : (ccd == 1 ? 13 : 14);
                    values[n] = (Integer)this.tfDacCurrent[ccd].getValue();
                }
            }
        } else {
            values = this.reb.getDacs().getPValues();
            for (int dac : this.dacs) {
                values[dac] = (int)((Double)this.tfDacVoltage[dac].getValue()).doubleValue();
            }
        }
        for (ASPICConfigPanel aSPICConfigPanel : this.aspicPanels) {
            if (aSPICConfigPanel == null) continue;
            aSPICConfigPanel.save();
        }
        for (JPanel jPanel : this.biasPanels) {
            if (jPanel == null) continue;
            ((BiasesConfigPanel)jPanel).save();
        }
        for (JPanel jPanel : this.cabacPanels) {
            if (jPanel == null) continue;
            ((CABACConfigPanel)jPanel).save();
        }
    }

    private void read() {
        Object[] values;
        this.tfId.setValue(this.reb.getId());
        this.tfIfcName.setText(this.reb.getIfcName());
        this.cbCcdMask.setSelectedItem(this.reb.getCcdMask());
        if (this.dacRaw) {
            values = this.reb.getDacs().getValues();
            for (int dac : this.dacs) {
                this.tfDacVoltage[dac].setValue(values[dac]);
            }
            if (this.showCsgate) {
                for (int ccd : this.ccds) {
                    int n = ccd == 0 ? 12 : (ccd == 1 ? 13 : 14);
                    this.tfDacCurrent[ccd].setValue(values[n]);
                }
            }
        } else {
            values = this.reb.getDacs().getPValues();
            for (int dac : this.dacs) {
                this.tfDacVoltage[dac].setValue(values[dac]);
            }
        }
        for (ASPICConfigPanel aSPICConfigPanel : this.aspicPanels) {
            if (aSPICConfigPanel == null) continue;
            aSPICConfigPanel.read();
        }
        for (JPanel jPanel : this.biasPanels) {
            if (jPanel == null) continue;
            ((BiasesConfigPanel)jPanel).read();
        }
        for (JPanel jPanel : this.cabacPanels) {
            if (jPanel == null) continue;
            ((CABACConfigPanel)jPanel).read();
        }
    }

    public static void edit(Window pWindow, final String name, final Parent parent) {
        JDialog dlg0 = active.get(name);
        if (dlg0 != null) {
            dlg0.toFront();
            return;
        }
        final REB reb = (REB)parent.sendCommand(name, "getREBConfig", new Object[0]);
        if (reb == null) {
            return;
        }
        final JDialog dlg = new JDialog(pWindow, name + " Configuration", Dialog.ModalityType.MODELESS);
        active.put(name, dlg);
        final REBConfigPanel cfgPanel = new REBConfigPanel(reb, name, parent);
        JButton btLoadDacs = new JButton("Load DACs");
        btLoadDacs.setFocusable(false);
        btLoadDacs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer count;
                Object reply = parent.sendCommand(name, "loadDacs", true);
                if (reply != null) {
                    count = (Integer)reply;
                    parent.display(count + " " + name + " DACs loaded");
                }
                if ((reply = parent.sendCommand(name, "loadBiasDacs", true)) != null) {
                    count = (Integer)reply;
                    parent.display(count + " " + name + " bias DACs loaded");
                }
            }
        });
        JButton btLoadAspics = new JButton("Load ASPICs");
        btLoadAspics.setFocusable(false);
        btLoadAspics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer count = (Integer)parent.sendCommand(name, "loadAspics", true);
                if (count == null) {
                    return;
                }
                Integer mask = (Integer)parent.sendCommand(name, "checkAspics", new Object[0]);
                ArrayList<Integer> masks = null;
                if (mask != null) {
                    masks = new ArrayList<Integer>();
                    masks.add(mask);
                }
                parent.display(count + " " + name + " ASPICs loaded: " + REBConfigPanel.getResult(masks));
            }
        });
        JButton btLoadCabacs = new JButton("Load CABACs");
        btLoadCabacs.setFocusable(false);
        btLoadCabacs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer count = (Integer)parent.sendCommand(name, "loadCabacs", new Object[0]);
                if (count == null) {
                    return;
                }
                List masks = (List)parent.sendCommand(name, "checkCabacs", new Object[0]);
                parent.display(count + " " + name + " CABACs loaded: " + REBConfigPanel.getResult(masks));
            }
        });
        JButton btUndo = new JButton("Undo");
        btUndo.setFocusable(false);
        btUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cfgPanel.read();
            }
        });
        JButton btApply = new JButton("Apply");
        btApply.setFocusable(false);
        btApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REB newReb;
                cfgPanel.save();
                Object reply = parent.sendCommand(name, "setREBConfig", reb);
                if (reply != null) {
                    parent.display(name + " configuration applied");
                }
                if ((newReb = (REB)parent.sendCommand(name, "getREBConfig", new Object[0])) == null) {
                    active.remove(name);
                    dlg.setVisible(false);
                    dlg.dispose();
                }
                reb.copyFrom(newReb);
                cfgPanel.read();
            }
        });
        JButton btClose = new JButton("Close");
        btClose.setFocusable(false);
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                active.remove(name);
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        JButton btOK = new JButton("OK");
        btOK.setFocusable(false);
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cfgPanel.save();
                Object reply = parent.sendCommand(name, "setREBConfig", reb);
                active.remove(name);
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        btnPanel.add((Component)btLoadDacs, gbc);
        btnPanel.add((Component)btLoadAspics, gbc);
        if (reb.getCabacVersion() != -1) {
            btnPanel.add((Component)btLoadCabacs, gbc);
        }
        gbc.insets.left = 20;
        btnPanel.add((Component)btUndo, gbc);
        gbc.insets.left = 4;
        btnPanel.add((Component)btApply, gbc);
        gbc.insets.left = 20;
        btnPanel.add((Component)btOK, gbc);
        gbc.insets.left = 4;
        btnPanel.add((Component)btClose, gbc);
        dlg.add((Component)cfgPanel, "Center");
        dlg.add((Component)btnPanel, "South");
        dlg.pack();
        dlg.setLocationRelativeTo(pWindow);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                active.remove(name);
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
    }

    private static String getResult(List<Integer> masks) {
        if (masks == null) {
            return "check not done";
        }
        int sum = 0;
        for (int mask : masks) {
            sum |= mask;
        }
        if (sum == 0) {
            return "no errors";
        }
        StringBuilder result = new StringBuilder("mismatches =");
        for (int mask : masks) {
            result.append(String.format(" %08x", mask));
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        REB r;
        final File file = new File("reb.ser");
        if (file.exists()) {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            r = (REB)is.readObject();
            is.close();
        } else {
            r = new REB();
        }
        final REBConfigPanel p = new REBConfigPanel(r, null, null);
        final JFrame f = new JFrame("REB");
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)p, "Center");
        JPanel btPanel = new JPanel();
        JButton btClose = new JButton("Close");
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        JButton btOK = new JButton("OK");
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                p.save();
                try {
                    ObjectOutputStream s = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    s.writeObject(r);
                    s.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                f.dispose();
            }
        });
        btPanel.add(btClose);
        btPanel.add(btOK);
        pane.add((Component)btPanel, "South");
        JScrollPane scroll = new JScrollPane(pane);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }

    static {
        dacNames.put(0, "SCLK Low");
        dacNames.put(1, "SCLK High");
        dacNames.put(2, "PCLK Low");
        dacNames.put(3, "PCLK High");
        dacNames.put(4, "RG Low");
        dacNames.put(5, "RG High");
        dacNames.put(6, "SCLK Low Sh");
        dacNames.put(7, "SCLK High Sh");
        dacNames.put(8, "PCLK Low Sh");
        dacNames.put(9, "PCLK High Sh");
        dacNames.put(10, "RG Low Sh");
        dacNames.put(11, "RG High Sh");
        dacNames.put(12, "CS Gate 0");
        dacNames.put(13, "CS Gate 1");
        dacNames.put(14, "CS Gate 2");
        dacList1 = new ArrayList<Integer>();
        dacList1.add(0);
        dacList1.add(1);
        dacList1.add(2);
        dacList1.add(3);
        dacList1.add(4);
        dacList1.add(5);
        dacList2 = new ArrayList<Integer>();
        dacList2.add(0);
        dacList2.add(6);
        dacList2.add(1);
        dacList2.add(7);
        dacList2.add(2);
        dacList2.add(8);
        dacList2.add(3);
        dacList2.add(9);
        dacList2.add(4);
        dacList2.add(10);
        dacList2.add(5);
        dacList2.add(11);
        dacList3 = new ArrayList<Integer>();
        dacList3.add(0);
        dacList3.add(6);
        dacList3.add(1);
        dacList3.add(2);
        dacList3.add(8);
        dacList3.add(3);
        dacList3.add(4);
        dacList3.add(10);
        dacList3.add(5);
    }

    class CABACPowerPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JCheckBox cb5V = new JCheckBox("5V");
        JCheckBox cb3V = new JCheckBox("3V");
        JCheckBox cbVEE = new JCheckBox("VEE");
        JCheckBox cbB5V = new JCheckBox("B5V");
        JCheckBox cbB3V = new JCheckBox("B3V");
        JButton btSet = new JButton("Set");
        int value;

        CABACPowerPanel() {
            this.cb5V.setFocusable(false);
            this.cb3V.setFocusable(false);
            this.cbVEE.setFocusable(false);
            this.cbB5V.setFocusable(false);
            this.cbB3V.setFocusable(false);
            this.btSet.setFocusable(false);
            this.btSet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CABACPowerPanel.this.read();
                    REBConfigPanel.this.parent.sendCommand(REBConfigPanel.this.name, "setCabacPower", CABACPowerPanel.this.value);
                    CABACPowerPanel.this.get();
                    CABACPowerPanel.this.display();
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = REBConfigPanel.this.insets_std;
            String title = "CABAC power enable";
            this.setBorder(BorderFactory.createTitledBorder(title));
            gbc.anchor = 18;
            gbc.gridy = 0;
            gbc.gridx = 0;
            this.add((Component)this.cb5V, gbc);
            ++gbc.gridx;
            this.add((Component)this.cb3V, gbc);
            ++gbc.gridx;
            this.add((Component)this.cbVEE, gbc);
            ++gbc.gridx;
            this.add((Component)this.cbB5V, gbc);
            ++gbc.gridx;
            this.add((Component)this.cbB3V, gbc);
            ++gbc.gridy;
            gbc.gridwidth = 2;
            gbc.gridx = 2;
            this.add((Component)this.btSet, gbc);
            this.get();
            this.display();
        }

        final void get() {
            Object reply = REBConfigPanel.this.parent.sendCommand(REBConfigPanel.this.name, "getCabacPower", new Object[0]);
            if (reply != null) {
                this.value = (Integer)reply;
            }
        }

        final void display() {
            this.cb5V.setSelected((this.value & 1) != 0);
            this.cb3V.setSelected((this.value & 2) != 0);
            this.cbVEE.setSelected((this.value & 4) != 0);
            this.cbB5V.setSelected((this.value & 8) != 0);
            this.cbB3V.setSelected((this.value & 8) != 0);
        }

        final void read() {
            this.value = 0;
            this.value |= this.cb5V.isSelected() ? 1 : 0;
            this.value |= this.cb3V.isSelected() ? 2 : 0;
            this.value |= this.cbVEE.isSelected() ? 4 : 0;
            this.value |= this.cbB5V.isSelected() ? 8 : 0;
            this.value |= this.cbB3V.isSelected() ? 16 : 0;
        }
    }

    public static interface Parent {
        public Object sendCommand(String var1, String var2, Object ... var3);

        public void display(String var1);
    }
}

