/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.openide.util.Lookup;

public class InstanceDialog
extends JDialog {
    private Object out;
    private Item item;
    private Object[] parameters;
    private Box rightPanel;
    private List<ParPanel> parPanels;
    private JButton okButton;
    private Descriptor descriptor;

    private InstanceDialog(Component parentComponent, String title, Collection<Item> items) {
        super(SwingUtilities.getWindowAncestor(parentComponent), title, Dialog.ModalityType.APPLICATION_MODAL);
        ItemNode root = new ItemNode("Root");
        for (Item item : items) {
            ItemNode parent = root;
            String[] ss = item.getPath().split("/+");
            for (int i = 0; i < ss.length - 1; ++i) {
                parent = parent.getChild(ss[i]);
            }
            parent.getChild((String)ss[ss.length - 1]).item = item;
        }
        JTree tree = new JTree(root);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(e -> {
            ItemNode node = (ItemNode)tree.getLastSelectedPathComponent();
            this.showItem(node == null ? null : node.item);
        });
        Enumeration<TreeNode> en = root.children();
        while (en.hasMoreElements()) {
            tree.expandPath(new TreePath(((ItemNode)en.nextElement()).getPath()));
        }
        JScrollPane treeScrollPane = new JScrollPane(tree);
        this.rightPanel = Box.createVerticalBox();
        JScrollPane rightScrollPane = new JScrollPane(this.rightPanel);
        JSplitPane splitPane = new JSplitPane(1, treeScrollPane, rightScrollPane);
        splitPane.setDividerLocation(300);
        Dimension minimumSize = new Dimension(100, 50);
        treeScrollPane.setMinimumSize(minimumSize);
        rightScrollPane.setMinimumSize(minimumSize);
        splitPane.setPreferredSize(new Dimension(850, 500));
        this.add((Component)splitPane, "Center");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createHorizontalGlue());
        JButton b = new JButton("Cancel");
        b.addActionListener(e -> {
            this.out = null;
            this.item = null;
            this.dispose();
        });
        buttonBox.add(b);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> {
            if (this.item != null) {
                int n = this.parPanels.size();
                Object[] pars = new Object[n];
                String[] parStrings = new String[n];
                boolean parsValid = true;
                for (int i = 0; i < n; ++i) {
                    pars[i] = this.parPanels.get(i).getValue();
                    if (pars[i] == null) {
                        parsValid = false;
                        continue;
                    }
                    parStrings[i] = pars[i].toString();
                }
                if (parsValid) {
                    this.out = this.item.getInstance(pars);
                    if (this.out != null) {
                        this.descriptor = new Descriptor();
                        this.descriptor.setPath(this.item.getPath());
                        this.descriptor.setParameters(parStrings);
                        this.dispose();
                    }
                }
            }
        });
        buttonBox.add(this.okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.add((Component)buttonBox, "South");
        this.showItem(null);
    }

    public static InstanceDialog show(Class<?> targetClass, Component parentComponent, String title, Collection<Item> items) {
        InstanceDialog dialog = new InstanceDialog(parentComponent, title, items);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog;
    }

    public static InstanceDialog show(Class<?> targetClass, Component parentComponent, String title, String lookupId) {
        return InstanceDialog.show(targetClass, parentComponent, title, InstanceDialog.findItems(targetClass, lookupId));
    }

    public static <T> T getInstance(Descriptor descriptor, Class<T> targetClass, Collection<Item> items) {
        for (Item item : items) {
            if (!item.getPath().equals(descriptor.getPath())) continue;
            return (T)item.getInstance(descriptor);
        }
        return null;
    }

    public static <T> T getInstance(Descriptor descriptor, Class<T> targetClass, String lookupId) {
        return InstanceDialog.getInstance(descriptor, targetClass, InstanceDialog.findItems(targetClass, lookupId));
    }

    public Object getInstance() {
        return this.out;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void showItem(Item item) {
        this.item = item;
        this.rightPanel.removeAll();
        this.parPanels = Collections.emptyList();
        if (item != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>").append(item.getPath()).append("<br>");
            sb.append("<h3>").append(item.getName()).append("</h3>");
            String descr = item.getDescription();
            if (descr != null && !descr.isEmpty()) {
                sb.append(descr).append("");
            }
            sb.append("</html>");
            DescriptionPane ep = new DescriptionPane(sb.toString());
            ep.setEditable(false);
            this.rightPanel.add(ep);
            if (item.exec != null) {
                Parameter[] pars = item.exec.getParameters();
                this.parPanels = new ArrayList<ParPanel>(pars.length);
                if (pars.length > 0) {
                    Box parBox = Box.createVerticalBox();
                    parBox.setBorder(BorderFactory.createTitledBorder("Parameters"));
                    parBox.add(Box.createRigidArea(Const.VDIM));
                    for (Parameter p : pars) {
                        ParPanel panel = new ParPanel(p);
                        parBox.add(panel);
                        this.parPanels.add(panel);
                        parBox.add(Box.createRigidArea(Const.VDIM));
                    }
                    this.rightPanel.add(Box.createRigidArea(Const.VDIM));
                    this.rightPanel.add(parBox);
                    this.rightPanel.add(Box.createRigidArea(Const.VDIM));
                }
            }
            this.rightPanel.add(Box.createVerticalGlue());
            this.rightPanel.revalidate();
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private static Set<Item> findItems(Class<?> targetClass, String lookupId) {
        if (lookupId == null) {
            lookupId = targetClass.getName();
        }
        TreeSet<Item> items = new TreeSet<Item>();
        Collection instances = Console.getConsole().getConsoleLookup().lookup(new Lookup.Template(String.class, lookupId, null)).allInstances();
        for (Object instance : instances) {
            try {
                items.add(new Item(targetClass, instance));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return items;
    }

    public static class Descriptor
    implements Serializable {
        private String path;
        private String[] parameters;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public void setParameters(String[] parameters) {
            this.parameters = parameters;
        }

        public String getParameters(int index) {
            return this.parameters[index];
        }

        public void setParameters(int index, String parameters) {
            this.parameters[index] = parameters;
        }
    }

    private class DescriptionPane
    extends JEditorPane {
        DescriptionPane(String s) {
            super("text/html", s);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = new Dimension(super.getPreferredSize());
            d.width = InstanceDialog.this.rightPanel.getWidth() - 20;
            return d;
        }
    }

    private static class ParPanel
    extends JPanel {
        Parameter par;
        JComponent selector;

        ParPanel(Parameter parameter) {
            this.par = parameter;
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.add(new JLabel(this.par.getType().getSimpleName() + " " + this.par.getName()));
            this.add(Box.createRigidArea(Const.HDIM));
            Class<?> pc = this.par.getType();
            if (pc.equals(Integer.TYPE) || pc.equals(Long.TYPE) || pc.equals(Double.TYPE) || pc.equals(Float.TYPE) || pc.equals(String.class)) {
                JTextField field = new JTextField();
                field.setColumns(30);
                field.setMaximumSize(field.getPreferredSize());
                this.selector = field;
            } else if (pc.equals(Boolean.TYPE)) {
                this.selector = new JCheckBox();
            } else if (Enum.class.isAssignableFrom(pc)) {
                try {
                    this.selector = new JComboBox<Object>((Object[])pc.getMethod("values", new Class[0]).invoke(null, new Object[0]));
                }
                catch (Throwable t) {
                    this.selector = new JLabel("Unable to set parameter");
                    this.selector.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
                }
            }
            this.add(this.selector);
            this.add(Box.createHorizontalGlue());
        }

        Object getValue() {
            Object out = null;
            Class<?> pc = this.par.getType();
            try {
                if (pc.equals(Integer.TYPE)) {
                    JTextField field = (JTextField)this.selector;
                    out = Integer.valueOf(field.getText());
                } else if (pc.equals(Long.TYPE)) {
                    JTextField field = (JTextField)this.selector;
                    out = Long.valueOf(field.getText());
                } else if (pc.equals(Double.TYPE)) {
                    JTextField field = (JTextField)this.selector;
                    out = Double.valueOf(field.getText());
                } else if (pc.equals(Float.TYPE)) {
                    JTextField field = (JTextField)this.selector;
                    out = Float.valueOf(field.getText());
                } else if (pc.equals(String.class)) {
                    JTextField field = (JTextField)this.selector;
                    out = field.getText();
                } else if (pc.equals(Boolean.TYPE)) {
                    JCheckBox cb = (JCheckBox)this.selector;
                    out = cb.isSelected();
                } else if (Enum.class.isAssignableFrom(pc)) {
                    JComboBox cb = (JComboBox)this.selector;
                    out = cb.getSelectedItem();
                }
                this.selector.setBorder(null);
            }
            catch (Throwable t) {
                this.selector.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
            }
            return out;
        }
    }

    private static class ItemNode
    extends DefaultMutableTreeNode {
        Item item;

        ItemNode(String name) {
            super(name);
        }

        ItemNode getChild(String name) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode child = this.getChildAt(i);
                if (!child.toString().equals(name)) continue;
                return (ItemNode)child;
            }
            ItemNode child = new ItemNode(name);
            this.add(child);
            return child;
        }
    }

    public static class Item
    implements Comparable<Item> {
        private final Object factory;
        private Executable exec;
        private String path;
        private String name;
        private String description;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Item(Class<?> targetClass, Object factory) {
            this.factory = factory;
            try {
                Class<?> factoryClass;
                if (factory instanceof String) {
                    factory = Class.forName((String)factory);
                }
                if (factory instanceof Class) {
                    Method[] c = (Method[])factory;
                    if (!targetClass.isAssignableFrom((Class<?>)c) || !Modifier.isPublic(c.getModifiers())) throw new IllegalArgumentException();
                    for (Method method : c.getMethods()) {
                        if (!method.getName().equals("getInstance") || !targetClass.isAssignableFrom(method.getReturnType()) || !Item.check(method)) continue;
                        this.exec = method;
                        break;
                    }
                    if (this.exec == null) {
                        for (Executable executable : c.getConstructors()) {
                            if (!Item.check(executable)) continue;
                            this.exec = executable;
                            break;
                        }
                    }
                    if (this.exec == null) {
                        throw new IllegalArgumentException();
                    }
                    ConsoleLookup ann = c.getAnnotation(ConsoleLookup.class);
                    if (ann != null) {
                        this.path = ann.path();
                        this.name = ann.name();
                        this.description = ann.description();
                    }
                } else if (!targetClass.isInstance(factory)) {
                    for (Method m : factory.getClass().getMethods()) {
                        if (!m.getName().equals("getInstance") || !targetClass.isAssignableFrom(m.getReturnType()) || !Item.check(m)) continue;
                        this.exec = m;
                        break;
                    }
                    if (this.exec == null) {
                        throw new IllegalArgumentException();
                    }
                }
                Class<?> clazz = factoryClass = factory instanceof Class ? (Class<?>)factory : factory.getClass();
                if (this.name == null) {
                    try {
                        Method m = factoryClass.getMethod("getName", new Class[0]);
                        this.name = (String)m.invoke(factory, new Object[0]);
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                }
                if (this.path == null) {
                    try {
                        Method m = factoryClass.getMethod("getPath", new Class[0]);
                        this.path = (String)m.invoke(factory, new Object[0]);
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                }
                if (this.path == null || this.path.isEmpty()) {
                    if (this.name == null || this.name.isEmpty()) {
                        this.name = factory instanceof Class ? factoryClass.getName() : factory.toString();
                    }
                    this.path = this.name;
                    return;
                } else {
                    if (this.name != null && !this.name.isEmpty()) return;
                    int i = this.path.lastIndexOf("/");
                    this.name = this.path.substring(i + 1);
                }
                return;
            }
            catch (Throwable x) {
                throw new IllegalArgumentException();
            }
        }

        Object getInstance(Object[] parameters) {
            Object out = null;
            try {
                if (this.exec == null) {
                    out = this.factory;
                } else if (this.exec instanceof Method) {
                    out = ((Method)this.exec).invoke(this.factory, parameters);
                } else if (this.exec instanceof Constructor) {
                    out = ((Constructor)this.exec).newInstance(parameters);
                }
            }
            catch (Exception t) {
                Console.getConsole().error("Unable to construct", t);
            }
            return out;
        }

        Object getInstance(Descriptor desc) {
            Object out = null;
            try {
                if (this.exec == null) {
                    out = this.factory;
                } else {
                    Parameter[] pp = this.exec.getParameters();
                    String[] ss = desc.getParameters();
                    Object[] pars = new Object[pp.length];
                    block2: for (int i = 0; i < pp.length; ++i) {
                        Class<?> pc = pp[i].getType();
                        if (pc.equals(Integer.TYPE)) {
                            pars[i] = Integer.valueOf(ss[i]);
                            continue;
                        }
                        if (pc.equals(Long.TYPE)) {
                            pars[i] = Long.valueOf(ss[i]);
                            continue;
                        }
                        if (pc.equals(Double.TYPE)) {
                            pars[i] = Double.valueOf(ss[i]);
                            continue;
                        }
                        if (pc.equals(Float.TYPE)) {
                            pars[i] = Float.valueOf(ss[i]);
                            continue;
                        }
                        if (pc.equals(Boolean.TYPE)) {
                            pars[i] = Boolean.valueOf(ss[i]);
                            continue;
                        }
                        if (pc.equals(String.class)) {
                            pars[i] = ss[i];
                            continue;
                        }
                        if (!pc.isEnum()) continue;
                        for (Object e : pc.getEnumConstants()) {
                            if (!e.toString().equals(ss[i])) continue;
                            pars[i] = e;
                            continue block2;
                        }
                    }
                    if (this.exec instanceof Method) {
                        out = ((Method)this.exec).invoke(this.factory, pars);
                    } else if (this.exec instanceof Constructor) {
                        out = ((Constructor)this.exec).newInstance(pars);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            if (this.description == null) {
                Class<?> factoryClass = this.factory instanceof Class ? (Class<?>)this.factory : this.factory.getClass();
                try {
                    Method m = factoryClass.getMethod("getDescription", new Class[0]);
                    this.description = (String)m.invoke(this.factory, new Object[0]);
                }
                catch (Exception x) {
                    this.description = "";
                }
            }
            return this.description;
        }

        public Object getFactory() {
            return this.factory;
        }

        public boolean equals(Object other) {
            return other instanceof Item && ((Item)other).path.equals(this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public int compareTo(Item other) {
            return this.path.compareTo(other.path);
        }

        private static boolean check(Executable executable) {
            if (Modifier.isPublic(executable.getModifiers())) {
                for (Class<?> pc : executable.getParameterTypes()) {
                    if (pc.equals(Integer.TYPE) || pc.equals(Long.TYPE) || pc.equals(Double.TYPE) || pc.equals(Float.TYPE) || pc.equals(Boolean.TYPE) || pc.equals(String.class) || Enum.class.isAssignableFrom(pc)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

