/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.CapturedData;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyCaller;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;

public class MotorReplyReceiver
implements CommandOriginator,
StatusMessageListener,
TargetStatusListener {
    private static final Logger LOG = Logger.getLogger(MotorReplyReceiver.class.getName());
    private static final String INVALID_SUBSYSTEM_NAME = "-(- bad name +)+";
    private final AtomicReference<String> currentTarget = new AtomicReference<String>("-(- bad name +)+");
    private final AgentMessagingLayer messaging;
    private final MotorReplyListener replyListener;
    private static final List<Class<?>> replyList = Arrays.asList(AxisStatus.class, CapturedData.class, ControllerStatus.class, IOStatus.class, PlatformConfig.class);

    public MotorReplyReceiver(AgentMessagingLayer messaging, MotorReplyListener replyListener) {
        this.messaging = messaging;
        this.replyListener = replyListener;
    }

    public void processAck(CommandAck ack) {
        LOG.fine("Command ACK.");
    }

    public void processResult(CommandResult result) {
        Object embedded = result.getResult();
        LOG.log(Level.FINE, "Command returned result {0}.", embedded == null ? null : embedded.getClass().getSimpleName());
    }

    public void processNack(CommandNack nack) {
        LOG.fine("Command NACK.");
    }

    public void onStatusMessage(StatusMessage s) {
        StatusSubsystemData ssd = (StatusSubsystemData)s;
        KeyValueData kvd = ssd.getSubsystemData();
        MotorReplyCaller caller = (MotorReplyCaller)((Object)kvd.getValue());
        caller.callMotorReplyHandler(this.replyListener);
    }

    private void startStatusListening() {
        this.messaging.removeStatusMessageListener((StatusMessageListener)this);
        this.messaging.addStatusMessageListener((StatusMessageListener)this, this.makeFilter());
    }

    private Predicate<BusMessage<? extends Serializable, ?>> makeFilter() {
        Predicate target = BusMessageFilterFactory.messageOrigin((String)this.currentTarget.get());
        Predicate standard = BusMessageFilterFactory.messageClass(StatusSubsystemData.class);
        return target.and(standard);
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        if (evt.disableCommands()) {
            this.currentTarget.set(INVALID_SUBSYSTEM_NAME);
        } else {
            this.currentTarget.set(evt.getTargetSubsystem());
        }
        this.startStatusListening();
    }
}

