/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DigitalOutputPanel
extends JPanel
implements TargetStatusListener {
    private final List<JToggleButton> toggles;
    private final List<JLabel> toggleLabels;
    private MotorCommandListener sender;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;
    private JToggleButton jToggleButton5;
    private JToggleButton jToggleButton6;
    private JToggleButton jToggleButton7;
    private JToggleButton jToggleButton8;

    public DigitalOutputPanel() {
        this.initComponents();
        this.sender = null;
        this.toggles = Collections.unmodifiableList(Arrays.asList(this.jToggleButton1, this.jToggleButton2, this.jToggleButton3, this.jToggleButton4, this.jToggleButton5, this.jToggleButton6, this.jToggleButton7, this.jToggleButton8));
        this.toggleLabels = Collections.unmodifiableList(Arrays.asList(this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8, this.jLabel9));
        int i = 0;
        while (i < this.toggles.size()) {
            JToggleButton tog = this.toggles.get(i);
            int j = i++;
            tog.addActionListener(evt -> this.changeIOState(tog, j));
        }
    }

    public void init(MotorCommandListener sender) {
        this.sender = sender;
    }

    public void configure(PlatformConfig config) {
        List<String> names = config.getDigitalOutputNames();
        for (int i = 0; i < this.toggles.size(); ++i) {
            if (i < names.size()) {
                this.toggles.get(i).setEnabled(true);
                this.toggleLabels.get(i).setText(names.get(i));
                continue;
            }
            this.toggles.get(i).setEnabled(false);
            this.toggleLabels.get(i).setText("");
        }
    }

    public void update(IOStatus status) {
        int bits = status.getDigitalOutputs();
        int i = 0;
        while (i < this.toggles.size()) {
            this.toggles.get(i).setSelected((bits & 1) == 1);
            ++i;
            bits >>= 1;
        }
    }

    private void changeIOState(JToggleButton tog, int lineIndex) {
        this.sender.changeOutputLine(new ChangeOutputLine(lineIndex, tog.isSelected()));
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        this.toggles.forEach(but -> but.setEnabled(!evt.disableCommands()));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.jToggleButton5 = new JToggleButton();
        this.jToggleButton6 = new JToggleButton();
        this.jToggleButton7 = new JToggleButton();
        this.jToggleButton8 = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel1.text"));
        this.jToggleButton1.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton1, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton1.text"));
        this.jToggleButton2.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton2, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton2.text"));
        this.jToggleButton3.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton3, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton3.text"));
        this.jToggleButton4.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton4, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton4.text"));
        this.jToggleButton5.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton5, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton5.text"));
        this.jToggleButton6.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton6, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton6.text"));
        this.jToggleButton7.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton7, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton7.text"));
        this.jToggleButton8.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton8, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jToggleButton8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(DigitalOutputPanel.class, (String)"DigitalOutputPanel.jLabel9.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton8).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

