/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.teststand.ui.TSConfigurableSubsystemMainPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class TSConfigurableSubsystemGUI
implements AgentPresenceListener,
StatusMessageListener {
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.subsystem.teststand.gui");
    private static String DEST = "ts";
    private final TSConfigurableSubsystemMainPanel mainPanel;
    private final AgentMessagingLayer aml;
    private final ConcurrentMessagingUtils cmu;
    private Predicate<BusMessage<? extends Serializable, ?>> filterConfig;

    public TSConfigurableSubsystemGUI(AgentMessagingLayer aml) {
        this.aml = aml;
        this.cmu = new ConcurrentMessagingUtils(aml);
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.mainPanel = new TSConfigurableSubsystemMainPanel(aml, DEST);
    }

    public void onStatusMessage(StatusMessage msg) {
        if (msg == null) {
            return;
        }
        ConfigurationInfo configInfo = null;
        if (!(msg.getObject() instanceof ConfigurationInfo)) {
            return;
        }
        configInfo = (ConfigurationInfo)msg.getObject();
        List listChanges = configInfo.getLatestChanges();
        this.mainPanel.updateWithConfigInfo(configInfo);
    }

    public Component getGuiLayout() {
        return new JScrollPane(this.mainPanel);
    }

    public void initGui() {
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.filterConfig = BusMessageFilterFactory.messageOrigin((String)DEST).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));
    }

    public void connecting(AgentInfo agent) {
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        if (!agent.getName().equals(DEST)) {
            return;
        }
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo)future.get();
            this.mainPanel.updateWithConfigInfo(configInfo);
            this.mainPanel.setDescriptionName(configInfo.getDescriptionName());
            this.aml.addStatusMessageListener((StatusMessageListener)this, this.filterConfig);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"unable to retrieve configuration information", (Throwable)ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
    }
}

