/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N6487;

public class KeithleyDeviceGUI {
    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<Integer, String>();
    private static final String NB_SPACE = "\u00a0";
    private static final JLabel lbCfg = new JLabel("Configuration");
    private static final JLabel lbCfgType = new JLabel("Connection Type");
    private static final JLabel lbCfgPort = new JLabel("Port or Serial#");
    private static final JLabel lbCfgRate = new JLabel("Baud Rate");
    private static final JButton btCfgCnx = new JButton("Open Connection");
    private static final JLabel lbCur = new JLabel("Current Measurement");
    private static final JButton btCurRead = new JButton("Read");
    private static final JButton btCurCali = new JButton("Calibrate");
    private static final JButton btCurRange = new JButton("Set Range");
    private static final JButton btCurRst = new JButton("Reset");
    private static final JLabel lbVolt = new JLabel("Voltage Control");
    private static final JLabel lbCfgVoltage = new JLabel("Set Voltage");
    private static final JLabel lbCfgVoltageRange = new JLabel("Set Voltage Range");
    private static final JLabel lbCfgVoltageState = new JLabel("Voltage State");
    private static final JButton btVoltRead = new JButton("Read");
    private static final JButton btVoltSet = new JButton("Set");
    private static final JButton btVoltOut = new JButton("ON/OFF");
    private static final JButton btVoltRange = new JButton("Set Range");
    private static final JButton btVoltRst = new JButton("Reset");
    private JLabel[] lbPwrState;
    private JLabel[] lbPwrVoltage;
    private JLabel[] lbPwrCurrent;
    private final JLabel lbMessage = new JLabel("\u00a0");
    private final JPanel panel = new JPanel();
    private final JPanel cfgPanel = new JPanel();
    private final JPanel curPanel = new JPanel();
    private final JPanel voltPanel = new JPanel();
    private N6487 n64;
    private String connType;
    private String connPort;
    private Integer connRate;
    private final NumberFormatter fmt3 = new NumberFormatter(new DecimalFormat("##0"));
    private final JFormattedTextField tfS = new JFormattedTextField();
    private final JFormattedTextField tfP = new JFormattedTextField();
    private final JFormattedTextField tfR = new JFormattedTextField(this.fmt3);
    private Double setVolt;
    private Double setVoltRange;
    private final JFormattedTextField tfV = new JFormattedTextField();
    private final JFormattedTextField tfVR = new JFormattedTextField();
    private final JFormattedTextField tfVO = new JFormattedTextField();

    public void main(String[] args) throws ClassNotFoundException {
        System.out.println("starting KeithleyGUI main");
        this.initGui();
        System.out.println("past initGui");
        this.n64 = new N6487();
        System.out.println("past N6487 initialization");
        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add((Component)this.getPanel(), "Center");
        JFrame f = new JFrame("Keithley Control");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void initGui() {
        this.initComponents();
    }

    private void display(String message) {
        this.lbMessage.setText(message);
    }

    private void SetConnType() {
        this.connType = (String)this.tfS.getValue();
        this.display("Connection type set to " + this.connType);
    }

    private void SetConnPort() {
        this.connType = (String)this.tfP.getValue();
        this.display("Connection port set to " + this.connType);
    }

    private void SetConnRate() {
        this.connRate = (Integer)this.tfR.getValue();
        this.display("Connection rate set to " + this.connType);
    }

    private void SetVoltage() {
        this.setVolt = (Double)this.tfV.getValue();
        this.display("Voltage set to " + this.setVolt);
        if (this.setVolt < -75.0) {
            this.setVolt = -75.0;
        }
        if (this.setVolt > 75.0) {
            this.setVolt = 75.0;
        }
        this.display("Voltage set to " + this.setVolt);
        try {
            this.n64.setVoltage(this.setVolt.doubleValue());
            if (this.n64.getOutput()) {
                this.tfVO.setValue("ON:V=" + this.tfV.getValue());
            } else {
                this.tfVO.setValue("OFF:V=" + this.tfV.getValue());
            }
        }
        catch (DriverException f) {
            this.display("exception incurred on voltage status read");
        }
    }

    private void SetVoltageRange() {
        this.setVoltRange = (Double)this.tfVR.getValue();
        this.display("Connection voltage set to " + this.setVoltRange);
    }

    private void ShowVoltageState() {
        try {
            this.setVolt = (Double)this.tfV.getValue();
            if (this.n64.getOutput()) {
                this.tfVO.setValue("ON:V=" + this.tfV.getValue());
            } else {
                this.tfVO.setValue("OFF:V=" + this.tfV.getValue());
            }
        }
        catch (DriverException f) {
            this.display("exception incurred on voltage status read");
        }
        this.display("Voltage set to " + this.setVolt);
    }

    private void initComponents() {
        this.cfgPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.cfgPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcC = new GridBagConstraints();
        gbcC.insets = new Insets(4, 4, 4, 4);
        gbcC.anchor = 11;
        gbcC.gridx = 0;
        gbcC.gridy = 0;
        this.cfgPanel.add((Component)lbCfg, gbcC);
        ++gbcC.gridy;
        this.cfgPanel.add((Component)lbCfgType, gbcC);
        ++gbcC.gridy;
        Dimension d = this.tfS.getPreferredSize();
        d.width = 60;
        this.tfS.setPreferredSize(d);
        this.tfS.setValue("FTDI");
        this.cfgPanel.add((Component)this.tfS, gbcC);
        this.tfS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeithleyDeviceGUI.this.SetConnType();
            }
        });
        ++gbcC.gridy;
        this.cfgPanel.add((Component)lbCfgPort, gbcC);
        ++gbcC.gridy;
        d = this.tfP.getPreferredSize();
        d.width = 60;
        this.tfP.setPreferredSize(d);
        this.tfP.setValue("A603EPZY");
        this.cfgPanel.add((Component)this.tfP, gbcC);
        this.tfP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeithleyDeviceGUI.this.SetConnPort();
            }
        });
        ++gbcC.gridy;
        this.cfgPanel.add((Component)lbCfgRate, gbcC);
        ++gbcC.gridy;
        d = this.tfR.getPreferredSize();
        d.width = 60;
        this.tfR.setPreferredSize(d);
        this.tfR.setValue(19200);
        this.cfgPanel.add((Component)this.tfR, gbcC);
        this.tfR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeithleyDeviceGUI.this.SetConnPort();
            }
        });
        ++gbcC.gridy;
        this.cfgPanel.add((Component)btCfgCnx, gbcC);
        btCfgCnx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    KeithleyDeviceGUI.this.n64.openftdi((String)KeithleyDeviceGUI.this.tfP.getValue(), ((Integer)KeithleyDeviceGUI.this.tfR.getValue()).intValue());
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("exception incurred on open attempt");
                }
            }
        });
        this.curPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.curPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcS = new GridBagConstraints();
        gbcS.insets = new Insets(4, 4, 4, 4);
        gbcS.anchor = 11;
        gbcS.gridx = 0;
        gbcS.gridy = 0;
        this.curPanel.add((Component)lbCur, gbcS);
        ++gbcS.gridy;
        this.curPanel.add((Component)btCurRead, gbcS);
        btCurRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double current = 0.0;
                try {
                    current = KeithleyDeviceGUI.this.n64.readCurrent();
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
                KeithleyDeviceGUI.this.display("Current = " + current);
            }
        });
        ++gbcS.gridy;
        this.curPanel.add((Component)btCurCali, gbcS);
        btCurCali.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    KeithleyDeviceGUI.this.n64.zeroCorrectCurrent();
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
            }
        });
        ++gbcS.gridy;
        this.curPanel.add((Component)btCurRange, gbcS);
        btCurRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double currange = 2.0E-4;
                try {
                    KeithleyDeviceGUI.this.n64.setCurrentRange(currange);
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
            }
        });
        ++gbcS.gridy;
        this.curPanel.add((Component)btCurRst, gbcS);
        btCurRst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    KeithleyDeviceGUI.this.n64.reset();
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
            }
        });
        this.voltPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.voltPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcV = new GridBagConstraints();
        gbcV.insets = new Insets(4, 4, 4, 4);
        gbcV.anchor = 11;
        gbcV.gridx = 0;
        gbcV.gridy = 0;
        this.voltPanel.add((Component)lbVolt, gbcV);
        ++gbcV.gridy;
        this.voltPanel.add((Component)btVoltRead, gbcV);
        btVoltRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double voltage = 0.0;
                try {
                    voltage = KeithleyDeviceGUI.this.n64.readVoltage();
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
                KeithleyDeviceGUI.this.display("Voltage = " + voltage);
            }
        });
        ++gbcV.gridy;
        this.voltPanel.add((Component)lbCfgVoltage, gbcV);
        ++gbcV.gridy;
        d = this.tfV.getPreferredSize();
        d.width = 60;
        this.tfV.setPreferredSize(d);
        this.tfV.setValue(0.0);
        this.voltPanel.add((Component)this.tfV, gbcV);
        this.tfV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeithleyDeviceGUI.this.SetVoltage();
            }
        });
        ++gbcV.gridy;
        this.voltPanel.add((Component)btVoltOut, gbcV);
        btVoltOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    try {
                        onOff state = onOff.ON;
                        if (KeithleyDeviceGUI.this.n64.getOutput()) {
                            KeithleyDeviceGUI.this.n64.setOutput(state == onOff.OFF);
                            KeithleyDeviceGUI.this.ShowVoltageState();
                            KeithleyDeviceGUI.this.display("Voltage OFF");
                            break block5;
                        }
                        KeithleyDeviceGUI.this.n64.setOutput(state == onOff.ON);
                        double voltage = 0.0;
                        try {
                            voltage = KeithleyDeviceGUI.this.n64.readVoltage();
                        }
                        catch (DriverException f) {
                            KeithleyDeviceGUI.this.display("DriverException!");
                        }
                        KeithleyDeviceGUI.this.ShowVoltageState();
                        KeithleyDeviceGUI.this.display("Voltage output ON and V = " + voltage + " V");
                    }
                    catch (DriverException f) {
                        KeithleyDeviceGUI.this.display("DriverException!");
                    }
                }
            }
        });
        ++gbcV.gridy;
        this.voltPanel.add((Component)lbCfgVoltageState, gbcV);
        ++gbcV.gridy;
        d = this.tfVO.getPreferredSize();
        d.width = 60;
        this.tfVO.setPreferredSize(d);
        this.tfVO.setValue("UNKNOWN");
        this.voltPanel.add((Component)this.tfVO, gbcV);
        ++gbcV.gridy;
        this.voltPanel.add((Component)lbCfgVoltageRange, gbcV);
        ++gbcV.gridy;
        d = this.tfVR.getPreferredSize();
        d.width = 60;
        this.tfVR.setPreferredSize(d);
        this.tfVR.setValue(2.0E-4);
        this.voltPanel.add((Component)this.tfVR, gbcV);
        this.tfVR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeithleyDeviceGUI.this.SetVoltageRange();
            }
        });
        ++gbcV.gridy;
        this.voltPanel.add((Component)btVoltRst, gbcV);
        btCurRst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    KeithleyDeviceGUI.this.n64.reset();
                }
                catch (DriverException f) {
                    KeithleyDeviceGUI.this.display("DriverException!");
                }
            }
        });
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.add((Component)this.cfgPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.curPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.voltPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.anchor = 11;
        this.panel.add((Component)this.lbMessage, gbc);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JComponent getGuiLayout() {
        return this.panel;
    }

    public void resetGui() {
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

