/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.jas.services.PlotterProvider;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.plugins.trending.AutoRefreshManager;
import org.lsst.ccs.gconsole.plugins.trending.RestServerSource;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPanel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSourcesManager;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowSelector;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

@Plugin(name="LSST Trending Plugin", id="trending", description="Allows plotting time histories for channels from the trending database and other sources.")
public class LsstTrendingPlugin
extends ConsolePlugin
implements PlotterProvider {
    final String PANEL_GROUP = "TrendingPlots";
    private TrendingPreferences prefs;
    private volatile TrendingSourcesManager treeMan;
    private volatile AutoRefreshManager refreshMan;
    private volatile PlotFactory plotFactory;
    private RestServerSource restSource;
    private final Object restSourceLock = new Object();
    private volatile TimeWindowSelector timeWindowBox;
    private JToolBar toolbar;
    private JCheckBoxMenuItem autoRefreshMenu;
    private final Action trendingAction;
    private final ArrayList<TrendingPanel> pages = new ArrayList(0);
    private ThreadPoolExecutor dataFetcher;
    private final int DATA_FETCHER_MAX_THREADS = 3;
    private final int DATA_FETCHER_KEEP_ALIVE = 120;

    public LsstTrendingPlugin() {
        this.trendingAction = new AbstractAction("Trending"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    LsstTrendingPlugin.this.startTrending();
                } else {
                    LsstTrendingPlugin.this.stopTrending();
                }
            }
        };
        this.trendingAction.putValue("SwingSelectedKey", false);
    }

    @Override
    public synchronized void initialize() {
        this.prefs = new TrendingPreferences(this);
        this.getConsole().getConsoleLookup().add((Object)this.prefs);
        this.getServices().addMenu(this.trendingAction, "400: CCS Tools :-1:3");
    }

    @Override
    public synchronized void start() {
        this.plotFactory = (PlotFactory)this.getConsole().getConsoleLookup().lookup(PlotFactory.class);
        if (this.plotFactory == null) {
            throw new RuntimeException("No plot factory available");
        }
        if (this.prefs.isAutoStart()) {
            SwingUtilities.invokeLater(this::startTrending);
        }
    }

    @Override
    public void stop() {
        if (this.prefs.isAutoSave()) {
            SwingUtilities.invokeLater(() -> ((Jas3Console)this.getConsole()).save());
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.treeMan != null) {
            SwingUtilities.invokeLater(this::stopTrending);
        }
    }

    private synchronized void startTrending() {
        this.trendingAction.putValue("SwingSelectedKey", true);
        ThreadFactory tFactory = new ThreadFactory(){
            final ThreadFactory delegate = Executors.defaultThreadFactory();
            int id = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setName("Trending Data Fetcher " + this.id++);
                return thread;
            }
        };
        this.dataFetcher = new ThreadPoolExecutor(3, 3, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tFactory);
        this.dataFetcher.allowCoreThreadTimeOut(true);
        this.showToolbar();
        if (this.treeMan == null) {
            this.treeMan = new TrendingSourcesManager(this);
        }
        this.treeMan.start();
        FreeHEPLookup lookup = this.getConsole().getConsoleLookup();
        Lookup.Template template = new Lookup.Template(WebResource.class, "dataserver", null);
        Lookup.Result result = lookup.lookup(template);
        this.handleRestServers(result.allInstances());
        LookupListener ll = e -> this.handleRestServers(result.allInstances());
        result.addLookupListener(ll);
        TrendingService trendingService = path -> {
            FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
            if (treeProvider != null) {
                FTree tree = treeProvider.tree("Trending");
                FTreeNode node = tree.findNode(new FTreePath(path));
                if (node == null) {
                    this.getConsole().setStatusMessage("No such trending channel");
                } else {
                    tree.adapterForClass(TrendingChannel.class).doubleClick(node);
                }
            }
        };
        lookup.add((Object)trendingService);
    }

    private synchronized void stopTrending() {
        this.trendingAction.putValue("SwingSelectedKey", false);
        this.stopAutoRefresh();
        new ArrayList<TrendingPanel>(this.pages).forEach(page -> page.hidePage());
        this.treeMan.stop();
        this.hideToolbar();
        this.dataFetcher.shutdownNow();
        this.dataFetcher = null;
    }

    TrendingPreferences getPreferences() {
        return this.prefs;
    }

    PlotFactory getPlotFactory() {
        return this.plotFactory;
    }

    TrendingSourcesManager getSourcesManager() {
        return this.treeMan;
    }

    TimeWindowSelector getTimeWindowSelector() {
        return this.timeWindowBox;
    }

    TimeWindow getSelectedTimeWindow() {
        return this.timeWindowBox.getSelectedTimeWindow();
    }

    List<TrendingPanel> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    void plot(TrendingChannel channel, TimeWindow timeWindow, PlotRegion region, TrendPlotter.Option ... options) {
        TrendPlotter plotter;
        if (channel == null || region == null) {
            return;
        }
        try {
            plotter = (TrendPlotter)region.currentPlot();
        }
        catch (ClassCastException x) {
            return;
        }
        if (plotter == null) {
            plotter = this.create();
            LsstTrendingPlugin.showPlotter(plotter, region);
        }
        if (!plotter.isActive()) {
            return;
        }
        if (timeWindow == null && (timeWindow = this.getSelectedTimeWindow()) == null) {
            return;
        }
        Trend trend = new Trend(channel);
        trend.setTimeWindow(timeWindow);
        int mode = !plotter.isEmpty() && options.length != 0 && Arrays.asList(options).contains((Object)TrendPlotter.Option.OVERLAY) ? 1 : 0;
        plotter.plot(trend, mode);
        Trend finalTrend = trend;
        this.dataFetcher.execute(() -> this.refresh(finalTrend));
    }

    void plot(TrendingChannel channel, TimeWindow timeWindow, TrendPlotter.Option ... options) {
        EnumSet<TrendPlotter.Option> opts;
        if (channel == null) {
            return;
        }
        EnumSet<TrendPlotter.Option> enumSet = opts = options.length == 0 ? EnumSet.noneOf(TrendPlotter.Option.class) : EnumSet.copyOf(Arrays.asList(options));
        if (timeWindow == null && (timeWindow = this.getSelectedTimeWindow()) == null) {
            return;
        }
        Trend trend = null;
        if (opts.contains((Object)TrendPlotter.Option.EXIST)) {
            trend = this.findTrend(channel, timeWindow);
        }
        if (trend == null) {
            TrendPlotter plotter;
            Object page = null;
            PlotRegion region = null;
            if (!opts.contains((Object)TrendPlotter.Option.NEWPAGE)) {
                page = this.plotFactory.currentPage();
            }
            if (page == null) {
                page = this.createPage(channel.getTitle());
                if (page == null) {
                    this.getConsole().error("Unable to create a plot page");
                    return;
                }
                region = page.currentRegion();
            }
            if (region == null) {
                if (opts.contains((Object)TrendPlotter.Option.NEWPLOT)) {
                    int n = page.numberOfRegions();
                    for (int i = 0; i < n; ++i) {
                        PlotRegion r = page.region(i);
                        if (r.currentPlot() != null) continue;
                        region = r;
                        break;
                    }
                } else {
                    region = page.currentRegion();
                }
                if (region == null) {
                    region = page.addRegion();
                }
            }
            trend = new Trend(channel);
            trend.setTimeWindow(timeWindow);
            Plotter pl = region.currentPlot();
            if (pl != null && !(pl instanceof TrendPlotter)) {
                pl.clear();
                region.clear();
                pl = null;
            }
            if (pl == null) {
                plotter = this.create();
                LsstTrendingPlugin.showPlotter(plotter, region);
            } else {
                plotter = (TrendPlotter)pl;
            }
            int mode = !plotter.isEmpty() && opts.contains((Object)TrendPlotter.Option.OVERLAY) ? 1 : 0;
            plotter.plot(trend, mode);
        }
        trend.getPlotter().toFront();
        Trend finalTrend = trend;
        this.dataFetcher.execute(() -> this.refresh(finalTrend));
    }

    void refresh(TrendingChannel channel) {
        ArrayList<Trend> trends = this.findTrends(channel);
        trends.forEach(trend -> {
            if (!trend.getTimeWindow().isFixed()) {
                this.dataFetcher.execute(() -> this.refresh(trend.getPlotter().getTrends()));
            }
        });
    }

    void refresh(PlotPage page, TimeWindow timeWindow) {
        int n = page.numberOfRegions();
        try {
            for (int i = 0; i < n; ++i) {
                this.refresh(page.region(i), timeWindow);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    void refresh(PlotRegion region, TimeWindow timeWindow) {
        TrendPlotter tp;
        Plotter plotter = region.currentPlot();
        if (plotter != null && plotter instanceof TrendPlotter && (tp = (TrendPlotter)plotter).isActive()) {
            if (timeWindow != null) {
                tp.getTrends().forEach(t -> t.setTimeWindow(timeWindow));
            }
            this.dataFetcher.execute(() -> this.refresh(tp.getTrends()));
        }
    }

    static void showPlotter(TrendPlotter plotter, PlotRegion region) {
        Plotter oldPlotter = region.currentPlot();
        if (oldPlotter != null) {
            oldPlotter.clear();
            region.clear();
        }
        plotter.setRegion(region);
        region.showPlot((Plotter)plotter);
    }

    public boolean supports(Class klass) {
        return Trend.class.isAssignableFrom(klass);
    }

    public TrendPlotter create() {
        return new TrendPlotter(this);
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (this.dataFetcher == null) {
            return desc;
        }
        TimeWindow tw = this.getSelectedTimeWindow();
        if (tw.isPersistent()) {
            desc.setTimeWindow(tw.getName());
        } else {
            desc.setTimeWindow(tw.toCompressedString());
        }
        desc.setAutoRefresh(this.refreshMan != null);
        int n = this.pages.size();
        TrendingPanel.Descriptor[] panels = new TrendingPanel.Descriptor[n];
        for (int i = 0; i < n; ++i) {
            panels[i] = this.pages.get(i).save();
        }
        desc.setPages(panels);
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        if (!(storageBean instanceof Descriptor)) {
            throw new IllegalArgumentException("Illegal descriptor type: " + storageBean.getClassName());
        }
        Descriptor desc = (Descriptor)storageBean;
        this.autoRefreshMenu.setSelected(false);
        ArrayList<TrendingPanel> panels = new ArrayList<TrendingPanel>(this.pages);
        panels.forEach(page -> page.hidePage());
        String twString = desc.getTimeWindow();
        TimeWindow selectedTimeWindow = this.timeWindowBox.getTimeWindow(twString);
        if (selectedTimeWindow != null) {
            this.timeWindowBox.setSelectedTimeWindow(selectedTimeWindow);
        }
        for (TrendingPanel.Descriptor pageDesc : desc.getPages()) {
            TrendingPanel page2 = this.createPage(pageDesc.getTitle());
            page2.restore(pageDesc);
        }
        if (desc.isAutoRefresh()) {
            this.autoRefreshMenu.setSelected(true);
        }
        return true;
    }

    private void showToolbar() {
        TimeWindowSelector box;
        Studio app = (Studio)Application.getApplication();
        this.toolbar = new JToolBar("trending");
        box.setEnabled((box = new TimeWindowSelector(app)).getItemCount() > 0);
        JLabel boxLabel = new JLabel("Trending Period: ");
        this.toolbar.add((Component)boxLabel, 0);
        this.toolbar.add((Component)box, 1);
        JMenuBar bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        JMenu menu = new JMenu("Apply");
        bar.add(menu);
        JMenuItem item = new JMenuItem("All");
        item.addActionListener(e -> {
            PageManager pm = app.getPageManager();
            PageContext selectedPage = pm.getSelectedPage();
            List pcList = pm.pages();
            for (Object o : pcList) {
                try {
                    PlotPage page = (PlotPage)((PageContext)o).getPage();
                    if (page == null) continue;
                    this.refresh(page, this.getSelectedTimeWindow());
                }
                catch (ClassCastException | NullPointerException runtimeException) {}
            }
            selectedPage.requestShow();
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                if (page != null) {
                    this.refresh(page, this.getSelectedTimeWindow());
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                this.refresh(page.currentRegion(), this.getSelectedTimeWindow());
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        this.toolbar.add((Component)bar, 2);
        bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        menu = new JMenu("Refresh");
        bar.add(menu);
        item = new JMenuItem("All");
        item.addActionListener(e -> {
            PageManager pm = app.getPageManager();
            PageContext selectedPage = pm.getSelectedPage();
            List pcList = pm.pages();
            for (Object o : pcList) {
                try {
                    PlotPage page = (PlotPage)((PageContext)o).getPage();
                    if (page == null) continue;
                    this.refresh(page, null);
                }
                catch (ClassCastException | NullPointerException runtimeException) {}
            }
            selectedPage.requestShow();
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                if (page != null) {
                    this.refresh(page, null);
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                this.refresh(page.currentRegion(), null);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        menu.addSeparator();
        this.autoRefreshMenu = new JCheckBoxMenuItem("Auto");
        this.autoRefreshMenu.setSelected(false);
        this.autoRefreshMenu.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.startAutoRefresh();
            } else if (e.getStateChange() == 2) {
                this.stopAutoRefresh();
            }
        });
        menu.add(this.autoRefreshMenu);
        this.toolbar.add((Component)bar, 3);
        app.addToolBar(this.toolbar, this.toolbar.getName());
        this.timeWindowBox = box;
    }

    private void hideToolbar() {
        Studio app = (Studio)Application.getApplication();
        app.removeToolBar(this.toolbar);
        this.toolbar = null;
        this.timeWindowBox = null;
    }

    private void startAutoRefresh() {
        if (this.refreshMan != null) {
            this.stopAutoRefresh();
        }
        this.refreshMan = new AutoRefreshManager(this);
        this.refreshMan.start();
    }

    private void stopAutoRefresh() {
        if (this.refreshMan == null) {
            return;
        }
        this.refreshMan.stop();
        this.refreshMan = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRestServers(Collection<WebResource> servers) {
        Object object = this.restSourceLock;
        synchronized (object) {
            Iterator<WebResource> it;
            if (this.restSource != null) {
                this.getConsole().getConsoleLookup().remove((Object)this.restSource);
                this.restSource = null;
            }
            if ((it = servers.iterator()).hasNext()) {
                RestServerSource source;
                WebResource server = it.next();
                this.restSource = source = new RestServerSource(server, this);
                Runnable r = () -> {
                    if (source.connect()) {
                        Object object = this.restSourceLock;
                        synchronized (object) {
                            if (this.restSource == source) {
                                this.getConsole().getConsoleLookup().add((Object)this.restSource);
                            }
                        }
                    }
                };
                Thread t = new Thread(r, "REST Connector");
                t.setDaemon(true);
                t.start();
            }
        }
    }

    private ArrayList<Trend> findTrends(TrendingChannel channel) {
        String title = channel.getTitle();
        ArrayList<Trend> out = new ArrayList<Trend>();
        this.pages.forEach(page -> {
            int n = page.numberOfRegions();
            block0: for (int i = 0; i < n; ++i) {
                PlotRegion region = page.region(i);
                Plotter plotter = region.currentPlot();
                if (plotter == null || !(plotter instanceof TrendPlotter)) continue;
                List data = plotter.getData();
                for (Object d : data) {
                    Trend trend = (Trend)d;
                    if (!trend.getChannel().getTitle().equals(title)) continue;
                    out.add(trend);
                    continue block0;
                }
            }
        });
        return out;
    }

    private Trend findTrend(TrendingChannel channel, TimeWindow timeWindow) {
        ArrayList<Trend> all = this.findTrends(channel);
        Trend best = null;
        int score = 0;
        for (Trend candidate : all) {
            TrendPlotter plotter = candidate.getPlotter();
            if (plotter.getData().size() != 1) continue;
            int candidateScore = candidate.getTimeWindow() == timeWindow ? 1 : 0;
            candidateScore <<= 1 + (candidate.getChannel().getPath().equals(channel.getPath()) ? 1 : 0);
            if ((candidateScore <<= 3 + plotter.getRegion().getPage().numberOfRegions()) <= score) continue;
            best = candidate;
            score = candidateScore;
        }
        return best;
    }

    private void refresh(Trend trend) {
        trend.setLoading(true);
        TrendData data = this.treeMan.fetchData(trend, null);
        if (data != null && data != trend.getData()) {
            trend.setData(data);
        }
    }

    void refresh(List<Trend> trends) {
        List<TrendData> data = this.treeMan.fetchData(trends, null);
        Iterator<Trend> it = trends.iterator();
        int i = 0;
        while (it.hasNext()) {
            Trend trend = it.next();
            TrendData td = data.get(i);
            trend.setData(td);
            ++i;
        }
    }

    private TrendingPanel createPage(String name) {
        TrendingPanel panel = new TrendingPanel(this, name);
        this.pages.add(panel);
        return panel;
    }

    void closePage(TrendingPanel page) {
        this.pages.remove((Object)page);
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private String timeWindow;
        private boolean autoRefresh;
        private TrendingPanel.Descriptor[] pages;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public TrendingPanel.Descriptor[] getPages() {
            return this.pages;
        }

        public void setPages(TrendingPanel.Descriptor[] pages) {
            this.pages = pages;
        }

        public TrendingPanel.Descriptor getPages(int index) {
            return this.pages[index];
        }

        public void setPages(int index, TrendingPanel.Descriptor pages) {
            this.pages[index] = pages;
        }

        public boolean isAutoRefresh() {
            return this.autoRefresh;
        }

        public void setAutoRefresh(boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
        }
    }
}

