/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.CapturedData;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.gui.AllAxisPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.AnalogInputPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.ControllerPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.DigitalInputPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.DigitalOutputPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.MotionPanel;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorCommandSender;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorReplyReceiver;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.lsst.ccs.subsystem.motorplatform.gui.WorkerSelectionPanel;

public class MotorPlatformGUI
extends JPanel
implements MotorReplyListener {
    private AllAxisPanel allAxisPanel1;
    private AnalogInputPanel analogInputPanel1;
    private ControllerPanel controllerPanel1;
    private DigitalInputPanel inputPanel1;
    private MotionPanel motionPanel1;
    private DigitalOutputPanel outputPanel1;
    private WorkerSelectionPanel workerSelectionPanel1;

    public MotorPlatformGUI() {
        this.initComponents();
    }

    public void init(MotorCommandSender sender, MotorReplyReceiver replyHandler) {
        ArrayList<TargetStatusListener> tsListeners = new ArrayList<TargetStatusListener>(this.allAxisPanel1.getTargetStatusListeners());
        tsListeners.add(this.controllerPanel1);
        tsListeners.add(this.motionPanel1);
        tsListeners.add(this.outputPanel1);
        tsListeners.add(sender);
        tsListeners.add(replyHandler);
        this.workerSelectionPanel1.init(tsListeners, sender);
        this.allAxisPanel1.init(sender);
        this.controllerPanel1.init(sender);
        this.motionPanel1.init(sender);
        this.outputPanel1.init(sender);
    }

    public String getCurrentTarget() {
        return this.workerSelectionPanel1.getCurrentTarget();
    }

    public void addSubsystem(String name) {
        SwingUtilities.invokeLater(() -> this.workerSelectionPanel1.addSubsystem(name));
    }

    public void removeSubsystem(String name) {
        SwingUtilities.invokeLater(() -> this.workerSelectionPanel1.removeSubsystem(name));
    }

    @Override
    public void axisStatus(AxisStatus status) {
        SwingUtilities.invokeLater(() -> this.allAxisPanel1.update(status));
    }

    @Override
    public void capturedData(CapturedData data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void controllerStatus(ControllerStatus status) {
        SwingUtilities.invokeLater(() -> this.controllerPanel1.update(status));
    }

    @Override
    public void ioStatus(IOStatus status) {
        SwingUtilities.invokeLater(() -> {
            this.inputPanel1.update(status);
            this.outputPanel1.update(status);
            this.analogInputPanel1.update(status);
        });
    }

    @Override
    public void platformConfig(PlatformConfig config) {
        SwingUtilities.invokeLater(() -> {
            this.allAxisPanel1.configure(config);
            this.analogInputPanel1.configure(config);
            this.controllerPanel1.configure(config);
            this.inputPanel1.configure(config);
            this.motionPanel1.configure(config);
            this.outputPanel1.configure(config);
        });
    }

    private void initComponents() {
        this.allAxisPanel1 = new AllAxisPanel();
        this.motionPanel1 = new MotionPanel();
        this.controllerPanel1 = new ControllerPanel();
        this.inputPanel1 = new DigitalInputPanel();
        this.outputPanel1 = new DigitalOutputPanel();
        this.workerSelectionPanel1 = new WorkerSelectionPanel();
        this.analogInputPanel1 = new AnalogInputPanel();
        this.analogInputPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.allAxisPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.workerSelectionPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.motionPanel1, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controllerPanel1, -2, 241, -2)).addComponent(this.analogInputPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.outputPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputPanel1, -2, 165, -2).addGap(0, 0, Short.MAX_VALUE))).addGap(579, 579, 579)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allAxisPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.controllerPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.motionPanel1, GroupLayout.Alignment.LEADING, -2, 258, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.workerSelectionPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analogInputPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.outputPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.inputPanel1, -1, -1, Short.MAX_VALUE)))).addContainerGap(130, Short.MAX_VALUE)));
    }
}

