/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.ObjectNType;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.trending.Trendable;
import org.lsst.ccs.bus.trending.TrendingData;

public class DataValueNotification
extends ValueNotification {
    private Map<String, ObjectNType> trendingDesc;

    public DataValueNotification(String name, Serializable object, long tStamp) {
        this.name = name;
        ObjectNType val = new ObjectNType(object);
        this.data = val;
        this.tStamp = tStamp;
        if (!val.isOfWellKnownType()) {
            this.createTrendingMap(name, object);
        }
    }

    public DataValueNotification(String name, Serializable object) {
        this(name, object.getClass(), object);
    }

    public DataValueNotification(String name, Class classOfData, Serializable object) {
        this.name = name;
        ObjectNType val = new ObjectNType(classOfData, object);
        this.data = val;
        this.tStamp = System.currentTimeMillis();
        if (!val.isOfWellKnownType()) {
            this.createTrendingMap(name, object);
        }
    }

    public DataValueNotification(String name, int val) {
        this(name, Integer.TYPE, (long)val);
    }

    public DataValueNotification(String name, double val) {
        this(name, Double.TYPE, Double.valueOf(val));
    }

    public DataValueNotification(String name, float val) {
        this(name, Float.TYPE, Float.valueOf(val));
    }

    public DataValueNotification(String name, char val) {
        this(name, Character.TYPE, (long)val);
    }

    public DataValueNotification(ValueNotification notification) {
        this(notification.getName(), (Serializable)(notification.getData() instanceof Serializable ? (Serializable)notification.getData() : String.valueOf(notification.getData())), notification.gettStamp());
    }

    private boolean createTrendingMap(String name, Serializable obj) {
        if (obj == null) {
            return false;
        }
        Trendable trendable = obj.getClass().getAnnotation(Trendable.class);
        if (trendable == null) {
            return false;
        }
        this.trendingDesc = new HashMap<String, ObjectNType>();
        this.updateTrendingMap(name, obj);
        return true;
    }

    private void updateTrendingMap(String name, Serializable obj) {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            TrendingData annotation = field.getAnnotation(TrendingData.class);
            if (annotation != null) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value != null) {
                        Class<?> fieldClass = field.getType();
                        String fieldName = annotation.key();
                        if ("".equals(fieldName)) {
                            fieldName = field.getName();
                        }
                        String newKey = String.valueOf(name) + "/" + fieldName;
                        if (fieldClass.isPrimitive() || Serializable.class.isAssignableFrom(fieldClass)) {
                            ObjectNType objNtype = new ObjectNType(fieldClass, (Serializable)value);
                            if (objNtype.isOfWellKnownType()) {
                                this.trendingDesc.put(newKey, objNtype);
                            } else {
                                Trendable trendable = fieldClass.getAnnotation(Trendable.class);
                                if (trendable != null) {
                                    this.updateTrendingMap(newKey, (Serializable)value);
                                } else {
                                    this.updateTrendingMapWithString(newKey, value);
                                }
                            }
                        } else {
                            this.updateTrendingMapWithString(newKey, value);
                        }
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Non Accessible field!" + name + " " + obj);
                }
            }
            ++n2;
        }
    }

    private void updateTrendingMapWithString(String name, Object obj) {
        this.trendingDesc.put(name, new ObjectNType(String.class, (Serializable)((Object)String.valueOf(obj))));
    }

    public boolean isOfWellKnownType() {
        if (this.data instanceof ObjectNType) {
            return ((ObjectNType)this.data).isOfWellKnownType();
        }
        return true;
    }

    public boolean isOfPrimitiveType() {
        if (this.data instanceof ObjectNType) {
            return ((ObjectNType)this.data).isOfPrimitiveType();
        }
        return false;
    }

    public Map<String, ObjectNType> getTrendingMap() {
        return this.trendingDesc;
    }

    public Object getRealData() throws ClassNotFoundException {
        if (this.data instanceof ObjectNType) {
            return ((ObjectNType)this.data).getData();
        }
        return this.data;
    }

    @Override
    @Deprecated
    public Object getData() {
        try {
            return this.getRealData();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.data instanceof ObjectNType) {
                return ((ObjectNType)this.data).getRawData();
            }
            return this.data;
        }
    }

    public ObjectNType getObjectNType() {
        return (ObjectNType)this.data;
    }

    @Override
    public String toString() {
        return "TrendingData(" + this.name + "=" + this.data + "@" + this.tStamp + ")";
    }
}

