/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.ImageNameAssigner;
import org.lsst.ccs.imagenaming.Source;

public class ImageNameAssignerTest {
    private String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void testAssignImageNumber() throws SQLException {
        try (ImageNameAssigner ina = new ImageNameAssigner(this.createConnection());){
            Instant time = Instant.parse("2007-12-03T10:15:30.00Z");
            TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
            ImageName assignImageName = ina.assignImageName(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, time);
            Assert.assertEquals((Object)"CC_O_20071203_000001", (Object)assignImageName.toString());
            assignImageName = ina.assignImageName(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, time);
            Assert.assertEquals((Object)"CC_O_20071203_000002", (Object)assignImageName.toString());
            assignImageName = ina.assignImageName(Source.MainCamera, Controller.OCS, timeZone, Duration.ZERO, time);
            Assert.assertEquals((Object)"MC_O_20071203_000001", (Object)assignImageName.toString());
            assignImageName = ina.assignImageName(Source.MainCamera, Controller.OCS, TimeZone.getTimeZone("UTC"), Duration.ofHours(12L), time);
            Assert.assertEquals((Object)"MC_O_20071202_000001", (Object)assignImageName.toString());
        }
    }

    @Test
    public void testAssignImageNumbers() throws SQLException {
        try (ImageNameAssigner ina = new ImageNameAssigner(this.createConnection());){
            Instant time = Instant.parse("2007-12-03T10:15:30.00Z");
            TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
            List assignImageNames = ina.assignImageNames(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, 10, time);
            Assert.assertEquals((long)10L, (long)assignImageNames.size());
            Assert.assertEquals((Object)"CC_O_20071203_000001", (Object)((ImageName)assignImageNames.get(0)).toString());
            Assert.assertEquals((Object)"CC_O_20071203_000010", (Object)((ImageName)assignImageNames.get(9)).toString());
            assignImageNames = ina.assignImageNames(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, 10, time);
            Assert.assertEquals((long)10L, (long)assignImageNames.size());
            Assert.assertEquals((Object)"CC_O_20071203_000011", (Object)((ImageName)assignImageNames.get(0)).toString());
            Assert.assertEquals((Object)"CC_O_20071203_000020", (Object)((ImageName)assignImageNames.get(9)).toString());
        }
    }

    @Test
    public void threadTest() throws SQLException, InterruptedException, ExecutionException {
        try (ImageNameAssigner ina1 = new ImageNameAssigner(this.createConnection());
             ImageNameAssigner ina2 = new ImageNameAssigner(this.createConnection());){
            Instant time = Instant.parse("2007-12-03T10:15:30.00Z");
            ExecutorService executor = Executors.newFixedThreadPool(8);
            ArrayList<Future<ImageName>> results = new ArrayList<Future<ImageName>>();
            for (int i = 0; i < 1000; ++i) {
                results.add(executor.submit(() -> (Math.random() >= 0.5 ? ina1 : ina2).assignImageName(Source.AuxTel, Controller.CCS, TimeZone.getTimeZone("America/Los_Angeles"), Duration.ZERO, time)));
            }
            TreeSet<ImageName> names = new TreeSet<ImageName>();
            for (Future future : results) {
                ImageName in = (ImageName)future.get();
                Assert.assertTrue((String)("Duplicate result: " + in), (boolean)names.add(in));
            }
            Assert.assertEquals((Object)"AT_C_20071203_001000", (Object)((ImageName)names.last()).toString());
        }
    }

    @Test
    public void timeoutTest() throws SQLException, InterruptedException, ExecutionException {
        try (ImageNameAssigner ina = new ImageNameAssigner(this.createConnection());){
            Instant time = Instant.parse("2007-12-03T10:15:30.00Z");
            TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
            ImageName assignImageName = ina.assignImageName(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, time);
            Assert.assertEquals((Object)"CC_O_20071203_000001", (Object)assignImageName.toString());
            ina.forceClose();
            ImageName assignImageName2 = ina.assignImageName(Source.ComCam, Controller.OCS, timeZone, Duration.ZERO, time);
            Assert.assertEquals((Object)"CC_O_20071203_000001", (Object)assignImageName2.toString());
        }
    }
}

