package org.lsst.ccs.utilities.ccd;

/**
 * The Segment readout point with respect to the (parallel,serial)
 * Camera Coordinate System.
 * 
 * With the parallel direction along the x axis and growing to the left and
 * the serial direction along y growing upward we define:
 * 
 * - Left and Right along the parallel direction, Left growing, Right decreasing.
 * - Up and Down along the serial direction, Up growing, Down decreasing.
 * 
 *
 * @author The LSST CCS Team
 */
public enum SegmentReadOutOrder {

    LeftDown(true, true), LeftUp(true, false), RightDown(false, true), RightUp(false, false);

    private final boolean isLeft, isDown;

    private SegmentReadOutOrder(boolean isLeft, boolean isDown) {
        this.isLeft = isLeft;
        this.isDown = isDown;
    }

    /**
     * Returns true if the Segment is read from top to bottom in the serial
     * direction.
     * 
     * @return true if the segment is read down along the serial direction.
     */
    public boolean isReadoutDown() {
        return isDown;
    }

    /**
     * Returns true if the Segment is read from left to right in the parallel
     * direction.
     * 
     * @return true if the segment is read from the left along the parallel direction.
     */
    public boolean isReadoutLeft() {
        return isLeft;
    }

}
