/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class SpecFileLoadingTest {
    @Test
    public void testLoadSpecFile() {
        System.setProperty("some.other.prop", "123");
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        headerSpecsBuilder.addSpecFile("test_cond");
        Assert.assertEquals((Object)"PhotodiodeModeldef", (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("PD_MODEL").getMetaName());
        Assert.assertEquals((Object)"123PhotodiodeSignalabc", (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("PD_SER").getMetaName());
        System.setProperty("some.other.prop", "");
        MetaDataSet mds = new MetaDataSet();
        mds.addMetaData("", "one", (Object)"1");
        mds.addMetaData("", "two", (Object)"2");
        mds.addMetaData("", "three", (Object)"3");
        mds.addMetaData("", "one3", (Object)"13");
        mds.addMetaData("", "Some1", (Object)1234);
        mds.addMetaData("", "Some12", (Object)4453453);
        mds.addMetaData("", "Some132", (Object)34);
        Assert.assertEquals((Object)1234, (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("SOME1").getValue(mds));
        Assert.assertEquals((Object)4453453, (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("SOME2").getValue(mds));
        Assert.assertEquals((Object)34, (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("SOME3").getValue(mds));
        Assert.assertEquals((Object)"Constant with spaces", (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("C_SPACE").getValue(mds));
        Assert.assertEquals((Object)"Vera C. Rubin Observatory", (Object)((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond")).getHeader("TELESCOP").getValue(mds));
    }

    @Test
    public void testRequiredHeaders() {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        headerSpecsBuilder.addSpecFile("test_cond");
        HeaderSpecification spec = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("test_cond");
        Collection required = spec.getRequiredHeaders();
        Assert.assertEquals((long)3L, (long)required.size());
        ArrayList<String> requiredEntries = new ArrayList<String>(Arrays.asList("ND_FILT", "PD_SER", "SOME3"));
        for (HeaderSpecification.HeaderLine l : required) {
            Assert.assertTrue((boolean)requiredEntries.remove(l.getKeyword()));
        }
        Assert.assertEquals((long)0L, (long)requiredEntries.size());
    }

    @Test
    public void testCompilingHeaders() {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("replacement");
        MetaDataSet mds = new MetaDataSet();
        mds.addMetaData("", "CCD", (Object)"S22");
        mds.addMetaData("", "RAFT", (Object)"R22");
        mds.addMetaData("", "REB", (Object)"Reb2");
        mds.addMetaData("", "focal-plane/R22/Reb2/sequencerFile", (Object)"someString");
        mds.addMetaData("", "focal-plane/R22/Reb2/sequencerChecksum", (Object)"someString");
        mds.addMetaData("", "focal-plane/R22/Reb2/S22/name", (Object)"someString");
        mds.addMetaData("", "focal-plane/R22/Reb2/name", (Object)"someString");
        mds.addMetaData("", "focal-plane/R22/name", (Object)"someString");
        mds.addMetaData("", "DarkTime", (Object)"1.234");
        mds.addMetaData("", "ImageName", (Object)"someString");
        mds.addMetaData("", "ImageSource", (Object)"someString");
        mds.addMetaData("", "ImageController", (Object)"someString");
        mds.addMetaData("", "ImageDate", (Object)"someString");
        mds.addMetaData("", "ImageNumber", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/CCDtemp0", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/S22/Temp", (Object)"1.234");
        mds.addMetaData("", "TestSeqNum", (Object)1234);
        mds.addMetaData("", "ccob/tempLed1", (Object)"1.234");
        mds.addMetaData("", "ccob/tempLed2", (Object)"1.234");
        mds.addMetaData("", "ccob/tempSphere", (Object)"1.234");
        mds.addMetaData("", "ccob/tempBrd", (Object)"1.234");
        mds.addMetaData("", "CCOBLED", (Object)"someString");
        mds.addMetaData("", "CCOBCURR", (Object)"1.234");
        mds.addMetaData("", "CCOBADC", (Object)"1.234");
        mds.addMetaData("", "bot-motorplatform/LampStatus/xcam", (Object)"1.234");
        mds.addMetaData("", "bot-motorplatform/LampStatus/ycam", (Object)"1.234");
        mds.addMetaData("", "bot-motorplatform/LampStatus/xbot", (Object)"1.234");
        mds.addMetaData("", "bot-motorplatform/LampStatus/ybot", (Object)"1.234");
        mds.addMetaData("", "bot-bench/ColorFWheel/filterName", (Object)"someString");
        mds.addMetaData("", "bot-bench/NeutralFWheel/filterName", (Object)"someString");
        mds.addMetaData("", "ExposureTime2", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp1", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp2", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp3", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp4", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp5", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Temp6", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Atemp0U", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Atemp0L", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DigPS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DigPS_I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/AnaPS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/AnaPS_I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ClkHPS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ClkHPS_I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ODPS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ODPS_I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/HtrPS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/HtrPS_I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/CKPSH_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/CKS_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/SCKU_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/SCKL_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/RG_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/RGU_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/RGL_V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/CKP0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/CKS0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/RG0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/OD0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/OG0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/RD0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/GD0V", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/OD0I", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/gdP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/gd", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/rdP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/rd", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/ogP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/og", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/odP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/od", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/csGateP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/Bias0/csGate", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC0/rc", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC1/rc", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC0/gain", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC1/gain", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC0/clamp", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC1/clamp", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC0/af1", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/ASPIC1/af1", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/sclkLowP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/sclkLow", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/sclkHighP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/sclkHigh", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/pclkLowP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/pclkLow", (Object)1234);
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/pclkHighP", (Object)1.234);
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/pclkHigh", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/rgLowP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/rgLow", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/rgHighP", (Object)"1.234");
        mds.addMetaData("", "focal-plane/R22/Reb2/DAC/rgHigh", (Object)"1234");
        mds.addMetaData("", "focal-plane/R22/Reb2/HVBiasState", (Object)"someString");
        mds.addMetaData("", "rebpower/R22/Reb2/Power", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/digital/VbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/digital/IbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/digital/VaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/digital/IaftLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/digital/VaftSwch", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/analog/VbefLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/analog/IbefLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/analog/VaftLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/analog/IaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/analog/VaftSwch", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/VbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/IbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/VaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/VaftLDO2", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/IaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/OD/VaftSwch", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/clockhi/VbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/clockhi/IbefLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clockhi/VaftLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clockhi/IaftLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clockhi/VaftSwch", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/VbefLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/VaftLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/IbefLDO", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/VaftSwch", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/VaftLDO2", (Object)"1.234");
        mds.addMetaData("", "rebpower/R22/Reb2/clocklo/IaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/heater/VbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/heater/IbefLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/heater/VaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/heater/IaftLDO", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/heater/VaftSwch", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/hvbias/VbefSwch", (Object)1.234);
        mds.addMetaData("", "rebpower/R22/Reb2/hvbias/IbefSwch", (Object)1.234);
        Collection lines = ((HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("replacement")).getHeaders();
        Assert.assertEquals((long)131L, (long)lines.size());
        long start = System.currentTimeMillis();
        for (HeaderSpecification.HeaderLine line : lines) {
            line.getValue(mds);
        }
        long delta1 = System.currentTimeMillis() - start;
        Assert.assertTrue((delta1 < 15L ? 1 : 0) != 0);
        for (HeaderSpecification.HeaderLine line : lines) {
            HeaderSpecification.DataType type = line.getDataType();
            if (!line.isExpression()) continue;
            if (type == HeaderSpecification.DataType.Float) {
                Assert.assertEquals((String)line.getKeyword(), (Object)line.getValue(mds), (Object)1.234);
                continue;
            }
            if (type != HeaderSpecification.DataType.Integer) continue;
            Assert.assertEquals((String)line.getKeyword(), (Object)line.getValue(mds), (Object)1234);
        }
    }
}

