package org.lsst.ccs.utilities.ccd;

/**
 * An object that defines a Segment geometry constants.
 * 
 * @author The LSST CCS Team
 */
public final class SegmentGeometryConstants {
    
    private final int serialActiveSize, parallelActiveSize, serialPrescanSize;
    
    /**
     * Segment geometry constants to LCA-13501
     * @param segmentWidth   Number of pixels in the vertical direction    dimv
     * @param segmentHeight  Number of pixels in the horizontal direction  dimh
     * @param serialPrescan  Number of prescan pixels in the horizontal direction preh
     * 
     */
    public SegmentGeometryConstants(int segmentWidth, int segmentHeight, int serialPrescan) {        
        this.serialActiveSize = segmentHeight;
        this.parallelActiveSize = segmentWidth;
        this.serialPrescanSize = serialPrescan;
    }    
    
    int getSegmentParallelActiveSize() {
        return parallelActiveSize;
    }
    
    int getSegmentSerialActiveSize() {
        return serialActiveSize;
    }    
    
    int getSegmentSerialPrescanSize() {
        return serialPrescanSize;
    }

}
