/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.location;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.location.Camera;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class LocationTest {
    @Test
    public void serializableTest() throws IOException, ClassNotFoundException {
        Location l = Location.of((String)"R22/Reb1");
        Object result = LocationTest.serializeDeserialize(l);
        Assert.assertTrue((boolean)(result instanceof Location));
        Assert.assertEquals((Object)result, (Object)l);
    }

    @Test
    public void locationSetSerializableTest() throws IOException, ClassNotFoundException {
        LocationSet ls = LocationSet.of((String[])new String[]{"R22/Reb1", "R11/Reb0"});
        Object result = LocationTest.serializeDeserialize(ls);
        Assert.assertTrue((boolean)(result instanceof LocationSet));
        Assert.assertEquals((Object)result, (Object)ls);
    }

    @Test
    public void commaDelitedStringTest() {
        LocationSet l1 = LocationSet.of((String[])new String[]{"R22/Reb1", "R11/Reb0"});
        LocationSet l2 = LocationSet.of((String[])new String[]{"R22/Reb1 , R11/Reb0"});
        Assert.assertEquals((Object)l1, (Object)l2);
    }

    @Test
    public void illegalTest() {
        try {
            Location l = Location.of((String)"R22/RebX");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void illegalTest2() {
        try {
            Location l = Location.of((String)"R55");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void illegalCornerTest() {
        try {
            Location l = Location.of((String)"R00/Reb2");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void constructorTest() {
        LocationSet locations = new LocationSet(" ");
        Assert.assertEquals((long)0L, (long)locations.size());
        locations = new LocationSet("R11/Reb0");
        Assert.assertEquals((long)1L, (long)locations.size());
        locations = new LocationSet("R22/Reb1 , R11/Reb0");
        Assert.assertEquals((long)2L, (long)locations.size());
    }

    @Test
    public void fullRaftTest() {
        LocationSet locations = new LocationSet("R22,R44");
        Assert.assertEquals((long)5L, (long)locations.size());
        locations = new LocationSet("R22");
        Assert.assertEquals((long)3L, (long)locations.size());
        locations = LocationSet.of((String[])new String[]{"R22"});
        Assert.assertEquals((long)3L, (long)locations.size());
    }

    @Test
    public void negativeTest1() {
        LocationSet locations = new LocationSet("-R22");
        Assert.assertEquals((long)68L, (long)locations.getBitSet().cardinality());
    }

    @Test
    public void negativeTest2() {
        LocationSet locations = new LocationSet("R22,-R22");
        Assert.assertEquals((long)0L, (long)locations.getBitSet().cardinality());
    }

    @Test
    public void negativeTest3() {
        LocationSet locations = new LocationSet("R22, -R22/Reb0");
        Assert.assertEquals((long)2L, (long)locations.getBitSet().cardinality());
    }

    @Test
    public void negativeTest4() {
        LocationSet locations = new LocationSet(" -R22/Reb0");
        Assert.assertEquals((long)70L, (long)locations.getBitSet().cardinality());
    }

    @Test
    public void allTest() {
        LocationSet all = LocationSet.all();
        Assert.assertEquals((long)71L, (long)all.getBitSet().cardinality());
    }

    @Test
    public void retainAllTest() {
        LocationSet all = LocationSet.all();
        LocationSet R22 = new LocationSet("R22");
        all.retainAll((Collection)R22);
        Assert.assertEquals((Object)all, (Object)R22);
    }

    @Test
    public void testPartialReadout() {
        LocationSet locations = LocationSet.of((String[])new String[]{"R22/Reb1", "R40/RebG"});
        int[] asIntArray = locations.asIntArray();
        Assert.assertArrayEquals((int[])new int[]{89, 161}, (int[])asIntArray);
    }

    @Test
    public void testPartialReadout2() {
        LocationSet locations = LocationSet.of((String[])new String[]{""});
        assert (locations.isEmpty());
    }

    @Test
    public void testLocationSetForCamera() {
        LocationSet lsstcamLocations = LocationSet.forCamera((Camera)Camera.LSSTCAM);
        Assert.assertEquals((Object)lsstcamLocations, (Object)LocationSet.all());
        LocationSet comcamLocations = LocationSet.forCamera((Camera)Camera.COMCAM);
        Assert.assertEquals((Object)comcamLocations, (Object)new LocationSet("R22"));
        LocationSet auxtelLocations = LocationSet.forCamera((Camera)Camera.AUXTEL);
        Assert.assertEquals((Object)auxtelLocations, (Object)new LocationSet("R00/RebW"));
    }

    @Test
    public void testLocationSetForDAQPartition() {
        LocationSet lsstcamLocations = LocationSet.forCamera((Camera)Camera.forDaqPartition((String)"lsstcam"));
        Assert.assertEquals((Object)lsstcamLocations, (Object)LocationSet.all());
        LocationSet comcamLocations = LocationSet.forCamera((Camera)Camera.forDaqPartition((String)"comcam"));
        Assert.assertEquals((Object)comcamLocations, (Object)new LocationSet("R22"));
        LocationSet auxtelLocations = LocationSet.forCamera((Camera)Camera.forDaqPartition((String)"lat"));
        Assert.assertEquals((Object)auxtelLocations, (Object)new LocationSet("R00/RebW"));
    }

    @Test
    public void testLocationSetForDAQPartitionAndPlatform() {
        LocationSet lsstcamLocations = LocationSet.forCamera((Camera)Camera.forDAQPartitionAndPlatform((String)"lsstcam", (String)"lsstcam"));
        Assert.assertEquals((Object)lsstcamLocations, (Object)LocationSet.all());
        LocationSet comcamLocations = LocationSet.forCamera((Camera)Camera.forDAQPartitionAndPlatform((String)"comcam", (String)"comcam"));
        Assert.assertEquals((Object)comcamLocations, (Object)new LocationSet("R22"));
        LocationSet auxtelLocations = LocationSet.forCamera((Camera)Camera.forDAQPartitionAndPlatform((String)"lat", (String)"auxtel"));
        Assert.assertEquals((Object)auxtelLocations, (Object)new LocationSet("R00/RebW"));
        comcamLocations = LocationSet.forCamera((Camera)Camera.forDAQPartitionAndPlatform((String)"emu", (String)"comcam"));
        Assert.assertEquals((Object)comcamLocations, (Object)new LocationSet("R22"));
        auxtelLocations = LocationSet.forCamera((Camera)Camera.forDAQPartitionAndPlatform((String)"emu", (String)"auxtel"));
        Assert.assertEquals((Object)auxtelLocations, (Object)new LocationSet("R00/RebW"));
    }

    static Object serializeDeserialize(Object in) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(in);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
    }
}

