
package org.lsst.ccs.utilities.image;

/**
 * PROTOTYPE INTERFACE FOR GENERALIZING IMAGE DATA STREAMS IN AN ATTEMPT TO
 * AVOID UN-NECESSARY COPYING OF DATA
 * 
 * An interface representing a stream of Image data that has been processed
 * and ready to be written in a Fits file.
 * 
 * The methods of this interface are modeled after a ByteBuffer.
 * This interface allows developers to wrap and manipulate underlying data objects
 * without having to copy them in memory.
 * 
 * @author turri
 */
public interface ImageDataStream {
 

    /**
     * Get the number of elements between the current position and the
     * limit.
     * @return The number of elements remaining in this stream.
     */
    public int remaining();
    
    
    /**
     * Get the byte at the current position and then increment the position.
     * @return The byte at the current position.
     */
    public byte get();



    
//            if (src.hasArray()) {
//
//                src.array(), src.arrayOffset() + src.position(), src.remaining());
//                src.position(src.limit());
//            } else {
//            }
//
//            src.order(ByteOrder.BIG_ENDIAN);
//            src.asShortBuffer();


}
