/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderSpecification {
    private String name;
    private final Map<String, HeaderLine> headers = new LinkedHashMap<String, HeaderLine>();
    private final Map<String, GroupLine> groups = new LinkedHashMap<String, GroupLine>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(?<exp>[^\\|]*)(?<default>\\|.*)?}");
    private static final Pattern INNER_EXPRESSION_PATTERN = Pattern.compile("(?<pre>.*)(?<exp>(\\$\\{(?<value>[^\\$\\{\\}]*)\\}))(?<post>.*)");
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile(".*(\\[System\\(([^,]+)(,.*)?\\)\\]).*");
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+([^\\s]+)\\s+(?:\"(.*)\"|(\\S+))\\s*(.*)");
    private static final Pattern DATA_TYPE_PATTERN = Pattern.compile("(\\w+){1}\\(*([^()]*)\\)*");
    private static final Logger LOG = Logger.getLogger(HeaderSpecification.class.getName());
    public static final Object NULL = new Object();

    public HeaderSpecification(String name, InputStream in) throws IOException {
        this(name, new InputStreamReader(in));
    }

    public HeaderSpecification(String name, Reader in) throws IOException {
        this.name = name;
        this.addGroup(new GroupLine());
        this.loadHeaderSpecification(in);
    }

    public HeaderSpecification(HeaderSpecification spec) {
        this.name = spec.name;
        for (Map.Entry<String, HeaderLine> entry : spec.headers.entrySet()) {
            this.headers.put(entry.getKey(), new HeaderLine(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : spec.groups.entrySet()) {
            this.groups.put(entry.getKey(), new GroupLine((GroupLine)entry.getValue()));
        }
    }

    final void loadHeaderSpecification(InputStream in) throws IOException {
        this.loadHeaderSpecification(new InputStreamReader(in));
    }

    private void addGroup(GroupLine group) {
        String groupName = group.getGroupName();
        if (this.groups.containsKey(groupName)) {
            this.groups.get(groupName).addComments(group.comments);
        } else {
            this.groups.put(groupName, group);
        }
    }

    final void loadHeaderSpecification(Reader in) throws IOException {
        String line;
        BufferedReader reader;
        BufferedReader bufferedReader = reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            if (line.startsWith("BLANK")) {
                String groupLine = line.replace("BLANK", "").trim();
                this.addGroup(new GroupLine(groupLine));
                continue;
            }
            try {
                Matcher sysPropMatcher;
                while ((sysPropMatcher = SYSTEM_PROPERTY_PATTERN.matcher(line)).matches()) {
                    String def = sysPropMatcher.group(3);
                    def = def == null ? "" : def.substring(1);
                    line = line.replace(sysPropMatcher.group(1), System.getProperty(sysPropMatcher.group(2), def));
                }
                HeaderLine headerLine = new HeaderLine(line);
                if (!this.groups.keySet().contains(headerLine.groupName)) {
                    throw new RuntimeException("Group " + headerLine.groupName + " has not been defined in the spec files.");
                }
                if (this.headers.containsKey(headerLine.getKeyword())) {
                    LOG.log(Level.INFO, "Duplicate definition for header keyword: {0}. Overriding current definition {1}.", new Object[]{headerLine.getKeyword(), this.headers.get(headerLine.getKeyword()).getMetaName()});
                }
                this.headers.put(headerLine.getKeyword(), headerLine);
            }
            catch (IOException x) {
                throw new IOException("Error while reading line:\n\t" + line, x);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HeaderLine getHeader(String keyWord) {
        return this.headers.get(keyWord);
    }

    public Collection<HeaderLine> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    public Collection<HeaderLine> getHeadersForGroup(String groupName) {
        ArrayList<HeaderLine> headersForGroup = new ArrayList<HeaderLine>();
        for (HeaderLine l : this.headers.values()) {
            if (!l.groupName.equals(groupName)) continue;
            headersForGroup.add(l);
        }
        return headersForGroup;
    }

    public Collection<GroupLine> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    Collection<HeaderLine> getRequiredHeaders() {
        return this.headers.values().stream().filter(h -> h.isRequired).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Integer sensibleDecode(String valueExpression) {
        if (valueExpression.startsWith("0x")) {
            return Integer.decode(valueExpression);
        }
        return Integer.valueOf(valueExpression);
    }

    private static Object coerce(String valueExpression, DataType dataType) throws FitsException, NumberFormatException {
        switch (dataType) {
            case Integer: {
                return HeaderSpecification.sensibleDecode(valueExpression);
            }
            case Float: {
                return Double.valueOf(valueExpression);
            }
            case Boolean: {
                return Boolean.valueOf(valueExpression);
            }
            case Date: {
                return DateUtils.convertStringToDate(valueExpression);
            }
            case MJD: {
                return Double.valueOf(valueExpression);
            }
        }
        return valueExpression;
    }

    public static void main(String[] argv) throws Exception {
        String s1;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("something/23", "1");
        map.put("else", "2");
        map.put("again", "3");
        String expressionVal = "${something/${else}${again}}";
        String s2 = s1 = "Some String";
        System.out.println(s1 + " " + s2 + " " + s1.equals(s2));
        s1 = "Changed";
        System.out.println(s1 + " " + s2 + " " + s1.equals(s2));
    }

    public static class GroupLine {
        private final String groupName;
        private final List<String> comments = new ArrayList<String>();

        public GroupLine(String groupLine) {
            int separatorIndex = groupLine.indexOf(" ");
            this.groupName = separatorIndex == -1 ? groupLine : groupLine.substring(0, separatorIndex);
            String comment = groupLine.replaceFirst(this.groupName, "").trim();
            this.comments.add(comment);
        }

        public GroupLine(GroupLine groupLine) {
            this.groupName = groupLine.groupName;
            this.comments.addAll(groupLine.comments);
        }

        public GroupLine() {
            this.groupName = "";
            this.comments.add("Default group");
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public void addComments(List<String> comments) {
            this.comments.addAll(comments);
        }
    }

    public static class HeaderLine {
        private final String keyword;
        private final DataType dataType;
        private final String format;
        private final String comment;
        private final String metaName;
        private final Object value;
        private final String metaMap;
        private final String valueExpression;
        private final boolean isExpression;
        private final boolean evaluateOnTheFly;
        private final boolean isRequired;
        private final String originalLine;
        private final Object defaultValue;
        private final String groupName;

        HeaderLine(HeaderLine orig) {
            this.keyword = orig.keyword;
            this.dataType = orig.dataType;
            this.comment = orig.comment;
            this.metaName = orig.metaName;
            this.value = orig.value;
            this.metaMap = orig.metaMap;
            this.valueExpression = orig.valueExpression;
            this.isExpression = orig.isExpression;
            this.evaluateOnTheFly = orig.evaluateOnTheFly;
            this.isRequired = orig.isRequired;
            this.originalLine = orig.originalLine;
            this.defaultValue = orig.defaultValue;
            this.groupName = orig.groupName;
            this.format = orig.format;
        }

        HeaderLine(String line) throws IOException {
            this.originalLine = line;
            String tmpMetaName = null;
            String tmpMetaMap = null;
            Object tmpValue = null;
            String tmpValueExpression = null;
            boolean tmpEvaluateOnTheFly = false;
            try {
                Matcher lineMatcher = LINE_PATTERN.matcher(line);
                if (!lineMatcher.matches()) {
                    throw new IOException("Invalid line in header specification");
                }
                String tmpKeyword = lineMatcher.group(1);
                this.isRequired = tmpKeyword.endsWith("!");
                if (tmpKeyword.contains(":")) {
                    int ind = tmpKeyword.indexOf(":");
                    this.groupName = tmpKeyword.substring(0, ind);
                    tmpKeyword = tmpKeyword.substring(ind + 1);
                } else {
                    this.groupName = "";
                }
                this.keyword = this.isRequired ? tmpKeyword.substring(0, tmpKeyword.length() - 1) : tmpKeyword;
                Matcher dataTypeMatcher = DATA_TYPE_PATTERN.matcher(lineMatcher.group(2));
                if (!dataTypeMatcher.matches()) {
                    throw new IOException("Invalid type matching for line " + line);
                }
                this.format = dataTypeMatcher.group(2);
                this.dataType = DataType.valueOf(dataTypeMatcher.group(1));
                tmpValueExpression = lineMatcher.group(3) == null ? lineMatcher.group(4) : lineMatcher.group(3);
                Matcher matcher = EXPRESSION_PATTERN.matcher(tmpValueExpression);
                this.isExpression = matcher.matches();
                if (this.isExpression) {
                    String expression = matcher.group("exp");
                    String defaultExp = matcher.group("default");
                    if (defaultExp != null && !defaultExp.isEmpty()) {
                        tmpValueExpression = tmpValueExpression.replace(defaultExp, "");
                        this.defaultValue = (defaultExp = defaultExp.replace("|", "")) != null && defaultExp.equals("_NULL_") ? NULL : HeaderSpecification.coerce(defaultExp, this.dataType);
                    } else {
                        this.defaultValue = null;
                    }
                    Matcher inner_matcher = INNER_EXPRESSION_PATTERN.matcher(tmpValueExpression);
                    if (inner_matcher.matches() && !expression.equals(inner_matcher.group("value"))) {
                        tmpEvaluateOnTheFly = true;
                    }
                    if (!tmpEvaluateOnTheFly) {
                        String[] split = this.splitKey(expression);
                        tmpMetaMap = split[0];
                        tmpMetaName = split[1];
                        tmpValue = null;
                    }
                } else {
                    tmpMetaMap = null;
                    tmpMetaName = null;
                    tmpValue = tmpValueExpression != null && tmpValueExpression.equals("_NULL_") ? NULL : HeaderSpecification.coerce(tmpValueExpression, this.dataType);
                    this.defaultValue = null;
                }
                this.comment = lineMatcher.group(5).trim();
            }
            catch (IllegalArgumentException | FitsException x) {
                throw new IOException("Illegal token found while reading header specification", x);
            }
            this.metaName = tmpMetaName;
            this.value = tmpValue;
            this.metaMap = tmpMetaMap;
            this.valueExpression = tmpValueExpression;
            this.evaluateOnTheFly = tmpEvaluateOnTheFly;
            FitsHeadersSpecificationsBuilder.LOG.log(Level.FINEST, "HeaderLine {0} {1} {2} [{3}]", new Object[]{this.keyword, this.metaMap, this.metaName, this.originalLine});
        }

        public String getKeyword() {
            return this.keyword;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getFormat() {
            return this.format;
        }

        public String getMetaName() {
            return this.metaName;
        }

        String getMetaMap() {
            return this.metaMap;
        }

        public String getComment() {
            return this.comment;
        }

        boolean isExpression() {
            return this.isExpression;
        }

        boolean isRequired() {
            return this.isRequired;
        }

        String getHeaderDefinition() {
            return this.originalLine;
        }

        Object getValue(MetaDataSet metaDataSet) {
            Object val = null;
            if (this.evaluateOnTheFly) {
                Matcher matcher;
                String expressionToBeParsed = this.valueExpression;
                boolean done = false;
                while ((matcher = INNER_EXPRESSION_PATTERN.matcher(expressionToBeParsed)).matches()) {
                    String expressionToReplace = matcher.group("exp");
                    String key = matcher.group("value");
                    done = expressionToReplace.equals(expressionToBeParsed);
                    if (done) {
                        val = this.findMetaDataValue(key, metaDataSet, this.dataType);
                        break;
                    }
                    Object value = this.findMetaDataValue(key, metaDataSet, DataType.String);
                    if (value == null) {
                        throw new RuntimeException("Could not replace value " + key + " [" + expressionToReplace + "]");
                    }
                    try {
                        expressionToBeParsed = expressionToBeParsed.replace(expressionToReplace, (String)value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception parsing keyword " + this.keyword, e);
                    }
                }
                if (!done) {
                    val = this.findMetaDataValue(expressionToBeParsed, metaDataSet, this.dataType);
                }
            } else {
                val = this.isExpression ? this.findMetaDataValue(this.metaMap, this.metaName, metaDataSet, this.dataType) : this.value;
            }
            return val != null ? val : (this.defaultValue != null ? this.defaultValue : val);
        }

        private String[] splitKey(String key) {
            String[] result = new String[2];
            int dotIndex = key.indexOf(".");
            int slashIndex = key.indexOf("/");
            if (dotIndex == -1 || dotIndex != -1 && slashIndex != -1 && slashIndex < dotIndex) {
                result[0] = null;
                result[1] = key;
            } else {
                result[0] = key.substring(0, dotIndex);
                result[1] = key.substring(dotIndex + 1);
            }
            return result;
        }

        private Object findMetaDataValue(String key, MetaDataSet metaDataSet, DataType type) {
            String[] split = this.splitKey(key);
            String map = split[0];
            String name = split[1];
            return this.findMetaDataValue(map, name, metaDataSet, type);
        }

        private Object findMetaDataValue(String map, String name, MetaDataSet metaDataSet, DataType type) {
            Object obj = metaDataSet.getValue(map, name);
            if (obj instanceof String) {
                try {
                    obj = HeaderSpecification.coerce((String)obj, type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return obj;
        }
    }

    public static enum DataType {
        Boolean,
        Integer,
        String,
        Float,
        Date,
        MJD,
        DateTAI,
        DateUTC,
        MJDTAI,
        MJDUTC;

    }
}

