/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;

public class HeaderDescriptionTest {
    private static final List<String> nullableKeywords = new ArrayList<String>();

    @Test
    public void testGroups() throws IOException {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        HeaderSpecification desc = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("primary");
        boolean foundGroup = false;
        boolean foundLine = false;
        block0: for (HeaderSpecification.GroupLine gl : desc.getGroups()) {
            if (!gl.getGroupName().equals("someGroup")) continue;
            foundGroup = true;
            for (String comment : gl.getComments()) {
                if (!comment.equals("This is the group (someGroup) definition")) continue;
                foundLine = true;
                break block0;
            }
        }
        Assert.assertTrue((boolean)foundGroup);
        Assert.assertTrue((boolean)foundLine);
    }

    @Test
    public void testSpecFileRead() throws IOException {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        HeaderSpecification desc = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("primary");
        Collection headers = desc.getHeaders();
        Assert.assertEquals((long)40L, (long)headers.size());
        Assert.assertEquals((Object)"primary", (Object)desc.getName());
        HeaderSpecification.HeaderLine first = (HeaderSpecification.HeaderLine)headers.iterator().next();
        Assert.assertEquals((Object)HeaderSpecification.DataType.String, (Object)first.getDataType());
        Assert.assertEquals((Object)"ORIGIN", (Object)first.getKeyword());
        Assert.assertEquals((Object)1.0, (Object)desc.getHeader("CCDGAIN").getValue(null));
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("Origin", "Galaxy9");
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addMetaDataMap("primary", metaData);
        Assert.assertEquals((Object)"Galaxy9", (Object)first.getValue(metaDataSet));
        Assert.assertTrue((boolean)desc.getHeader("EMPTYDEF").getValue(null).equals(HeaderSpecification.NULL));
    }

    @Test
    public void testHeaderLine() throws IOException {
        String lineTemplate = "TEST Float   %s   comments";
        HeaderSpecification.HeaderLine lineOldTrending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8/R00/Reb0/DigV|3.4}"));
        Assert.assertEquals((Object)"ts8/R00/Reb0/DigV", (Object)lineOldTrending.getMetaName());
        Assert.assertNull((Object)lineOldTrending.getMetaMap());
        HeaderSpecification.HeaderLine lineNewTrending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8.R00/Reb0/DigV}"));
        Assert.assertEquals((Object)"R00/Reb0/DigV", (Object)lineNewTrending.getMetaName());
        Assert.assertEquals((Object)"ts8", (Object)lineNewTrending.getMetaMap());
        HeaderSpecification.HeaderLine lineOldTS8Trending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8/R00.Reb0.DigV}"));
        Assert.assertEquals((Object)"ts8/R00.Reb0.DigV", (Object)lineOldTS8Trending.getMetaName());
        Assert.assertNull((Object)lineOldTS8Trending.getMetaMap());
        HeaderSpecification.HeaderLine lineOldTS8TrendingWithDash = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8-a/R00.Reb0.DigV}"));
        Assert.assertEquals((Object)"ts8-a/R00.Reb0.DigV", (Object)lineOldTS8TrendingWithDash.getMetaName());
        Assert.assertNull((Object)lineOldTS8TrendingWithDash.getMetaMap());
        HeaderSpecification.HeaderLine lineTemporaryTS8Trending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8.R00.Reb0.DigV}"));
        Assert.assertEquals((Object)"R00.Reb0.DigV", (Object)lineTemporaryTS8Trending.getMetaName());
        Assert.assertEquals((Object)"ts8", (Object)lineTemporaryTS8Trending.getMetaMap());
        HeaderSpecification.HeaderLine lineTemporaryTS8TrendingWithDash = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8-a.R00.Reb0.DigV}"));
        Assert.assertEquals((Object)"R00.Reb0.DigV", (Object)lineTemporaryTS8TrendingWithDash.getMetaName());
        Assert.assertEquals((Object)"ts8-a", (Object)lineTemporaryTS8TrendingWithDash.getMetaMap());
    }

    @Test
    public void testWcsCoordinates() throws Exception {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        FocalPlane fp = FocalPlane.createFocalPlane((String)"[R33:[ccdType:e2v],R12:[ccdType:itl],R44]");
        for (Raft r : fp.getRafts()) {
            for (CCD ccd : r.getChildrenList()) {
                GeometryFitsHeaderMetadataProvider mdp = new GeometryFitsHeaderMetadataProvider(ccd);
                MetaDataSet metaDataSet = mdp.getPrimaryHeaderMetadata();
                HeaderSpecification spec = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("primary");
                this.testKeywords(spec, metaDataSet, true);
                for (String segName : ccd.getSegmentNames()) {
                    MetaDataSet segMetaDataSet = mdp.getDataExtendedHeaderMetadata(segName);
                    HeaderSpecification segSpec = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("extended");
                    this.testKeywords(segSpec, segMetaDataSet, false);
                }
            }
        }
    }

    private void testKeywords(HeaderSpecification spec, MetaDataSet metaDataSet, boolean allowForNulls) throws Exception {
        block9: for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            String keyword = header.getKeyword();
            if (nullableKeywords.contains(keyword)) continue;
            Object value = header.getValue(metaDataSet);
            try {
                if (value != null) {
                    switch (header.getDataType()) {
                        case Integer: {
                            int intValue = ((Number)value).intValue();
                            break;
                        }
                        case Float: {
                            double data = ((Number)value).doubleValue();
                            if (Double.isFinite(data)) continue block9;
                            throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                        }
                        case Boolean: {
                            boolean boolValue = (Boolean)value;
                            break;
                        }
                        case Date: {
                            String dateValue = DateUtils.convertTemporalToString((Object)value);
                            break;
                        }
                        case MJD: {
                            double mjdValue = DateUtils.convertTemporalToMJD((Object)value);
                            break;
                        }
                    }
                    continue;
                }
                if (allowForNulls) continue;
                throw new RuntimeException("NULL FOR " + header.getKeyword());
            }
            catch (ClassCastException x) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", header.getKeyword(), value, value.getClass(), header.getDataType()));
            }
        }
    }

    static {
        nullableKeywords.add("NAXIS");
        nullableKeywords.add("NAXIS1");
        nullableKeywords.add("NAXIS2");
        nullableKeywords.add("HEADVER");
        nullableKeywords.add("CHANNEL");
        nullableKeywords.add("EXTNAME");
        nullableKeywords.add("CCDSUM");
        nullableKeywords.add("AVERAGE");
        nullableKeywords.add("AVGBIAS");
        nullableKeywords.add("AVWOBIAS");
        nullableKeywords.add("STDVBIAS");
        nullableKeywords.add("STDEV");
        nullableKeywords.add("CCDSLOT");
        nullableKeywords.add("RAFTBAY");
        nullableKeywords.add("BINX");
        nullableKeywords.add("BINY");
        nullableKeywords.add("CCDGAIN");
        nullableKeywords.add("CCDNOISE");
    }
}

