/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.junit.Test;
import org.lsst.ccs.utilities.image.DateUtils;

public class DateUtilsTest {
    @Test
    public void testMJDConverter() throws ParseException {
        String[] testData = new String[]{"Month          1997\t1998\t1999\t2000", "January\t50448\t50813\t51178\t51543", "February\t50479\t50844   51209\t51574", "March          50507\t50872\t51237\t51603", "April          50538\t50903\t51268\t51634", "May            50568\t50933\t51298\t51664", "June           50599\t50964\t51329\t51695", "July           50629\t50994\t51359\t51725", "August         50660\t51025\t51390\t51756", "September\t50691\t51056\t51421\t51787", "October\t50721\t51086\t51451\t51817", "November\t50752\t51117\t51482\t51848", "December\t50782\t51147\t51512\t51878"};
        SimpleDateFormat sdf = new SimpleDateFormat("MMM-yyyy-dd hh:mm z", Locale.US);
        String[] header = testData[0].split("\\s+");
        for (int i = 1; i < testData.length; ++i) {
            String[] tokens = testData[i].split("\\s+");
            for (int j = 1; j < tokens.length; ++j) {
                Date date = sdf.parse(tokens[0] + "-" + header[j] + "-01 00:00 UTC");
                double mjd = DateUtils.convertTemporalToMJD((Object)date);
                TestCase.assertEquals((double)(Double.parseDouble(tokens[j]) + 1.0), (double)mjd, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testPrecision() {
        long January_1_2025 = 1735689600L;
        Instant instant = Instant.ofEpochSecond(January_1_2025, 500500500L);
        double mjd = DateUtils.convertTemporalToMJD((Object)instant);
        int day_mjd = (int)mjd;
        TestCase.assertEquals((int)60676, (int)day_mjd);
        int micro_mjd = (int)((mjd - (double)day_mjd) * 24.0 * 60.0 * 60.0 * 1000000.0);
        TestCase.assertEquals((int)500500, (int)micro_mjd);
        System.out.println(mjd);
        String fitsDate = DateUtils.convertTemporalToString((Object)instant);
        System.out.println(fitsDate);
        TestCase.assertEquals((String)"2025-01-01T00:00:00.501", (String)fitsDate);
    }
}

