package org.lsst.ccs.utilities.image;

import java.util.List;

/**
 * An implementation of FitsHeaderMetadataProvider that allows multiple providers
 * to be added to it. It is responsible to combining the resulting maps.
 *
 * @author The LSST CCS Team
 */
class CompositeFitsHeaderMetadataProvider implements FitsHeaderMetadataProvider {

    private final List<FitsHeaderMetadataProvider> providers;

    public CompositeFitsHeaderMetadataProvider(List<FitsHeaderMetadataProvider> providers) {
        this.providers = providers;
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata() {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getPrimaryHeaderMetadata());
        }
        return resultingHeaderMetadata;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(String imageExtensionName) {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getDataExtendedHeaderMetadata(imageExtensionName));
        }
        return resultingHeaderMetadata;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getAdditionalExtendedHeaderMetadata(extendedKeyword));
        }
        return resultingHeaderMetadata;
    }
}
